/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.UUID;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

class DatabaseTransactionEventListenersTest {
    DatabaseTransactionEventListenersTest() {
    }

    @Test
    void shouldUnregisterRemainingListenerOnShutdown() {
        GlobalTransactionEventListeners globalListeners = (GlobalTransactionEventListeners)Mockito.mock(GlobalTransactionEventListeners.class);
        NamedDatabaseId databaseId = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        DatabaseTransactionEventListeners listeners = new DatabaseTransactionEventListeners((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class), globalListeners, databaseId);
        TransactionEventListener firstListener = (TransactionEventListener)Mockito.mock(TransactionEventListener.class);
        TransactionEventListener secondListener = (TransactionEventListener)Mockito.mock(TransactionEventListener.class);
        listeners.registerTransactionEventListener(firstListener);
        listeners.registerTransactionEventListener(secondListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).registerTransactionEventListener(databaseId.name(), firstListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).registerTransactionEventListener(databaseId.name(), secondListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
        listeners.unregisterTransactionEventListener(firstListener);
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).unregisterTransactionEventListener(databaseId.name(), firstListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
        listeners.shutdown();
        ((GlobalTransactionEventListeners)Mockito.verify((Object)globalListeners)).unregisterTransactionEventListener(databaseId.name(), secondListener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{globalListeners});
    }

    @Test
    void shouldCloseTxSnapshotAfterCommit() {
        this.shouldCloseTxSnapshot(DatabaseTransactionEventListeners::afterCommit);
    }

    @Test
    void shouldCloseTxSnapshotAfterRollback() {
        this.shouldCloseTxSnapshot(DatabaseTransactionEventListeners::afterRollback);
    }

    private void shouldCloseTxSnapshot(BiConsumer<DatabaseTransactionEventListeners, TransactionListenersState> txAction) {
        GlobalTransactionEventListeners globalListeners = new GlobalTransactionEventListeners();
        NamedDatabaseId databaseId = DatabaseIdFactory.from((String)"foo", (UUID)UUID.randomUUID());
        DatabaseTransactionEventListeners listeners = new DatabaseTransactionEventListeners((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class), globalListeners, databaseId);
        TransactionEventListener listener = (TransactionEventListener)Mockito.mock(TransactionEventListener.class);
        listeners.registerTransactionEventListener(listener);
        TxState txState = new TxState();
        txState.relationshipDoCreate(1L, 2, 3L, 4L);
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)kernelTransaction.memoryTracker()).thenReturn((Object)EmptyMemoryTracker.INSTANCE);
        Mockito.when((Object)kernelTransaction.internalTransaction()).thenReturn((Object)internalTransaction);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        StorageRelationshipScanCursor relationshipScanCursor = (StorageRelationshipScanCursor)Mockito.mock(StorageRelationshipScanCursor.class);
        Mockito.when((Object)storageReader.allocateRelationshipScanCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenReturn((Object)relationshipScanCursor);
        Mockito.when((Object)internalTransaction.newRelationshipEntity(ArgumentMatchers.anyLong())).then(invocationOnMock -> new RelationshipEntity(internalTransaction, ((Long)invocationOnMock.getArgument(0, Long.class)).longValue()));
        TransactionListenersState state = listeners.beforeCommit((ReadableTransactionState)txState, kernelTransaction, storageReader);
        txAction.accept(listeners, state);
        ((StorageRelationshipScanCursor)Mockito.verify((Object)relationshipScanCursor)).close();
    }
}

