/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ListBasedBlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.MergingBlockEntryReader;
import org.neo4j.util.Preconditions;

class BlockEntryStreamMerger<KEY, VALUE>
implements BlockEntryCursor<KEY, VALUE>,
Callable<Void> {
    static final int QUEUE_SIZE = 10;
    private final List<BlockEntryCursor<KEY, VALUE>> input;
    private final Layout<KEY, VALUE> layout;
    private final BlockStorage.Cancellation cancellation;
    private final ArrayBlockingQueue<BlockEntryCursor<KEY, VALUE>> mergedOutput;
    private final int batchSize;
    private final Comparator<KEY> samplingComparator;
    private KEY prevKey;
    private long sampledValues;
    private long uniqueValues;
    private volatile boolean halted;
    private BlockEntryCursor<KEY, VALUE> currentOutput;

    BlockEntryStreamMerger(List<BlockEntryCursor<KEY, VALUE>> input, Layout<KEY, VALUE> layout, Comparator<KEY> samplingComparator, BlockStorage.Cancellation cancellation, int batchSize, int queueSize) {
        this.input = input;
        this.layout = layout;
        this.cancellation = cancellation;
        this.batchSize = batchSize;
        this.mergedOutput = new ArrayBlockingQueue(queueSize);
        this.samplingComparator = samplingComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws IOException {
        try {
            MergingBlockEntryReader<KEY, VALUE> mergingReader = new MergingBlockEntryReader<KEY, VALUE>(this.layout);
            this.input.forEach(mergingReader::addSource);
            ArrayList<BlockEntry<KEY, VALUE>> merged = new ArrayList<BlockEntry<KEY, VALUE>>(this.batchSize);
            while (this.alive() && mergingReader.next()) {
                merged.add(new BlockEntry<KEY, VALUE>(mergingReader.key(), mergingReader.value()));
                if (merged.size() != this.batchSize) continue;
                this.offer(merged);
                merged = new ArrayList(this.batchSize);
            }
            if (!merged.isEmpty()) {
                this.offer(merged);
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.halted = true;
        }
    }

    @Override
    public boolean next() throws IOException {
        do {
            if (this.currentOutput != null && this.currentOutput.next()) {
                return true;
            }
            this.currentOutput = this.nextOutputBatchOrNull();
        } while (this.currentOutput != null);
        return false;
    }

    @Override
    public KEY key() {
        return this.currentOutput.key();
    }

    @Override
    public VALUE value() {
        return this.currentOutput.value();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.input);
    }

    private boolean alive() {
        return !this.halted && !this.cancellation.cancelled();
    }

    private void offer(List<BlockEntry<KEY, VALUE>> entries) {
        if (this.samplingComparator != null) {
            this.includeInSample(entries);
        }
        ListBasedBlockEntryCursor<KEY, VALUE> batch = new ListBasedBlockEntryCursor<KEY, VALUE>(entries);
        try {
            while (this.alive() && !this.mergedOutput.offer(batch, 10L, TimeUnit.MILLISECONDS)) {
                Thread.onSpinWait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.halted = true;
        }
    }

    void halt() {
        this.halted = true;
    }

    private void includeInSample(List<BlockEntry<KEY, VALUE>> entries) {
        for (BlockEntry<KEY, VALUE> entry : entries) {
            KEY key = entry.key();
            if (this.prevKey == null || this.samplingComparator.compare(key, this.prevKey) != 0) {
                this.prevKey = key;
                ++this.uniqueValues;
            }
            ++this.sampledValues;
        }
    }

    IndexSample buildIndexSample() {
        Preconditions.checkState((this.samplingComparator != null ? 1 : 0) != 0, (String)"I haven't been sampling at all");
        return new IndexSample(this.sampledValues, this.uniqueValues, this.sampledValues);
    }

    private BlockEntryCursor<KEY, VALUE> nextOutputBatchOrNull() {
        while (this.alive() || !this.mergedOutput.isEmpty()) {
            try {
                BlockEntryCursor<KEY, VALUE> result = this.mergedOutput.poll(10L, TimeUnit.MILLISECONDS);
                if (result == null) continue;
                return result;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

