/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;

enum MigrationStatus {
    migrating,
    moving,
    completed;


    public boolean isNeededFor(MigrationStatus current) {
        return current == null || this.ordinal() >= current.ordinal();
    }

    public String maybeReadInfo(FileSystemAbstraction fs, Path stateFile, String currentInfo) {
        if (currentInfo != null) {
            return currentInfo;
        }
        Pair<String, String> data = MigrationStatus.readFromFile(fs, stateFile, this);
        return data == null ? null : (String)data.other();
    }

    public static MigrationStatus readMigrationStatus(FileSystemAbstraction fs, Path stateFile) {
        Pair<String, String> data = MigrationStatus.readFromFile(fs, stateFile, null);
        if (data == null) {
            return null;
        }
        return MigrationStatus.valueOf((String)data.first());
    }

    private static Pair<String, String> readFromFile(FileSystemAbstraction fs, Path path, MigrationStatus expectedSate) {
        Pair pair;
        block10: {
            Reader reader = fs.openAsReader(path, StandardCharsets.UTF_8);
            try {
                LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
                String state = lineIterator.next().trim();
                if (expectedSate != null && !expectedSate.name().equals(state)) {
                    throw new IllegalStateException("Not in the expected state, expected=" + expectedSate.name() + ", actual=" + state);
                }
                String info = lineIterator.next().trim();
                pair = Pair.of((Object)state, (Object)info);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return pair;
    }

    public void setMigrationStatus(FileSystemAbstraction fs, Path stateFile, String info) {
        if (fs.fileExists(stateFile)) {
            try {
                fs.truncate(stateFile, 0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (Writer writer = fs.openAsWriter(stateFile, StandardCharsets.UTF_8, false);){
            writer.write(this.name());
            writer.write(10);
            writer.write(info);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

