/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Iterator;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class HeapTrackingArrayListTrackingTest {
    @Inject
    private RandomSupport rnd;
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final HeapTrackingArrayList<Long> list = HeapTrackingArrayList.newArrayList((int)16, (MemoryTracker)this.memoryTracker);

    HeapTrackingArrayListTrackingTest() {
    }

    @AfterEach
    void tearDown() {
        this.list.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void addAndIterateElements() {
        long iterations = this.rnd.nextLong(10L, 1000L);
        int i = 0;
        while ((long)i < iterations) {
            this.list.add((Object)i);
            ++i;
        }
        long itemSize = this.meter.measure((Object)1L) * iterations;
        long actualSize = this.meter.measureDeep(this.list) - this.meter.measureDeep((Object)this.memoryTracker) - itemSize;
        Assertions.assertEquals((long)actualSize, (long)this.memoryTracker.estimatedHeapMemory());
        Iterator iterator = this.list.iterator();
        int i2 = 0;
        while ((long)i2 < iterations) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((long)i2, (Long)((Long)iterator.next()));
            ++i2;
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

