/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTestCases;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.ValueType;

abstract class NativeUniqueIndexPopulatorTest<KEY extends NativeIndexKey<KEY>>
extends NativeIndexPopulatorTests<KEY> {
    private final IndexDescriptor uniqueDescriptor = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)42, (int[])new int[]{666})).withName("constraint").withIndexType(this.indexType()).materialise(0L);
    private final NativeIndexPopulatorTestCases.PopulatorFactory<KEY> populatorFactory;
    private final ValueType[] typesOfGroup;

    NativeUniqueIndexPopulatorTest(NativeIndexPopulatorTestCases.PopulatorFactory<KEY> populatorFactory, ValueType[] typesOfGroup, IndexLayout<KEY> layout) {
        this.populatorFactory = populatorFactory;
        this.typesOfGroup = typesOfGroup;
        this.layout = layout;
    }

    abstract IndexType indexType();

    NativeIndexPopulator<KEY> createPopulator(PageCache pageCache) throws IOException {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        return this.populatorFactory.create(context, this.indexFiles, (IndexLayout)this.layout, this.indexDescriptor, this.tokenNameLookup);
    }

    @Override
    ValueCreatorUtil<KEY> createValueCreatorUtil() {
        return new ValueCreatorUtil(this.uniqueDescriptor, this.typesOfGroup, 0.0);
    }

    @Override
    IndexLayout<KEY> layout() {
        return (IndexLayout)this.layout;
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return this.uniqueDescriptor;
    }

    @Test
    void addShouldThrowOnDuplicateValues() throws IOException {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        Assertions.assertThrows(IndexEntryConflictException.class, () -> {
            this.populator.add(Arrays.asList(updates), CursorContext.NULL);
            this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        });
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void updaterShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdatesWithDuplicateValues(this.random);
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
            updater.process(update);
        }
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            updater.close();
            this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        });
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IndexEntryConflictException.class), (String)e.getMessage());
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void shouldSampleUpdates() throws Exception {
        this.populator.create();
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.valueCreatorUtil.someUpdates(this.random);
        this.populator.add(Arrays.asList(updates), CursorContext.NULL);
        for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
            this.populator.includeSample(update);
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        IndexSample sample = this.populator.sample(CursorContext.NULL);
        Assertions.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assertions.assertEquals((long)updates.length, (long)sample.uniqueValues());
        Assertions.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true, CursorContext.NULL);
    }
}

