/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppenderFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabasePanicEventGenerator;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogAppendAndRotateIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private DatabaseLayout databaseLayout;
    private ThreadPoolJobScheduler jobScheduler;

    TransactionLogAppendAndRotateIT() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
        this.jobScheduler.close();
    }

    @Test
    void shouldKeepTransactionsIntactWhenConcurrentlyRotationAndAppending() throws Throwable {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        Monitors monitors = new Monitors();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)logVersionRepository).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withMonitors(monitors).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)logFiles);
        AtomicBoolean end = new AtomicBoolean();
        TestLogFileMonitor monitoring = new TestLogFileMonitor(end, 100, logFiles.getLogFile());
        monitors.addMonitorListener((Object)monitoring, new String[0]);
        SimpleTransactionIdStore txIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        DatabaseHealth health = new DatabaseHealth((PanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance());
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createBatchAppender(logFiles, txIdStore, metadataCache, (Health)health, (JobScheduler)this.jobScheduler, Config.defaults()));
        Race race = new Race();
        for (int i = 0; i < 4; ++i) {
            race.addContestant(() -> {
                while (!end.get()) {
                    try {
                        appender.append(new TransactionToApply(TransactionLogAppendAndRotateIT.sillyTransaction(1000), CursorContext.NULL, StoreCursors.NULL), LogAppendEvent.NULL);
                    }
                    catch (Exception e) {
                        end.set(true);
                        Assertions.fail((String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        race.addContestant(TransactionLogAppendAndRotateIT.endAfterMax(250, TimeUnit.MILLISECONDS, end, monitoring));
        race.go();
        Assertions.assertTrue((monitoring.numberOfRotations() > 0 ? 1 : 0) != 0);
    }

    private TransactionAppender createBatchAppender(LogFiles logFiles, TransactionIdStore txIdStore, TransactionMetadataCache metadataCache, Health health, JobScheduler jobScheduler, Config config) {
        return TransactionAppenderFactory.createTransactionAppender((LogFiles)logFiles, (TransactionIdStore)txIdStore, (TransactionMetadataCache)metadataCache, (Config)config, (Health)health, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance());
    }

    private static Runnable endAfterMax(int time, TimeUnit unit, AtomicBoolean end, TestLogFileMonitor monitoring) {
        return () -> {
            while (monitoring.numberOfRotations() < 2 && !end.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            }
            long endTime = System.currentTimeMillis() + unit.toMillis(time);
            while (System.currentTimeMillis() < endTime && !end.get()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
            }
            end.set(true);
        };
    }

    private static void assertWholeTransactionsIn(LogFile logFile, long logVersion) throws IOException {
        try (ReadableLogChannel reader = logFile.getReader(new LogPosition(logVersion, 64L));){
            LogEntry entry;
            LogEntryReader entryReader = TestLogEntryReader.logEntryReader();
            boolean inTx = false;
            int transactions = 0;
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader)) != null) {
                if (!inTx) {
                    Assertions.assertTrue((boolean)(entry instanceof LogEntryStart));
                    inTx = true;
                    continue;
                }
                Assertions.assertTrue((entry instanceof LogEntryCommand || entry instanceof LogEntryCommit ? 1 : 0) != 0);
                if (!(entry instanceof LogEntryCommit)) continue;
                inTx = false;
                ++transactions;
            }
            Assertions.assertFalse((boolean)inTx);
            Assertions.assertTrue((transactions > 0 ? 1 : 0) != 0);
        }
    }

    private static TransactionRepresentation sillyTransaction(int size) {
        ArrayList<TestCommand> commands = new ArrayList<TestCommand>(size);
        for (int i = 0; i < size; ++i) {
            commands.add(new TestCommand(30));
            commands.add(new TestCommand(60));
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        return tx;
    }

    private static class TestLogFileMonitor
    extends LogRotationMonitorAdapter {
        private final AtomicBoolean end;
        private final int maxNumberOfRotations;
        private final LogFile logFile;
        private final AtomicInteger rotations = new AtomicInteger();

        TestLogFileMonitor(AtomicBoolean end, int maxNumberOfRotations, LogFile logFile) {
            this.end = end;
            this.maxNumberOfRotations = maxNumberOfRotations;
            this.logFile = logFile;
        }

        public void finishLogRotation(Path logFile, long logVersion, long lastTransactionId, long rotationMillis, long millisSinceLastRotation) {
            try {
                TransactionLogAppendAndRotateIT.assertWholeTransactionsIn(this.logFile, logVersion);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.rotations.getAndIncrement() > this.maxNumberOfRotations) {
                    this.end.set(true);
                }
            }
        }

        int numberOfRotations() {
            return this.rotations.get();
        }
    }
}

