/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
class LogFilesBuilderTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private Path storeDirectory;

    LogFilesBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.storeDirectory = this.testDirectory.homePath();
    }

    @Test
    void buildActiveFilesOnlyContext() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache).withLogEntryReader(TestLogEntryReader.logEntryReader()).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).buildContext();
        Assertions.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assertions.assertNotNull((Object)context.getLogEntryReader());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)context.getRotationThreshold().get());
        Assertions.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assertions.assertEquals((long)0L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    void buildFilesBasedContext() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withLogEntryReader(TestLogEntryReader.logEntryReader()).buildContext();
        Assertions.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
    }

    @Test
    void buildDefaultContext() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository(2L)).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader(TestLogEntryReader.logEntryReader()).buildContext();
        Assertions.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assertions.assertNotNull((Object)context.getLogEntryReader());
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)250L), (long)context.getRotationThreshold().get());
        Assertions.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assertions.assertEquals((long)2L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    void buildContextWithRotationThreshold() throws IOException {
        TransactionLogFilesContext context = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository(2L)).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader(TestLogEntryReader.logEntryReader()).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).buildContext();
        Assertions.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assertions.assertNotNull((Object)context.getLogEntryReader());
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)context.getRotationThreshold().get());
        Assertions.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assertions.assertEquals((long)2L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    void buildDefaultContextWithDependencies() throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository(2L);
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, (Log)NullLog.getInstance());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)logVersionRepository);
        dependencies.satisfyDependency((Object)transactionIdStore);
        dependencies.satisfyDependency((Object)databaseHealth);
        TransactionLogFilesContext context = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withDependencies((DependencyResolver)dependencies).withLogEntryReader(TestLogEntryReader.logEntryReader()).buildContext();
        Assertions.assertEquals((Object)this.fileSystem, (Object)context.getFileSystem());
        Assertions.assertNotNull((Object)context.getLogEntryReader());
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)250L), (long)context.getRotationThreshold().get());
        Assertions.assertEquals((Object)databaseHealth, (Object)context.getDatabaseHealth());
        Assertions.assertEquals((long)1L, (long)context.getLastCommittedTransactionId());
        Assertions.assertEquals((long)2L, (long)context.getLogVersionRepository().getCurrentLogVersion());
    }

    @Test
    void buildContextWithCustomAbsoluteLogFilesLocations() throws Throwable {
        Path customLogDirectory = this.testDirectory.directory("absoluteCustomLogDirectory");
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)customLogDirectory.toAbsolutePath()).build();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)DatabaseLayout.of((Config)config), (FileSystemAbstraction)this.fileSystem).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        logFiles.init();
        logFiles.start();
        Assertions.assertEquals((Object)customLogDirectory.resolve(this.databaseLayout.getDatabaseName()), (Object)logFiles.getLogFile().getHighestLogFile().getParent());
        logFiles.shutdown();
    }

    @Test
    void failToBuildFullContextWithoutLogVersionRepo() {
        Assertions.assertThrows(NullPointerException.class, () -> LogFilesBuilderTest.builderWithTestLogReader(this.databaseLayout, this.fileSystem).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).buildContext());
    }

    @Test
    void failToBuildFullContextWithoutTransactionIdStore() {
        Assertions.assertThrows(NullPointerException.class, () -> LogFilesBuilderTest.builderWithTestLogReader(this.databaseLayout, this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository(2L)).buildContext());
    }

    @Test
    void fileBasedOperationsContextFailOnLastCommittedTransactionIdAccess() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withLogEntryReader(TestLogEntryReader.logEntryReader()).buildContext().getLastCommittedTransactionId());
    }

    @Test
    void fileBasedOperationsContextFailOnLogVersionRepositoryAccess() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.storeDirectory, (FileSystemAbstraction)this.fileSystem).withLogEntryReader(TestLogEntryReader.logEntryReader()).buildContext().getLogVersionRepository());
    }

    private static LogFilesBuilder builderWithTestLogReader(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        return LogFilesBuilder.builder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)fileSystem).withLogEntryReader(TestLogEntryReader.logEntryReader());
    }
}

