/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;

class EntityTokenUpdatesTest {
    private static final long ENTITY_ID = 0L;
    private static final int TOKEN_1_ID = 0;
    private static final int TOKEN_2_ID = 1;
    private static final long[] EMPTY = new long[0];

    EntityTokenUpdatesTest() {
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdatesForEmptyEntityUpdates(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).build();
        Assertions.assertThat((Optional)updates.tokenUpdateForIndexKey(entity.getTokenIndex(), -1L)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdateForExistingToken(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(new long[]{0L}).build();
        Assertions.assertThat((Optional)updates.tokenUpdateForIndexKey(entity.getTokenIndex(), -1L)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForAddedTokens(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(new long[]{0L, 1L}).build();
        Assertions.assertThat((Optional)updates.tokenUpdateForIndexKey(entity.getTokenIndex(), -1L)).contains((Object)IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.getTokenIndex(), (long[])EMPTY, (long[])new long[]{0L, 1L}));
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForChangedTokens(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(new long[]{0L}).withTokensAfter(new long[]{0L, 1L}).build();
        Assertions.assertThat((Optional)updates.tokenUpdateForIndexKey(entity.getTokenIndex(), -1L)).contains((Object)IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.getTokenIndex(), (long[])new long[]{0L}, (long[])new long[]{0L, 1L}));
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForRemovedTokens(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(new long[]{0L, 1L}).withTokensAfter(EMPTY).build();
        Assertions.assertThat((Optional)updates.tokenUpdateForIndexKey(entity.getTokenIndex(), -1L)).contains((Object)IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.getTokenIndex(), (long[])new long[]{0L, 1L}, (long[])EMPTY));
    }

    private static enum Entity {
        NODE{

            @Override
            SchemaDescriptorSupplier getTokenIndex() {
                return () -> SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            SchemaDescriptorSupplier getTokenIndex() {
                return () -> SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP);
            }
        };


        abstract SchemaDescriptorSupplier getTokenIndex();
    }
}

