/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.impl.api.DatabaseTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.StorageEngine;

class CommunityCommitProcessFactoryTest {
    CommunityCommitProcessFactoryTest() {
    }

    @Test
    void createRegularCommitProcessWhenWritable() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()), DatabaseReadOnlyChecker.writable(), (DatabaseHealth)Mockito.mock(DatabaseHealth.class));
        Assertions.assertThat((Object)commitProcess).isInstanceOf(DatabaseTransactionCommitProcess.class);
    }

    @Test
    void createRegularCommitProcessWhenDynamicallyReadOnly() {
        CommunityCommitProcessFactory factory = new CommunityCommitProcessFactory();
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()), DatabaseReadOnlyChecker.readOnly(), (DatabaseHealth)Mockito.mock(DatabaseHealth.class));
        Assertions.assertThat((Object)commitProcess).isInstanceOf(DatabaseTransactionCommitProcess.class);
    }
}

