/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.ValueGroup;

public class NativeValueIndexUtility<KEY extends NativeIndexKey<KEY>> {
    private final ValueCreatorUtil<KEY> valueCreatorUtil;
    private final Layout<KEY, NullValue> layout;

    public NativeValueIndexUtility(ValueCreatorUtil<KEY> valueCreatorUtil, Layout<KEY, NullValue> layout) {
        this.valueCreatorUtil = valueCreatorUtil;
        this.layout = layout;
    }

    void verifyUpdates(ValueIndexEntryUpdate<IndexDescriptor>[] updates, Supplier<GBPTree<KEY, NullValue>> treeProvider) throws IOException {
        List<KEY> expectedHits = this.convertToHits(updates, this.layout);
        ArrayList<KEY> actualHits = new ArrayList<KEY>();
        try (GBPTree<KEY, NullValue> tree = treeProvider.get();
             Seeker<KEY, NullValue> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy(scan));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare(h1, h2);
            if (keyCompare == 0) {
                return this.valueCreatorUtil.compareIndexedPropertyValue((NativeIndexKey)h1, (NativeIndexKey)h2);
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits, hitComparator);
    }

    private Seeker<KEY, NullValue> scan(GBPTree<KEY, NullValue> tree) throws IOException {
        NativeIndexKey lowest = (NativeIndexKey)this.layout.newKey();
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValueAsLowest(0, ValueGroup.UNKNOWN);
        NativeIndexKey highest = (NativeIndexKey)this.layout.newKey();
        highest.initialize(Long.MAX_VALUE);
        highest.initValueAsHighest(0, ValueGroup.UNKNOWN);
        return tree.seek((Object)lowest, (Object)highest, CursorContext.NULL);
    }

    private void assertSameHits(List<KEY> expectedHits, List<KEY> actualHits, Comparator<KEY> comparator) {
        expectedHits.sort(comparator);
        actualHits.sort(comparator);
        Assertions.assertEquals((int)expectedHits.size(), (int)actualHits.size(), (String)String.format("Array length differ%nExpected:%d, Actual:%d", expectedHits.size(), actualHits.size()));
        for (int i = 0; i < expectedHits.size(); ++i) {
            NativeIndexKey expected = (NativeIndexKey)expectedHits.get(i);
            NativeIndexKey actual = (NativeIndexKey)actualHits.get(i);
            Assertions.assertEquals((int)0, (int)comparator.compare(expected, actual), (String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual));
        }
    }

    private KEY deepCopy(Seeker<KEY, NullValue> from) {
        NativeIndexKey intoKey = (NativeIndexKey)this.layout.newKey();
        this.layout.copyKey((Object)((NativeIndexKey)from.key()), (Object)intoKey);
        return (KEY)intoKey;
    }

    private List<KEY> convertToHits(ValueIndexEntryUpdate<IndexDescriptor>[] updates, Layout<KEY, NullValue> layout) {
        ArrayList<NativeIndexKey> hits = new ArrayList<NativeIndexKey>(updates.length);
        for (ValueIndexEntryUpdate<IndexDescriptor> u : updates) {
            NativeIndexKey key = (NativeIndexKey)layout.newKey();
            key.initialize(u.getEntityId());
            for (int i = 0; i < u.values().length; ++i) {
                key.initFromValue(i, u.values()[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            hits.add(key);
        }
        return hits;
    }
}

