/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.RandomSupport;

public class TokenIndexUtility {
    static final long[] TOKENS = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};

    static void verifyUpdates(MutableLongObjectMap<long[]> expected, TokenScanLayout layout, Supplier<GBPTree<TokenScanKey, TokenScanValue>> treeSupplier) throws IOException {
        try (GBPTree<TokenScanKey, TokenScanValue> tree = treeSupplier.get();
             Seeker<TokenScanKey, TokenScanValue> scan = TokenIndexUtility.scan(tree, layout);){
            while (scan.next()) {
                TokenScanKey key = (TokenScanKey)scan.key();
                TokenScanValue value = (TokenScanValue)scan.value();
                long entityIdBase = key.idRange * 64L;
                for (int i = 0; i < 64; ++i) {
                    long mask = 1L << i;
                    long posInBits = value.bits & mask;
                    if (posInBits == 0L) continue;
                    long entity = entityIdBase + (long)i;
                    long[] tokens = (long[])expected.remove(entity);
                    ((AbstractLongArrayAssert)Assertions.assertThat((long[])tokens).withFailMessage("Entity " + entity + " contained unexpected token " + key.tokenId + " in tree", new Object[0])).contains(new long[]{key.tokenId});
                    if (tokens.length == 1) continue;
                    expected.put(entity, (Object)ArrayUtils.removeElement((long[])tokens, (long)key.tokenId));
                }
            }
        }
        expected.forEachKeyValue((LongObjectProcedure & Serializable)(entityId, tokenIds) -> ((AbstractLongArrayAssert)Assertions.assertThat((long[])tokenIds).withFailMessage("Tokens " + Arrays.toString(tokenIds) + " not found in tree for entity " + entityId, new Object[0])).isEmpty());
    }

    private static Seeker<TokenScanKey, TokenScanValue> scan(GBPTree<TokenScanKey, TokenScanValue> tree, TokenScanLayout layout) throws IOException {
        TokenScanKey lowest = layout.newKey();
        layout.initializeAsLowest(lowest);
        TokenScanKey highest = layout.newKey();
        layout.initializeAsHighest(highest);
        return tree.seek((Object)lowest, (Object)highest, CursorContext.NULL);
    }

    static List<TokenIndexEntryUpdate<?>> generateSomeRandomUpdates(MutableLongObjectMap<long[]> entityTokens, RandomSupport random) {
        long currentScanId = 0L;
        ArrayList updates = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            TokenIndexUtility.generateRandomUpdate(currentScanId, entityTokens, updates, random);
            ++currentScanId;
        }
        return updates;
    }

    static void generateRandomUpdate(long entityId, MutableLongObjectMap<long[]> trackingState, List<TokenIndexEntryUpdate<?>> updates, RandomSupport random) {
        long[] addTokens = TokenIndexUtility.generateRandomTokens(random);
        if (addTokens.length != 0) {
            TokenIndexEntryUpdate update = IndexEntryUpdate.change((long)entityId, null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])addTokens);
            updates.add(update);
            trackingState.put(entityId, (Object)Arrays.copyOf(addTokens, addTokens.length));
        }
    }

    static long[] generateRandomTokens(RandomSupport random) {
        long[] allTokens = TOKENS;
        double[] allTokensRatio = new double[]{0.9, 0.8, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.01, 0.001};
        double emptyRatio = 0.1;
        if (random.nextDouble() < emptyRatio) {
            return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
        LongArrayList longArrayList = new LongArrayList();
        for (int i = 0; i < allTokens.length; ++i) {
            if (!(random.nextDouble() < allTokensRatio[i])) continue;
            longArrayList.add(allTokens[i]);
        }
        return longArrayList.toArray();
    }
}

