/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import java.util.function.Function;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.values.storable.Value;

abstract class FusionIndexReaderTest {
    private static final int PROP_KEY = 1;
    private static final int LABEL_KEY = 11;
    private static final IndexDescriptor DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)11, (int[])new int[]{1})).withName("index").materialise(12L);
    private final FusionVersion fusionVersion;
    private ValueIndexReader[] aliveReaders;
    private EnumMap<IndexSlot, ValueIndexReader> readers;
    private FusionIndexReader fusionIndexReader;

    FusionIndexReaderTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() throws IndexNotApplicableKernelException {
        this.initiateMocks();
    }

    private void initiateMocks() throws IndexNotApplicableKernelException {
        IndexSlot[] activeSlots = this.fusionVersion.aliveSlots();
        this.readers = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.readers, ValueIndexReader.EMPTY);
        this.aliveReaders = new ValueIndexReader[activeSlots.length];
        block4: for (int i = 0; i < activeSlots.length; ++i) {
            ValueIndexReader mock = (ValueIndexReader)Mockito.mock(ValueIndexReader.class);
            ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(DESCRIPTOR, new long[0])).when((Object)mock)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
            this.aliveReaders[i] = mock;
            switch (activeSlots[i]) {
                case GENERIC: {
                    this.readers.put(IndexSlot.GENERIC, mock);
                    continue block4;
                }
                case LUCENE: {
                    this.readers.put(IndexSlot.LUCENE, mock);
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexReader = new FusionIndexReader(this.fusionVersion.slotSelector(), new LazyInstanceSelector(this.readers, FusionIndexReaderTest.throwingFactory()), TestIndexDescriptorFactory.forLabel((int)11, (int[])new int[]{1}));
    }

    private static Function<IndexSlot, ValueIndexReader> throwingFactory() {
        return i -> {
            throw new IllegalStateException("All readers should exist already");
        };
    }

    @Test
    void closeMustCloseBothNativeAndLucene() {
        this.fusionIndexReader.close();
        for (ValueIndexReader reader : this.aliveReaders) {
            ((IndexReader)Mockito.verify((Object)reader)).close();
        }
    }

    @Test
    void closeIteratorMustCloseAll() throws Exception {
        IndexProgressor[] progressors = new IndexProgressor[this.aliveReaders.length];
        for (int i = 0; i < this.aliveReaders.length; ++i) {
            int slot = i;
            ((ValueIndexReader)Mockito.doAnswer(invocation -> {
                IndexProgressor.EntityValueClient client = (IndexProgressor.EntityValueClient)invocation.getArgument(0);
                IndexProgressor progressor = (IndexProgressor)Mockito.mock(IndexProgressor.class);
                client.initialize(DESCRIPTOR, progressor, (AccessMode)AccessMode.Static.ACCESS, false, (IndexQueryConstraints)invocation.getArgument(3), NodeIdsIndexReaderQueryAnswer.getIndexQueryArgument((InvocationOnMock)invocation));
                progressors[slot] = progressor;
                return null;
            }).when((Object)this.aliveReaders[i])).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
        }
        try (NodeValueIterator iterator = new NodeValueIterator();){
            this.fusionIndexReader.query((IndexProgressor.EntityValueClient)iterator, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)});
        }
        for (IndexProgressor progressor : progressors) {
            ((IndexProgressor)Mockito.verify((Object)progressor)).close();
        }
    }

    @Test
    void countIndexedNodesMustSelectCorrectReader() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers.get(indexSlot), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new Value[]{indexSlot, secondValue});
            }
        }
    }

    private void verifyCountIndexedNodesWithCorrectReader(ValueIndexReader correct, Value ... nativeValue) {
        this.fusionIndexReader.countIndexedEntities(0L, CursorContext.NULL, new int[]{1}, nativeValue);
        ((ValueIndexReader)Mockito.verify((Object)correct)).countIndexedEntities(0L, CursorContext.NULL, new int[]{1}, nativeValue);
        for (ValueIndexReader reader : this.aliveReaders) {
            if (reader == correct) continue;
            ((ValueIndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).countIndexedEntities(0L, CursorContext.NULL, new int[]{1}, nativeValue);
        }
    }

    @Test
    void mustSelectLuceneForCompositePredicate() throws Exception {
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)0), PropertyIndexQuery.exists((int)1)});
    }

    @Test
    void mustSelectLuceneForExactPredicateWithStringValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByLucene()) {
            PropertyIndexQuery.ExactPredicate indexQuery = PropertyIndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new PropertyIndexQuery[]{indexQuery});
        }
    }

    @Test
    void mustSelectGenericForExactPredicateWithOtherValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesNotSupportedBySpecificIndex()) {
            PropertyIndexQuery.ExactPredicate indexQuery = PropertyIndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new PropertyIndexQuery[]{indexQuery});
        }
    }

    @Test
    void mustSelectLuceneForRangeStringPredicate() throws Exception {
        PropertyIndexQuery.RangePredicate numberRange = PropertyIndexQuery.range((int)1, (String)"a", (boolean)true, (String)"b", (boolean)false);
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new PropertyIndexQuery[]{numberRange});
    }

    @Test
    void mustCombineResultFromAllEntriesPredicate() throws Exception {
        PropertyIndexQuery.AllEntriesPredicate all = PropertyIndexQuery.allEntries();
        long lastId = 0L;
        for (ValueIndexReader aliveReader : this.aliveReaders) {
            ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(DESCRIPTOR, new long[]{lastId++, lastId++})).when((Object)aliveReader)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
        }
        try (NodeValueIterator result = new NodeValueIterator();){
            this.fusionIndexReader.query((IndexProgressor.EntityValueClient)result, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{all});
            MutableLongSet resultSet = PrimitiveLongCollections.asSet((LongIterator)result);
            for (long i = 0L; i < lastId; ++i) {
                Assertions.assertTrue((boolean)resultSet.contains(i), (String)("Expected to contain " + i + ", but was " + (LongSet)resultSet));
            }
        }
    }

    @Test
    void mustCombineResultFromExistsPredicate() throws Exception {
        PropertyIndexQuery.ExistsPredicate exists = PropertyIndexQuery.exists((int)1);
        long lastId = 0L;
        for (ValueIndexReader aliveReader : this.aliveReaders) {
            ((ValueIndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(DESCRIPTOR, new long[]{lastId++, lastId++})).when((Object)aliveReader)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
        }
        try (NodeValueIterator result = new NodeValueIterator();){
            this.fusionIndexReader.query((IndexProgressor.EntityValueClient)result, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{exists});
            MutableLongSet resultSet = PrimitiveLongCollections.asSet((LongIterator)result);
            for (long i = 0L; i < lastId; ++i) {
                Assertions.assertTrue((boolean)resultSet.contains(i), (String)("Expected to contain " + i + ", but was " + (LongSet)resultSet));
            }
        }
    }

    @Test
    void shouldInstantiatePartLazilyForSpecificValueGroupQuery() throws IndexNotApplicableKernelException {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot i : IndexSlot.values()) {
            if (this.readers.get(i) != ValueIndexReader.EMPTY) {
                Value value = values.get(i)[0];
                try (NodeValueIterator cursor = new NodeValueIterator();){
                    this.fusionIndexReader.query((IndexProgressor.EntityValueClient)cursor, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value)});
                }
                for (IndexSlot j : IndexSlot.values()) {
                    if (this.readers.get(j) == ValueIndexReader.EMPTY) continue;
                    if (i == j) {
                        ((ValueIndexReader)Mockito.verify((Object)this.readers.get(i))).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (PropertyIndexQuery[])ArgumentMatchers.any());
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.readers.get(j)});
                }
            }
            this.initiateMocks();
        }
    }

    private void verifyQueryWithCorrectReader(ValueIndexReader expectedReader, PropertyIndexQuery ... indexQuery) throws IndexNotApplicableKernelException {
        try (NodeValueIterator cursor = new NodeValueIterator();){
            this.fusionIndexReader.query((IndexProgressor.EntityValueClient)cursor, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unconstrained(), indexQuery);
        }
        if (indexQuery.length == 1) {
            ((ValueIndexReader)Mockito.verify((Object)expectedReader)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new PropertyIndexQuery[]{(PropertyIndexQuery)ArgumentMatchers.eq((Object)indexQuery[0])});
        } else {
            ((ValueIndexReader)Mockito.verify((Object)expectedReader)).query((IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (QueryContext)ArgumentMatchers.any(), (AccessMode)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new PropertyIndexQuery[]{(PropertyIndexQuery)ArgumentMatchers.eq((Object)indexQuery[0]), (PropertyIndexQuery)ArgumentMatchers.eq((Object)indexQuery[1])});
        }
        for (ValueIndexReader reader : this.aliveReaders) {
            if (reader == expectedReader) continue;
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
        }
    }
}

