/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;

class LogVersionLocatorTest {
    private static final long firstTxIdInLog = 3L;
    private static final long lastTxIdInLog = 67L;

    LogVersionLocatorTest() {
    }

    @Test
    void shouldFindLogPosition() throws NoSuchTransactionException {
        long txId = 42L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(42L);
        LogPosition position = new LogPosition(1L, 128L);
        boolean result = locator.visit(null, position, 3L, 67L);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals((Object)position, (Object)locator.getLogPosition());
    }

    @Test
    void shouldNotFindLogPosition() {
        long txId = 1L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(1L);
        LogPosition position = new LogPosition(1L, 128L);
        boolean result = locator.visit(null, position, 3L, 67L);
        Assertions.assertTrue((boolean)result);
        NoSuchTransactionException e = (NoSuchTransactionException)Assertions.assertThrows(NoSuchTransactionException.class, () -> ((PhysicalLogicalTransactionStore.LogVersionLocator)locator).getLogPosition());
        Assertions.assertEquals((Object)"Unable to find transaction 1 in any of my logical logs: Couldn't find any log containing 1", (Object)e.getMessage());
    }

    @Test
    void shouldAlwaysThrowIfVisitIsNotCalled() {
        long txId = 1L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(1L);
        NoSuchTransactionException e = (NoSuchTransactionException)Assertions.assertThrows(NoSuchTransactionException.class, () -> ((PhysicalLogicalTransactionStore.LogVersionLocator)locator).getLogPosition());
        Assertions.assertEquals((Object)"Unable to find transaction 1 in any of my logical logs: Couldn't find any log containing 1", (Object)e.getMessage());
    }
}

