/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class SimpleMetaDataProvider
implements MetadataProvider {
    private final SimpleTransactionIdStore transactionIdStore;
    private final SimpleLogVersionRepository logVersionRepository;
    private final ExternalStoreId externalStoreId = new ExternalStoreId(UUID.randomUUID());

    public SimpleMetaDataProvider() {
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logVersionRepository = new SimpleLogVersionRepository();
    }

    public void close() throws IOException {
    }

    public long getCurrentLogVersion() {
        return this.logVersionRepository.getCurrentLogVersion();
    }

    public void setCurrentLogVersion(long version, CursorContext cursorContext) {
        this.logVersionRepository.setCurrentLogVersion(version, cursorContext);
    }

    public long incrementAndGetVersion(CursorContext cursorContext) {
        return this.logVersionRepository.incrementAndGetVersion(cursorContext);
    }

    public long getCheckpointLogVersion() {
        return this.logVersionRepository.getCheckpointLogVersion();
    }

    public void setCheckpointLogVersion(long version, CursorContext cursorContext) {
        this.logVersionRepository.setCheckpointLogVersion(version, cursorContext);
    }

    public long incrementAndGetCheckpointLogVersion(CursorContext cursorContext) {
        return this.logVersionRepository.incrementAndGetCheckpointLogVersion(cursorContext);
    }

    public StoreId getStoreId() {
        return StoreId.UNKNOWN;
    }

    public Optional<ExternalStoreId> getExternalStoreId() {
        return Optional.of(this.externalStoreId);
    }

    public long nextCommittingTransactionId() {
        return this.transactionIdStore.nextCommittingTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionIdStore.committingTransactionId();
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, CursorContext cursorContext) {
        this.transactionIdStore.transactionCommitted(transactionId, checksum, commitTimestamp, cursorContext);
    }

    public long getLastCommittedTransactionId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.transactionIdStore.getLastCommittedTransaction();
    }

    public TransactionId getUpgradeTransaction() {
        return this.transactionIdStore.getUpgradeTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return this.transactionIdStore.getLastClosedTransaction();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long byteOffset, long logVersion, CursorContext cursorContext) {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(transactionId, checksum, commitTimestamp, byteOffset, logVersion, cursorContext);
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, CursorContext cursorContext) {
        this.transactionIdStore.transactionClosed(transactionId, logVersion, byteOffset, cursorContext);
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, CursorContext cursorContext) {
        this.transactionIdStore.resetLastClosedTransaction(transactionId, logVersion, byteOffset, missingLogs, cursorContext);
    }

    public void flush(CursorContext cursorContext) {
        this.transactionIdStore.flush(cursorContext);
    }

    public KernelVersion kernelVersion() {
        return KernelVersion.LATEST;
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }
}

