/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public final class JobSchedulerFactory {
    private JobSchedulerFactory() {
    }

    public static JobScheduler createScheduler() {
        return JobSchedulerFactory.createCentralScheduler(Clocks.nanoClock());
    }

    public static JobScheduler createInitialisedScheduler() {
        return JobSchedulerFactory.createInitialisedScheduler(Clocks.nanoClock());
    }

    public static JobScheduler createInitialisedScheduler(SystemNanoClock clock) {
        CentralJobScheduler scheduler = JobSchedulerFactory.createCentralScheduler(clock);
        scheduler.init();
        return scheduler;
    }

    private static CentralJobScheduler createCentralScheduler(SystemNanoClock clock) {
        return new CentralJobScheduler(clock);
    }
}

