/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.IndexHintException;

public interface NotificationDetail {
    public String name();

    public String value();

    public static final class Factory {
        private Factory() {
        }

        public static NotificationDetail deprecatedName(String oldName, String newName) {
            return Factory.createDeprecationNotificationDetail(oldName, newName);
        }

        public static NotificationDetail nodeAnyIndex(String variableName, String labelName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.NODE, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.ANY);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail nodeBtreeIndex(String variableName, String labelName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.NODE, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.BTREE);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail nodeTextIndex(String variableName, String labelName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.NODE, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.TEXT);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail nodeRangeIndex(String variableName, String labelName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.NODE, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.RANGE);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail nodePointIndex(String variableName, String labelName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.NODE, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.POINT);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail relationshipAnyIndex(String variableName, String relationshipTypeName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)relationshipTypeName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.RELATIONSHIP, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.ANY);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail relationshipBtreeIndex(String variableName, String relationshipTypeName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)relationshipTypeName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.RELATIONSHIP, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.BTREE);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail relationshipTextIndex(String variableName, String relationshipTypeName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)relationshipTypeName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.RELATIONSHIP, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.TEXT);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail relationshipRangeIndex(String variableName, String relationshipTypeName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)relationshipTypeName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.RELATIONSHIP, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.RANGE);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail relationshipPointIndex(String variableName, String relationshipTypeName, String ... propertyKeyNames) {
            String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)relationshipTypeName, Arrays.asList(propertyKeyNames), (EntityType)EntityType.RELATIONSHIP, (IndexHintException.IndexHintIndexType)IndexHintException.IndexHintIndexType.POINT);
            return Factory.createNotificationDetail("index", indexFormatString, true);
        }

        public static NotificationDetail label(String labelName) {
            return Factory.createNotificationDetail("the missing label name", labelName, true);
        }

        public static NotificationDetail relationshipType(String relType) {
            return Factory.createNotificationDetail("the missing relationship type", relType, true);
        }

        public static NotificationDetail procedureWarning(String procedure, String warning) {
            return Factory.createProcedureWarningNotificationDetail(procedure, warning);
        }

        public static NotificationDetail propertyName(String name) {
            return Factory.createNotificationDetail("the missing property name", name, true);
        }

        public static NotificationDetail repeatedRel(String name) {
            return Factory.createNotificationDetail("the repeated relationship", name, true);
        }

        public static NotificationDetail shadowingVariable(String name) {
            return Factory.createNotificationDetail("the shadowing variable", name, true);
        }

        public static NotificationDetail joinKey(List<String> identifiers) {
            boolean singular = identifiers.size() == 1;
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String identifier : identifiers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(identifier);
            }
            return Factory.createNotificationDetail(singular ? "hinted join key identifier" : "hinted join key identifiers", builder.toString(), singular);
        }

        public static NotificationDetail cartesianProduct(Set<String> identifiers) {
            return Factory.createNotificationDetail(identifiers, "identifier", "identifiers");
        }

        public static NotificationDetail nodeIndexSeekOrScan(Set<String> labels) {
            return Factory.createNotificationDetail(labels, "indexed label", "indexed labels");
        }

        public static NotificationDetail relationshipIndexSeekOrScan(Set<String> labels) {
            return Factory.createNotificationDetail(labels, "indexed relationship type", "indexed relationship types");
        }

        public static NotificationDetail message(final String name, final String message) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String value() {
                    return message;
                }

                public String toString() {
                    return message;
                }
            };
        }

        public static NotificationDetail deprecatedField(final String procedure, final String field) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return procedure;
                }

                @Override
                public String value() {
                    return field;
                }

                public String toString() {
                    return String.format("'%s' returned by '%s' is no longer supported.", field, procedure);
                }
            };
        }

        public static NotificationDetail bindingVarLengthRelationship(final String element) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return element;
                }

                @Override
                public String value() {
                    return String.format("Binding a variable length relationship pattern to a variable ('%s') is deprecated and will be unsupported in a future version. The recommended way is to bind the whole path to a variable, then extract the relationships:%n\tMATCH p = (...)-[...]-(...)%n\tWITH *, relationships(p) AS %s", element, element);
                }

                public String toString() {
                    return this.value();
                }
            };
        }

        private static NotificationDetail createNotificationDetail(Set<String> elements, String singularTerm, String pluralTerm) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            String separator = "";
            for (String element : elements) {
                builder.append(separator);
                builder.append(element);
                separator = ", ";
            }
            builder.append(')');
            boolean singular = elements.size() == 1;
            return Factory.createNotificationDetail(singular ? singularTerm : pluralTerm, builder.toString(), singular);
        }

        private static NotificationDetail createNotificationDetail(final String name, final String value, final boolean singular) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String value() {
                    return value;
                }

                public String toString() {
                    return String.format("%s %s %s", name, singular ? "is:" : "are:", value);
                }
            };
        }

        private static NotificationDetail createDeprecationNotificationDetail(final String oldName, final String newName) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return oldName;
                }

                @Override
                public String value() {
                    return newName;
                }

                public String toString() {
                    if (newName == null || newName.trim().isEmpty()) {
                        return String.format("'%s' is no longer supported", oldName);
                    }
                    return String.format("'%s' has been replaced by '%s'", oldName, newName);
                }
            };
        }

        private static NotificationDetail createProcedureWarningNotificationDetail(final String procedure, final String warning) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return procedure;
                }

                @Override
                public String value() {
                    return warning;
                }

                public String toString() {
                    return String.format(warning, procedure);
                }
            };
        }
    }
}

