/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class StatementQueryRegistry
implements QueryRegistry {
    private final KernelStatement statement;
    private final ExecutingQueryFactory factory;

    StatementQueryRegistry(KernelStatement statement, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef) {
        this.statement = statement;
        this.factory = new ExecutingQueryFactory(clock, cpuClockRef);
    }

    @Override
    public Optional<ExecutingQuery> executingQuery() {
        return this.statement.executingQuery();
    }

    @Override
    public ExecutingQuery startAndBindExecutingQuery(String queryText, MapValue queryParameters) {
        ExecutingQuery executingQuery = this.factory.createForStatement(this.statement, queryText, queryParameters);
        this.statement.startQueryExecution(executingQuery);
        return executingQuery;
    }

    @Override
    public void bindExecutingQuery(ExecutingQuery executingQuery) {
        ExecutingQueryFactory.bindToStatement(executingQuery, this.statement);
        this.statement.startQueryExecution(executingQuery);
    }

    @Override
    public void unbindExecutingQuery(ExecutingQuery executingQuery, long userTransactionId) {
        ExecutingQueryFactory.unbindFromTransaction(executingQuery, userTransactionId);
        this.statement.stopQueryExecution(executingQuery);
    }
}

