/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.ExceptionDuringFlipKernelException;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.values.storable.Value;

public class FlippableIndexProxy
extends AbstractDelegatingIndexProxy {
    private volatile boolean closed;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile IndexProxyFactory flipTarget;
    private volatile IndexProxy delegate;
    private boolean started;

    public FlippableIndexProxy() {
        this(null);
    }

    FlippableIndexProxy(IndexProxy originalDelegate) {
        this.delegate = originalDelegate;
    }

    @Override
    public IndexProxy getDelegate() {
        return this.delegate;
    }

    @Override
    public void start() {
        this.lock.readLock().lock();
        try {
            this.delegate.start();
            this.started = true;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        this.lock.readLock().lock();
        try {
            LockingIndexUpdater lockingIndexUpdater = new LockingIndexUpdater(this.delegate.newUpdater(mode, cursorContext, parallel));
            return lockingIndexUpdater;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void drop() {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            this.delegate.drop();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        FlippableIndexProxy.barge(this.lock.readLock());
        try {
            this.delegate.force(flushEvent, cursorContext);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void refresh() throws IOException {
        this.lock.readLock();
        try {
            this.delegate.refresh();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static void barge(ReentrantReadWriteLock.ReadLock lock) {
        boolean interrupted = false;
        long timeout = 10L;
        while (!lock.tryLock()) {
            try {
                if (lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                interrupted = true;
            }
            timeout = Math.min(1000L, timeout * 2L);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public IndexDescriptor getDescriptor() {
        this.lock.readLock().lock();
        try {
            IndexDescriptor indexDescriptor = this.delegate.getDescriptor();
            return indexDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public InternalIndexState getState() {
        this.lock.readLock().lock();
        try {
            InternalIndexState internalIndexState = this.delegate.getState();
            return internalIndexState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close(CursorContext cursorContext) throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            this.delegate.close(cursorContext);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ValueIndexReader newValueReader() throws IndexNotFoundKernelException {
        this.lock.readLock().lock();
        try {
            ValueIndexReader valueIndexReader = this.delegate.newValueReader();
            return valueIndexReader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public TokenIndexReader newTokenReader() throws IndexNotFoundKernelException {
        this.lock.readLock().lock();
        try {
            TokenIndexReader tokenIndexReader = this.delegate.newTokenReader();
            return tokenIndexReader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws IndexPopulationFailedKernelException, InterruptedException {
        this.lock.readLock().lock();
        IndexProxy proxy = this.delegate;
        this.lock.readLock().unlock();
        if (this.closed) {
            return false;
        }
        boolean stillGoing = proxy.awaitStoreScanCompleted(time, unit);
        if (!stillGoing) {
            this.lock.readLock().lock();
            proxy = this.delegate;
            this.lock.readLock().unlock();
            proxy.awaitStoreScanCompleted(time, unit);
        }
        return stillGoing;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.delegate.activate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.lock.readLock().lock();
        try {
            this.delegate.validate();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
        this.lock.readLock().lock();
        try {
            this.delegate.validateBeforeCommit(tuple, entityId);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ResourceIterator<Path> snapshotFiles() throws IOException {
        this.lock.readLock().lock();
        try {
            ResourceIterator<Path> resourceIterator = this.delegate.snapshotFiles();
            return resourceIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Map<String, Value> indexConfig() {
        this.lock.readLock().lock();
        try {
            Map map = this.delegate.indexConfig();
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        this.lock.readLock().lock();
        try {
            IndexPopulationFailure indexPopulationFailure = this.delegate.getPopulationFailure();
            return indexPopulationFailure;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        this.lock.readLock().lock();
        try {
            PopulationProgress populationProgress = this.delegate.getIndexPopulationProgress();
            return populationProgress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void setFlipTarget(IndexProxyFactory flipTarget) {
        this.lock.writeLock().lock();
        try {
            this.flipTarget = flipTarget;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void flipTo(IndexProxy targetDelegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = targetDelegate;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(Callable<Boolean> actionDuringFlip, FailedIndexProxyFactory failureDelegate) throws FlipFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.assertOpen();
            try {
                if (actionDuringFlip.call().booleanValue()) {
                    this.delegate = this.flipTarget.create();
                    if (this.started) {
                        this.delegate.start();
                    }
                }
            }
            catch (Exception e) {
                this.delegate = failureDelegate.create(e);
                throw new ExceptionDuringFlipKernelException(e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.delegate + "[target:" + this.flipTarget + "]";
    }

    private void assertOpen() throws IndexProxyAlreadyClosedKernelException {
        if (this.closed) {
            throw new IndexProxyAlreadyClosedKernelException(this.getClass());
        }
    }

    private class LockingIndexUpdater
    extends DelegatingIndexUpdater {
        private LockingIndexUpdater(IndexUpdater delegate) {
            super(delegate);
            FlippableIndexProxy.this.lock.readLock().lock();
        }

        @Override
        public void close() throws IndexEntryConflictException {
            try {
                this.delegate.close();
            }
            finally {
                FlippableIndexProxy.this.lock.readLock().unlock();
            }
        }
    }
}

