/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.LoggingPhaseTracker;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class MultipleIndexPopulator
implements StoreScan.ExternalUpdatesCheck,
AutoCloseable {
    private static final String MULTIPLE_INDEX_POPULATOR_TAG = "multipleIndexPopulator";
    private static final String POPULATION_WORK_FLUSH_TAG = "populationWorkFlush";
    private static final String EOL = System.lineSeparator();
    private final int queueThreshold;
    final int batchMaxByteSizeScan;
    private final boolean printDebug;
    private final Queue<IndexEntryUpdate<?>> concurrentUpdateQueue = new LinkedBlockingQueue();
    private final AtomicLong concurrentUpdateQueueByteSize = new AtomicLong();
    private final List<IndexPopulation> populations = new CopyOnWriteArrayList<IndexPopulation>();
    private final AtomicLong activeTasks = new AtomicLong();
    private final IndexStoreView storeView;
    private final CursorContextFactory contextFactory;
    private final InternalLogProvider logProvider;
    private final InternalLog log;
    private final EntityType type;
    private final SchemaState schemaState;
    private final PhaseTracker phaseTracker;
    private final JobScheduler jobScheduler;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private volatile StoreScan storeScan;
    private final TokenNameLookup tokenNameLookup;
    private final String databaseName;
    private final Subject subject;

    public MultipleIndexPopulator(IndexStoreView storeView, InternalLogProvider logProvider, EntityType type, SchemaState schemaState, JobScheduler jobScheduler, TokenNameLookup tokenNameLookup, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, Subject subject, Config config) {
        this.storeView = storeView;
        this.contextFactory = contextFactory;
        this.cursorContext = contextFactory.create(MULTIPLE_INDEX_POPULATOR_TAG);
        this.memoryTracker = memoryTracker;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
        this.type = type;
        this.schemaState = schemaState;
        this.phaseTracker = new LoggingPhaseTracker(logProvider.getLog(IndexPopulationJob.class));
        this.jobScheduler = jobScheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.databaseName = databaseName;
        this.subject = subject;
        this.printDebug = (Boolean)config.get(GraphDatabaseInternalSettings.index_population_print_debug);
        this.queueThreshold = (Integer)config.get(GraphDatabaseInternalSettings.index_population_queue_threshold);
        this.batchMaxByteSizeScan = ((Long)config.get(GraphDatabaseInternalSettings.index_population_batch_max_byte_size)).intValue();
    }

    IndexPopulation addPopulator(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        IndexPopulation population = this.createPopulation(populator, indexProxyStrategy, flipper, failedIndexProxyFactory);
        this.populations.add(population);
        return population;
    }

    private IndexPopulation createPopulation(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        return new IndexPopulation(populator, indexProxyStrategy, flipper, failedIndexProxyFactory);
    }

    boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    public void create(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            this.log.info("Index population started: [%s]", new Object[]{population.userDescription(this.tokenNameLookup)});
            population.create();
        }), cursorContext);
    }

    StoreScan createStoreScan(CursorContextFactory contextFactory) {
        int[] entityTokenIds = this.entityTokenIds();
        int[] propertyKeyIds = this.propertyKeyIds();
        IntPredicate propertyKeyIdFilter = propertyKeyId -> ArrayIterate.contains((int[])propertyKeyIds, (int)propertyKeyId);
        if (this.type == EntityType.RELATIONSHIP) {
            StoreScan innerStoreScan = this.storeView.visitRelationships(entityTokenIds, propertyKeyIdFilter, this.createPropertyScanConsumer(), this.createTokenScanConsumer(), false, true, contextFactory, this.memoryTracker);
            this.storeScan = new LoggingStoreScan(innerStoreScan, false);
        } else {
            StoreScan innerStoreScan = this.storeView.visitNodes(entityTokenIds, propertyKeyIdFilter, this.createPropertyScanConsumer(), this.createTokenScanConsumer(), false, true, contextFactory, this.memoryTracker);
            this.storeScan = new LoggingStoreScan(innerStoreScan, true);
        }
        this.storeScan.setPhaseTracker(this.phaseTracker);
        return this.storeScan;
    }

    void queueConcurrentUpdate(IndexEntryUpdate<?> update) {
        this.concurrentUpdateQueue.add(update);
        this.concurrentUpdateQueueByteSize.addAndGet(update.roughSizeOfUpdate());
    }

    public void cancel(Throwable failure, CursorContext cursorContext) {
        for (IndexPopulation population : this.populations) {
            this.cancel(population, failure, cursorContext);
        }
    }

    protected void cancel(IndexPopulation population, Throwable failure, CursorContext cursorContext) {
        Throwable cause;
        if (!this.removeFromOngoingPopulations(population)) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        this.log.error(String.format("Failed to populate index: [%s]", population.userDescription(this.tokenNameLookup)), failure);
        IndexPopulationFailure indexPopulationFailure = IndexPopulationFailure.failure(failure);
        population.cancel(indexPopulationFailure);
        try {
            population.populator.markAsFailed(indexPopulationFailure.asString());
            population.populator.close(false, cursorContext);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.userDescription(this.tokenNameLookup)), e);
        }
    }

    @VisibleForTesting
    MultipleIndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        HashMap<SchemaDescriptor, IndexPopulationUpdater> updaters = new HashMap<SchemaDescriptor, IndexPopulationUpdater>();
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            IndexUpdater updater = population.populator.newPopulatingUpdater(cursorContext);
            updaters.put(population.schema(), new IndexPopulationUpdater((IndexPopulation)population, updater));
        }), cursorContext);
        return new MultipleIndexUpdater(this, updaters, this.logProvider, cursorContext);
    }

    @Override
    public void close() {
        this.phaseTracker.stop();
        IOUtils.closeAllUnchecked((AutoCloseable[])new CursorContext[]{this.cursorContext});
    }

    void resetIndexCounts(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::resetIndexCountsForPopulation), cursorContext);
    }

    private void resetIndexCountsForPopulation(IndexPopulation indexPopulation) {
        indexPopulation.indexProxyStrategy.replaceStatisticsForIndex(new IndexSample(0L, 0L, 0L));
    }

    void flipAfterStoreScan(CursorContext cursorContext) {
        for (IndexPopulation population : this.populations) {
            try {
                population.scanCompleted(cursorContext);
                population.flip(cursorContext);
            }
            catch (Throwable t) {
                this.cancel(population, t, cursorContext);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.stream().flatMapToInt(this::propertyKeyIds).distinct().toArray();
    }

    private IntStream propertyKeyIds(IndexPopulation population) {
        return IntStream.of(population.schema().getPropertyIds());
    }

    private int[] entityTokenIds() {
        return this.populations.stream().flatMapToInt(population -> Arrays.stream(population.schema().getEntityTokenIds())).toArray();
    }

    public void stop(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> this.stop((IndexPopulation)population, cursorContext)), cursorContext);
    }

    void stop(IndexPopulation indexPopulation, CursorContext cursorContext) {
        indexPopulation.disconnectAndStop(cursorContext);
        this.checkEmpty();
    }

    private void checkEmpty() {
        StoreScan scan = this.storeScan;
        if (this.populations.isEmpty() && scan != null) {
            scan.stop();
        }
    }

    void dropIndexPopulation(IndexPopulation indexPopulation) {
        indexPopulation.disconnectAndDrop();
        this.checkEmpty();
    }

    private boolean removeFromOngoingPopulations(IndexPopulation indexPopulation) {
        return this.populations.remove(indexPopulation);
    }

    @Override
    public boolean needToApplyExternalUpdates() {
        int queueSize = this.concurrentUpdateQueue.size();
        return queueSize > 0 && queueSize >= this.queueThreshold || this.concurrentUpdateQueueByteSize.get() >= (long)this.batchMaxByteSizeScan;
    }

    @Override
    public void applyExternalUpdates(long currentlyIndexedNodeId) {
        if (this.concurrentUpdateQueue.isEmpty()) {
            return;
        }
        if (this.printDebug) {
            this.log.info("Populating from queue at %d", new Object[]{currentlyIndexedNodeId});
        }
        long updateByteSizeDrained = 0L;
        try (MultipleIndexUpdater updater = this.newPopulatingUpdater(this.cursorContext);){
            do {
                IndexEntryUpdate<?> update;
                updateByteSizeDrained += (update = this.concurrentUpdateQueue.poll()) != null ? update.roughSizeOfUpdate() : 0L;
                if (update != null && update.getEntityId() <= currentlyIndexedNodeId) {
                    updater.process(update);
                    if (!this.printDebug) continue;
                    this.log.info("Applied %s from queue", new Object[]{update.describe(this.tokenNameLookup)});
                    continue;
                }
                if (!this.printDebug) continue;
                this.log.info("Skipped %s from queue", new Object[]{update == null ? null : update.describe(this.tokenNameLookup)});
            } while (!this.concurrentUpdateQueue.isEmpty());
            this.concurrentUpdateQueueByteSize.addAndGet(-updateByteSizeDrained);
        }
        if (this.printDebug) {
            this.log.info("Done applying updates from queue");
        }
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action, CursorContext cursorContext) {
        for (IndexPopulation population : this.populations) {
            try {
                action.accept((Object)population);
            }
            catch (Throwable failure) {
                this.cancel(population, failure, cursorContext);
            }
        }
    }

    private PropertyScanConsumer createPropertyScanConsumer() {
        if (this.populations.stream().allMatch(population -> population.indexProxyStrategy.getIndexDescriptor().getIndexType() == IndexType.LOOKUP)) {
            return null;
        }
        return new PropertyScanConsumerImpl();
    }

    private TokenScanConsumer createTokenScanConsumer() {
        Optional<IndexPopulation> maybeTokenIdxPopulation = this.populations.stream().filter(population -> population.indexProxyStrategy.getIndexDescriptor().getIndexType() == IndexType.LOOKUP).findAny();
        return maybeTokenIdxPopulation.map(x$0 -> new TokenScanConsumerImpl((IndexPopulation)x$0)).orElse(null);
    }

    public String toString() {
        String updatesString = this.populations.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        return "MultipleIndexPopulator{activeTasks=" + this.activeTasks + ", batchedUpdatesFromScan = " + updatesString + ", concurrentUpdateQueue = " + this.concurrentUpdateQueue.size() + "}";
    }

    public void monitorStart(IndexMonitor monitor) {
        IndexDescriptor[] indexDescriptors = (IndexDescriptor[])this.populations.stream().map(p -> p.indexProxyStrategy.getIndexDescriptor()).toArray(IndexDescriptor[]::new);
        monitor.indexPopulationScanStarting(indexDescriptors);
    }

    public class IndexPopulation
    implements SchemaDescriptorSupplier {
        public final IndexPopulator populator;
        final FlippableIndexProxy flipper;
        private final IndexProxyStrategy indexProxyStrategy;
        private final FailedIndexProxyFactory failedIndexProxyFactory;
        private boolean populationOngoing = true;
        private final ReentrantLock populatorLock = new ReentrantLock();

        IndexPopulation(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
            this.populator = populator;
            this.indexProxyStrategy = indexProxyStrategy;
            this.flipper = flipper;
            this.failedIndexProxyFactory = failedIndexProxyFactory;
        }

        private void cancel(IndexPopulationFailure failure) {
            this.flipper.flipTo(new FailedIndexProxy(this.indexProxyStrategy, (MinimalIndexAccessor)this.populator, failure, MultipleIndexPopulator.this.logProvider));
        }

        void create() throws IOException {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    this.populator.create();
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void disconnectAndStop(CursorContext cursorContext) {
            this.disconnect(() -> this.populator.close(false, cursorContext));
        }

        void disconnectAndDrop() {
            this.disconnect(() -> ((IndexPopulator)this.populator).drop());
        }

        private void disconnect(Runnable specificPopulatorOperation) {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
                    specificPopulatorOperation.run();
                    MultipleIndexPopulator.this.resetIndexCountsForPopulation(this);
                    this.populationOngoing = false;
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void flip(CursorContext cursorContext) throws FlipFailedKernelException {
            MultipleIndexPopulator.this.phaseTracker.enterPhase(PhaseTracker.Phase.FLIP);
            this.flipper.flip(() -> {
                this.populatorLock.lock();
                try {
                    if (this.populationOngoing) {
                        MultipleIndexPopulator.this.applyExternalUpdates(Long.MAX_VALUE);
                        if (MultipleIndexPopulator.this.populations.contains(this)) {
                            if (this.indexProxyStrategy.getIndexDescriptor().getIndexType() != IndexType.LOOKUP) {
                                IndexSample sample = this.populator.sample(cursorContext);
                                this.indexProxyStrategy.replaceStatisticsForIndex(sample);
                            }
                            this.populator.close(true, cursorContext);
                            MultipleIndexPopulator.this.schemaState.clear();
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    this.logCompletionMessage();
                    this.populationOngoing = false;
                    this.populatorLock.unlock();
                }
            }, this.failedIndexProxyFactory);
            MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
        }

        private void logCompletionMessage() {
            MultipleIndexPopulator.this.log.info("Index creation finished for index [%s].", new Object[]{this.indexProxyStrategy.getIndexUserDescription()});
        }

        public SchemaDescriptor schema() {
            return this.indexProxyStrategy.getIndexDescriptor().schema();
        }

        public String userDescription(TokenNameLookup tokenNameLookup) {
            return this.indexProxyStrategy.getIndexUserDescription();
        }

        void scanCompleted(CursorContext cursorContext) throws IndexEntryConflictException {
            IndexPopulator.PopulationWorkScheduler populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

                public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                    String description = descriptionSupplier.getJobDescription(IndexPopulation.this.indexProxyStrategy.getIndexDescriptor().getName());
                    JobMonitoringParams jobMonitoringParams = new JobMonitoringParams(MultipleIndexPopulator.this.subject, MultipleIndexPopulator.this.databaseName, description);
                    return MultipleIndexPopulator.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, jobMonitoringParams, job);
                }
            };
            this.populator.scanCompleted(MultipleIndexPopulator.this.phaseTracker, populationWorkScheduler, cursorContext);
        }

        PopulationProgress progress(PopulationProgress storeScanProgress) {
            return this.populator.progress(storeScanProgress);
        }
    }

    private class LoggingStoreScan
    implements StoreScan {
        private final StoreScan delegate;
        private final boolean nodeScan;

        LoggingStoreScan(StoreScan delegate, boolean nodeScan) {
            this.delegate = delegate;
            this.nodeScan = nodeScan;
        }

        @Override
        public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
            this.delegate.run(externalUpdatesCheck);
            String entityType = this.nodeScan ? "node" : "relationship";
            MultipleIndexPopulator.this.log.debug("Completed " + entityType + " store scan. Flushing all pending updates." + EOL + MultipleIndexPopulator.this);
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public PopulationProgress getProgress() {
            return this.delegate.getProgress();
        }

        @Override
        public void setPhaseTracker(PhaseTracker phaseTracker) {
            this.delegate.setPhaseTracker(phaseTracker);
        }
    }

    public static class MultipleIndexUpdater
    implements IndexUpdater {
        private final Map<SchemaDescriptor, IndexPopulationUpdater> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final InternalLog log;
        private final CursorContext cursorContext;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, Map<SchemaDescriptor, IndexPopulationUpdater> populationsWithUpdaters, InternalLogProvider logProvider, CursorContext cursorContext) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
            this.cursorContext = cursorContext;
        }

        public void process(IndexEntryUpdate<?> update) {
            IndexPopulationUpdater populationUpdater = this.populationsWithUpdaters.get(update.indexKey().schema());
            if (populationUpdater != null) {
                IndexPopulation population = populationUpdater.population;
                IndexUpdater updater = populationUpdater.updater;
                try {
                    population.populator.includeSample(update);
                    updater.process(update);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    this.populationsWithUpdaters.remove(update.indexKey().schema());
                    this.multipleIndexPopulator.cancel(population, t, this.cursorContext);
                }
            }
        }

        public void close() {
            for (IndexPopulationUpdater populationUpdater : this.populationsWithUpdaters.values()) {
                try {
                    populationUpdater.updater.close();
                }
                catch (Throwable t) {
                    this.multipleIndexPopulator.cancel(populationUpdater.population, t, this.cursorContext);
                }
            }
            this.populationsWithUpdaters.clear();
        }
    }

    private class PropertyScanConsumerImpl
    implements PropertyScanConsumer {
        private PropertyScanConsumerImpl() {
        }

        @Override
        public PropertyScanConsumer.Batch newBatch() {
            return new PropertyScanConsumer.Batch(){
                final List<EntityUpdates> updates = new ArrayList<EntityUpdates>();

                @Override
                public void addRecord(long entityId, long[] tokens, Map<Integer, Value> properties) {
                    EntityUpdates.Builder builder = EntityUpdates.forEntity((long)entityId, (boolean)true).withTokens(tokens);
                    properties.forEach((arg_0, arg_1) -> ((EntityUpdates.Builder)builder).added(arg_0, arg_1));
                    this.updates.add(builder.build());
                }

                @Override
                public void process() {
                    try (CursorContext cursorContext = MultipleIndexPopulator.this.contextFactory.create(MultipleIndexPopulator.POPULATION_WORK_FLUSH_TAG);){
                        PropertyScanConsumerImpl.this.addFromScan(this.updates, cursorContext);
                    }
                    if (MultipleIndexPopulator.this.printDebug) {
                        if (!this.updates.isEmpty()) {
                            long lastEntityId = this.updates.get(this.updates.size() - 1).getEntityId();
                            MultipleIndexPopulator.this.log.info("Added scan updates for entities %d-%d", new Object[]{this.updates.get(0).getEntityId(), lastEntityId});
                        } else {
                            MultipleIndexPopulator.this.log.info("Added zero scan updates");
                        }
                    }
                }
            };
        }

        private void addFromScan(List<EntityUpdates> entityUpdates, CursorContext cursorContext) {
            HashMap<IndexPopulation, List> updates = new HashMap<IndexPopulation, List>(MultipleIndexPopulator.this.populations.size());
            for (EntityUpdates entityUpdates2 : entityUpdates) {
                for (IndexEntryUpdate indexUpdate : entityUpdates2.valueUpdatesForIndexKeys(MultipleIndexPopulator.this.populations)) {
                    IndexPopulation population = (IndexPopulation)indexUpdate.indexKey();
                    population.populator.includeSample(indexUpdate);
                    updates.computeIfAbsent(population, p -> new ArrayList()).add(indexUpdate);
                }
            }
            for (Map.Entry entry : updates.entrySet()) {
                try {
                    ((IndexPopulation)entry.getKey()).populator.add((Collection)entry.getValue(), cursorContext);
                }
                catch (Throwable e) {
                    MultipleIndexPopulator.this.cancel((IndexPopulation)entry.getKey(), e, cursorContext);
                }
            }
        }
    }

    private class TokenScanConsumerImpl
    implements TokenScanConsumer {
        private final IndexPopulation population;

        TokenScanConsumerImpl(IndexPopulation population) {
            this.population = population;
        }

        @Override
        public TokenScanConsumer.Batch newBatch() {
            return new TokenScanConsumer.Batch(){
                private final List<TokenIndexEntryUpdate<IndexPopulation>> updates = new ArrayList<TokenIndexEntryUpdate<IndexPopulation>>();

                @Override
                public void addRecord(long entityId, long[] tokens) {
                    this.updates.add((TokenIndexEntryUpdate<IndexPopulation>)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)TokenScanConsumerImpl.this.population, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])tokens));
                }

                @Override
                public void process() {
                    try {
                        TokenScanConsumerImpl.this.population.populator.add(this.updates, MultipleIndexPopulator.this.cursorContext);
                    }
                    catch (Throwable e) {
                        MultipleIndexPopulator.this.cancel(TokenScanConsumerImpl.this.population, e, MultipleIndexPopulator.this.cursorContext);
                    }
                }
            };
        }
    }

    private record IndexPopulationUpdater(IndexPopulation population, IndexUpdater updater) {
    }
}

