/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.schema.SchemaIndexExtensionLoader;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.lifecycle.LifeContainer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.token.TokenHolders;

public class DefaultIndexProvidersAccess
extends LifeContainer
implements IndexProvidersAccess {
    private final StorageEngineFactory storageEngineFactory;
    private final FileSystemAbstraction fileSystem;
    private final Config databaseConfig;
    private final JobScheduler jobScheduler;
    private final LogService logService;
    private final PageCacheTracer pageCacheTracer;
    private final CursorContextFactory contextFactory;

    public DefaultIndexProvidersAccess(StorageEngineFactory storageEngineFactory, FileSystemAbstraction fileSystem, Config databaseConfig, JobScheduler jobScheduler, LogService logService, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory) {
        this.storageEngineFactory = storageEngineFactory;
        this.fileSystem = fileSystem;
        this.databaseConfig = databaseConfig;
        this.jobScheduler = jobScheduler;
        this.logService = logService;
        this.pageCacheTracer = pageCacheTracer;
        this.contextFactory = contextFactory;
    }

    public IndexProviderMap access(PageCache pageCache, DatabaseLayout layout, DatabaseReadOnlyChecker readOnlyChecker) {
        TokenHolders tokenHolders = this.storageEngineFactory.loadReadOnlyTokens(this.fileSystem, layout, this.databaseConfig, pageCache, this.pageCacheTracer, false, this.contextFactory);
        return this.access(pageCache, layout, readOnlyChecker, tokenHolders);
    }

    public IndexProviderMap access(PageCache pageCache, DatabaseLayout layout, DatabaseReadOnlyChecker readOnlyChecker, TokenHolders tokenHolders) {
        Monitors monitors = new Monitors();
        DatabaseExtensions extensions = (DatabaseExtensions)this.life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions(layout, this.fileSystem, this.databaseConfig, this.logService, pageCache, this.jobScheduler, RecoveryCleanupWorkCollector.immediate(), DbmsInfo.TOOL, TopologyGraphDbmsModel.HostedOnMode.SINGLE, monitors, tokenHolders, this.pageCacheTracer, DatabaseReadOnlyChecker.readOnly()));
        return (IndexProviderMap)this.life.add((Lifecycle)StaticIndexProviderMapFactory.create(this.life, this.databaseConfig, pageCache, this.fileSystem, this.logService, monitors, readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode.SINGLE, RecoveryCleanupWorkCollector.immediate(), layout, tokenHolders, this.jobScheduler, this.contextFactory, this.pageCacheTracer, (DependencyResolver)extensions));
    }
}

