/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.common.EntityType;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;

public class EntityTokenRangeImpl
implements EntityTokenRange {
    public static final long[][] NO_TOKENS = new long[64][];
    private final long idRange;
    private final long[] entities;
    private final long[][] tokens;
    private final EntityType entityType;
    private final long lowRangeId;
    private final long highRangeId;

    public EntityTokenRangeImpl(long idRange, long[][] tokens, EntityType entityType) {
        this.idRange = idRange;
        this.tokens = tokens;
        this.entityType = entityType;
        int rangeSize = tokens.length;
        this.lowRangeId = idRange * (long)rangeSize;
        this.highRangeId = this.lowRangeId + (long)rangeSize - 1L;
        this.entities = new long[rangeSize];
        for (int i = 0; i < rangeSize; ++i) {
            this.entities[i] = this.lowRangeId + (long)i;
        }
    }

    public long id() {
        return this.idRange;
    }

    public boolean covers(long entityId) {
        return entityId >= this.lowRangeId && entityId <= this.highRangeId;
    }

    public boolean isBelow(long entityId) {
        return this.highRangeId < entityId;
    }

    public long[] entities() {
        return this.entities;
    }

    public long[] tokens(long entityId) {
        int index = Math.toIntExact(entityId - this.lowRangeId);
        assert (index >= 0 && index < this.tokens.length) : "entityId:" + entityId + ", idRange:" + this.idRange;
        return this.tokens[index] != null ? this.tokens[index] : ArrayUtils.EMPTY_LONG_ARRAY;
    }

    private static String toString(String prefix, long[] entities, long[][] tokens) {
        StringBuilder result = new StringBuilder(prefix);
        result.append("; {");
        for (int i = 0; i < entities.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("Entity[").append(entities[i]).append("]: Tokens[");
            String sep = "";
            if (tokens[i] != null) {
                for (long tokenId : tokens[i]) {
                    result.append(sep).append(tokenId);
                    sep = ", ";
                }
            } else {
                result.append("null");
            }
            result.append(']');
        }
        return result.append("}]").toString();
    }

    public String toString() {
        String rangeName = this.entityType == EntityType.NODE ? "NodeLabelRange" : "RelationshipTypeRange";
        String rangeString = this.lowRangeId + "-" + (this.highRangeId + 1L);
        String prefix = rangeName + "[idRange=" + rangeString;
        return EntityTokenRangeImpl.toString(prefix, this.entities, this.tokens);
    }

    static void readBitmap(long bitmap, long tokenId, MutableLongList[] tokensPerEntity) {
        while (bitmap != 0L) {
            int relativeEntityId = Long.numberOfTrailingZeros(bitmap);
            if (tokensPerEntity[relativeEntityId] == null) {
                tokensPerEntity[relativeEntityId] = new LongArrayList();
            }
            tokensPerEntity[relativeEntityId].add(tokenId);
            bitmap &= bitmap - 1L;
        }
    }

    static long[][] convertState(LongList[] state) {
        long[][] tokenIdsByEntityIndex = new long[state.length][];
        for (int i = 0; i < state.length; ++i) {
            LongList tokenIdList = state[i];
            if (tokenIdList == null) continue;
            tokenIdsByEntityIndex[i] = tokenIdList.toArray();
        }
        return tokenIdsByEntityIndex;
    }
}

