/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsLayout;
import org.neo4j.kernel.impl.index.schema.PointLayout;
import org.neo4j.kernel.impl.index.schema.RangeLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

public class SchemaLayouts
implements LayoutBootstrapper {
    private final List<LayoutBootstrapper> allSchemaLayout = Arrays.asList(SchemaLayouts.idRangeLayout(), meta -> new LayoutBootstrapper.Layouts((Layout)new TokenScanLayout(), RootLayerConfiguration.singleRoot()), meta -> new LayoutBootstrapper.Layouts((Layout)new IndexStatisticsLayout(), RootLayerConfiguration.singleRoot()), SchemaLayouts.rangeLayout(), meta -> new LayoutBootstrapper.Layouts((Layout)new PointLayout(IndexSpecificSpaceFillingCurveSettings.fromConfig(Config.defaults())), RootLayerConfiguration.singleRoot()));

    public static String[] layoutDescriptions() {
        return new String[]{"Id range layout", "Token scan layout", "Index statistics layout", "Range index layout", "Point index layout"};
    }

    public LayoutBootstrapper.Layouts bootstrap(Meta meta) throws IOException {
        for (LayoutBootstrapper factory : this.allSchemaLayout) {
            LayoutBootstrapper.Layouts layout = factory.bootstrap(meta);
            if (layout == null || !SchemaLayouts.matchingLayout(meta, layout)) continue;
            return layout;
        }
        throw new RuntimeException("Could not find any layout matching meta " + meta);
    }

    private static boolean matchingLayout(Meta meta, LayoutBootstrapper.Layouts layouts) {
        try {
            meta.verify(layouts.dataLayout(), layouts.rootLayerConfiguration());
            return true;
        }
        catch (MetadataMismatchException e) {
            return false;
        }
    }

    private static LayoutBootstrapper rangeLayout() {
        return meta -> {
            int maxNumberOfSlots = 10;
            for (int numberOfSlots = 1; numberOfSlots < maxNumberOfSlots; ++numberOfSlots) {
                LayoutBootstrapper.Layouts layouts = new LayoutBootstrapper.Layouts((Layout)new RangeLayout(numberOfSlots), RootLayerConfiguration.singleRoot());
                if (!SchemaLayouts.matchingLayout(meta, layouts)) continue;
                return layouts;
            }
            return null;
        };
    }

    private static LayoutBootstrapper idRangeLayout() {
        return meta -> {
            int maxExponent = 10;
            for (int exponent = 0; exponent < maxExponent; ++exponent) {
                int idsPerEntry = 1 << exponent;
                LayoutBootstrapper.Layouts layouts = new LayoutBootstrapper.Layouts((Layout)new IdRangeLayout(idsPerEntry), RootLayerConfiguration.singleRoot());
                if (!SchemaLayouts.matchingLayout(meta, layouts)) continue;
                return layouts;
            }
            return null;
        };
    }
}

