/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.IndexReaderCache;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.ProcedureCaller;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.ReadSupport;
import org.neo4j.kernel.impl.newapi.SchemaReadCoreSnapshot;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public class AllStoreHolder
extends Read {
    private final GlobalProcedures globalProcedures;
    private final SchemaState schemaState;
    private final IndexingService indexingService;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Dependencies databaseDependencies;
    private final MemoryTracker memoryTracker;
    private final IndexReaderCache<ValueIndexReader> valueIndexReaderCache;
    private final IndexReaderCache<TokenIndexReader> tokenIndexReaderCache;
    private final ReadSupport readSupport;
    private final ProcedureCaller procedureCaller;

    public AllStoreHolder(StorageReader storageReader, KernelTransactionImplementation ktx, StorageLocks storageLocks, DefaultPooledCursors cursors, GlobalProcedures globalProcedures, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, MemoryTracker memoryTracker) {
        super(storageReader, cursors, ktx, storageLocks);
        this.globalProcedures = globalProcedures;
        this.schemaState = schemaState;
        this.valueIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newValueReader());
        this.tokenIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newTokenReader());
        this.indexingService = indexingService;
        this.indexStatisticsStore = indexStatisticsStore;
        this.databaseDependencies = databaseDependencies;
        this.memoryTracker = memoryTracker;
        this.readSupport = new ReadSupport(storageReader, cursors, this);
        this.procedureCaller = new ProcedureCaller(ktx, globalProcedures, (DependencyResolver)databaseDependencies);
    }

    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.readSupport.nodeExistsWithoutTxState(reference, this.ktx.securityContext().mode(), this.ktx.storeCursors(), this.ktx.cursorContext());
    }

    public boolean nodeDeletedInTransaction(long node) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().nodeIsDeletedInThisTx(node);
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() && this.txState().relationshipIsDeletedInThisTx(relationship);
    }

    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
    }

    public Value relationshipPropertyChangeInTransactionOrNull(long relationship, int propertyKeyId) {
        this.ktx.assertOpen();
        return this.hasTxStateWithChanges() ? this.txState().getRelationshipState(relationship).propertyValue(propertyKeyId) : null;
    }

    public long countsForNode(int labelId) {
        return this.countsForNodeWithoutTxState(labelId) + this.countsForNodeInTxState(labelId);
    }

    public long countsForNodeWithoutTxState(int labelId) {
        AccessMode mode = this.ktx.securityContext().mode();
        if (mode.allowsTraverseAllNodesWithLabel((long)labelId)) {
            return this.storageReader.countsForNode(labelId, this.ktx.cursorContext());
        }
        if (mode.disallowsTraverseLabel((long)labelId)) {
            return 0L;
        }
        long count = 0L;
        try (DefaultNodeCursor nodes = this.cursors.allocateNodeCursor(this.ktx.cursorContext());){
            this.allNodesScan(nodes);
            while (nodes.next()) {
                if (labelId != -1 && !nodes.hasLabel(labelId)) continue;
                ++count;
            }
        }
        return count - this.countsForNodeInTxState(labelId);
    }

    private long countsForNodeInTxState(int labelId) {
        long count = 0L;
        if (this.ktx.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.ktx.txState();
                CursorContext cursorContext = this.ktx.cursorContext();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, cursorContext, this.ktx.storeCursors());){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, cursorContext);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId) + this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        long count;
        CursorContext cursorContext;
        block41: {
            AccessMode mode = this.ktx.securityContext().mode();
            cursorContext = this.ktx.cursorContext();
            if (mode.allowsTraverseRelType(typeId) && mode.allowsTraverseNode(new long[]{startLabelId}) && mode.allowsTraverseNode(new long[]{endLabelId})) {
                return this.storageReader.countsForRelationship(startLabelId, typeId, endLabelId, cursorContext);
            }
            if (mode.disallowsTraverseRelType(typeId) || mode.disallowsTraverseLabel((long)startLabelId) || mode.disallowsTraverseLabel((long)endLabelId)) {
                return 0L;
            }
            if (typeId != -1) {
                try {
                    DefaultNodeCursor targetNode;
                    DefaultNodeCursor sourceNode;
                    IndexDescriptor index = this.findUsableTokenIndex(EntityType.RELATIONSHIP);
                    if (index == IndexDescriptor.NO_INDEX) break block41;
                    long count2 = 0L;
                    try (DefaultRelationshipTypeIndexCursor relationshipsWithType = this.cursors.allocateRelationshipTypeIndexCursor(cursorContext);){
                        sourceNode = this.cursors.allocateNodeCursor(cursorContext);
                        try {
                            targetNode = this.cursors.allocateNodeCursor(cursorContext);
                            try {
                                TokenReadSession session = this.tokenReadSession(index);
                                this.relationshipTypeScan(session, relationshipsWithType, IndexQueryConstraints.unconstrained(), new TokenPredicate(typeId), this.ktx.cursorContext());
                            }
                            finally {
                                if (targetNode != null) {
                                    targetNode.close();
                                }
                            }
                        }
                        finally {
                            if (sourceNode != null) {
                                sourceNode.close();
                            }
                        }
                    }
                    return (count2 += AllStoreHolder.countRelationshipsWithEndLabels((RelationshipIndexCursor)relationshipsWithType, sourceNode, targetNode, startLabelId, endLabelId)) - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
                }
                catch (KernelException index) {
                    // empty catch block
                }
            }
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(cursorContext);
             FullAccessNodeCursor sourceNode = this.cursors.allocateFullAccessNodeCursor(cursorContext);
             FullAccessNodeCursor targetNode = this.cursors.allocateFullAccessNodeCursor(cursorContext);){
            this.allRelationshipsScan(rels);
            Predicate<RelationshipScanCursor> predicate = typeId == -1 ? Predicates.alwaysTrue() : CursorPredicates.hasType(typeId);
            FilteringRelationshipScanCursorWrapper filteredCursor = new FilteringRelationshipScanCursorWrapper(rels, predicate);
            count = AllStoreHolder.countRelationshipsWithEndLabels(filteredCursor, (DefaultNodeCursor)sourceNode, (DefaultNodeCursor)targetNode, startLabelId, endLabelId);
        }
        return count - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    private static long countRelationshipsWithEndLabels(RelationshipIndexCursor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!relationship.readFromStore() || !AllStoreHolder.matchesLabels((RelationshipDataAccessor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static long countRelationshipsWithEndLabels(RelationshipScanCursor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!AllStoreHolder.matchesLabels((RelationshipDataAccessor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static boolean matchesLabels(RelationshipDataAccessor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        relationship.source((NodeCursor)sourceNode);
        relationship.target((NodeCursor)targetNode);
        return !(!sourceNode.next() || startLabelId != -1 && !sourceNode.hasLabel(startLabelId) || !targetNode.next() || endLabelId != -1 && !targetNode.hasLabel(endLabelId));
    }

    private long countsForRelationshipInTxState(int startLabelId, int typeId, int endLabelId) {
        long count = 0L;
        if (this.ktx.hasTxStateWithChanges()) {
            CursorContext cursorContext = this.ktx.cursorContext();
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.ktx.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, cursorContext, this.ktx.storeCursors());){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, cursorContext);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    IndexDescriptor findUsableTokenIndex(EntityType entityType) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)entityType);
        IndexDescriptor index = this.index((SchemaDescriptor)descriptor, IndexType.LOOKUP);
        if (index != IndexDescriptor.NO_INDEX && this.indexGetState(index) == InternalIndexState.ONLINE) {
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    public boolean relationshipExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        AccessMode mode = this.ktx.securityContext().mode();
        return this.readSupport.relationshipExistsWithoutTx(reference, mode, this.ktx.storeCursors(), this.ktx.cursorContext());
    }

    @Override
    public ValueIndexReader newValueIndexReader(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).newValueReader();
    }

    public IndexReadSession indexReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return new DefaultIndexReadSession(this.valueIndexReaderCache.getOrCreate(index), index);
    }

    public TokenReadSession tokenReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return new DefaultTokenReadSession(this.tokenIndexReaderCache.getOrCreate(index), index);
    }

    public Iterator<IndexDescriptor> indexForSchemaNonTransactional(SchemaDescriptor schema) {
        return this.storageReader.indexGetForSchema(schema);
    }

    public IndexDescriptor indexForSchemaAndIndexTypeNonTransactional(SchemaDescriptor schema, IndexType indexType) {
        IndexDescriptor index = this.storageReader.indexGetForSchemaAndType(schema, indexType);
        return index == null ? IndexDescriptor.NO_INDEX : index;
    }

    public Iterator<IndexDescriptor> indexForSchemaNonLocking(SchemaDescriptor schema) {
        return this.indexGetForSchema((StorageSchemaReader)this.storageReader, schema);
    }

    public Iterator<IndexDescriptor> getLabelIndexesNonLocking(int labelId) {
        return this.indexesGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    public Iterator<IndexDescriptor> getRelTypeIndexesNonLocking(int relTypeId) {
        return this.indexesGetForRelationshipType((StorageSchemaReader)this.storageReader, relTypeId);
    }

    public Iterator<IndexDescriptor> indexesGetAllNonLocking() {
        return this.indexesGetAll((StorageSchemaReader)this.storageReader);
    }

    private IndexDescriptor lockIndex(IndexDescriptor index) {
        if (index == null) {
            return IndexDescriptor.NO_INDEX;
        }
        if (!this.indexExists(index = this.acquireSharedSchemaLock(index))) {
            this.releaseSharedSchemaLock(index);
            index = IndexDescriptor.NO_INDEX;
        }
        return index;
    }

    private Iterator<IndexDescriptor> lockIndexes(Iterator<IndexDescriptor> indexes) {
        Predicate<IndexDescriptor> exists = index -> index != IndexDescriptor.NO_INDEX;
        return Iterators.filter(exists, (Iterator)Iterators.map(this::lockIndex, indexes));
    }

    private boolean indexExists(IndexDescriptor index) {
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets changes = this.ktx.txState().indexChanges();
            return changes.isAdded((Object)index) || this.storageReader.indexExists(index) && !changes.isRemoved((Object)index);
        }
        return this.storageReader.indexExists(index);
    }

    public void assertIndexExists(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (!this.indexExists(index)) {
            throw new IndexNotFoundKernelException("Index does not exist: ", index);
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        if (constraint == null) {
            return null;
        }
        if (!this.constraintExists(constraint = this.acquireSharedSchemaLock(constraint))) {
            this.releaseSharedSchemaLock(constraint);
            constraint = null;
        }
        return constraint;
    }

    private Iterator<ConstraintDescriptor> lockConstraints(Iterator<ConstraintDescriptor> constraints) {
        return Iterators.filter(Objects::nonNull, (Iterator)Iterators.map(this::lockConstraint, constraints));
    }

    public boolean constraintExists(ConstraintDescriptor constraint) {
        this.acquireSharedSchemaLock(constraint);
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets changes = this.ktx.txState().constraintsChanges();
            return changes.isAdded((Object)constraint) || this.storageReader.constraintExists(constraint) && !changes.isRemoved((Object)constraint);
        }
        return this.storageReader.constraintExists(constraint);
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexGetForSchema((StorageSchemaReader)this.storageReader, schema));
    }

    Iterator<IndexDescriptor> indexGetForSchema(StorageSchemaReader reader, SchemaDescriptor schema) {
        Iterator indexes = reader.indexGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets diffSets = this.ktx.txState().indexDiffSetsBySchema(schema);
            indexes = diffSets.apply(indexes);
        }
        return indexes;
    }

    public IndexDescriptor index(SchemaDescriptor schema, IndexType type) {
        this.ktx.assertOpen();
        return this.lockIndex(this.indexGetForSchemaAndType((StorageSchemaReader)this.storageReader, schema, type));
    }

    IndexDescriptor indexGetForSchemaAndType(StorageSchemaReader reader, SchemaDescriptor schema, IndexType type) {
        IndexDescriptor index = reader.indexGetForSchemaAndType(schema, type);
        if (this.ktx.hasTxStateWithChanges()) {
            DiffSets indexChanges = this.ktx.txState().indexChanges();
            if (index == null) {
                Set added = indexChanges.filterAdded(id -> id.getIndexType() == type && id.schema().equals(schema)).getAdded();
                index = (IndexDescriptor)Iterators.singleOrNull(added.iterator());
            }
            if (indexChanges.isRemoved((Object)index)) {
                return null;
            }
        }
        return index;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexesGetForLabel((StorageSchemaReader)this.storageReader, labelId));
    }

    Iterator<IndexDescriptor> indexesGetForLabel(StorageSchemaReader reader, int labelId) {
        if (this.ktx.securityContext().mode().allowsTraverseNode(new long[]{labelId})) {
            Iterator iterator = reader.indexesGetForLabel(labelId);
            if (this.ktx.hasTxStateWithChanges()) {
                iterator = this.ktx.txState().indexDiffSetsByLabel(labelId).apply(iterator);
            }
            return iterator;
        }
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.ktx.assertOpen();
        return this.lockIndexes(this.indexesGetForRelationshipType((StorageSchemaReader)this.storageReader, relationshipType));
    }

    Iterator<IndexDescriptor> indexesGetForRelationshipType(StorageSchemaReader reader, int relationshipType) {
        Iterator iterator = reader.indexesGetForRelationshipType(relationshipType);
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexDiffSetsByRelationshipType(relationshipType).apply(iterator);
        }
        return iterator;
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.indexGetForName((StorageSchemaReader)this.storageReader, name);
    }

    IndexDescriptor indexGetForName(StorageSchemaReader reader, String name) {
        this.ktx.assertOpen();
        IndexDescriptor index = reader.indexGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> indexDescriptor.getName().equals(name);
            Iterator indexes = this.ktx.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)index));
            index = (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
        }
        return this.lockIndex(index);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.constraintGetForName((StorageSchemaReader)this.storageReader, name);
    }

    ConstraintDescriptor constraintGetForName(StorageSchemaReader reader, String name) {
        this.ktx.assertOpen();
        ConstraintDescriptor constraint = reader.constraintGetForName(name);
        if (this.ktx.hasTxStateWithChanges()) {
            Predicate<ConstraintDescriptor> namePredicate = constraintDescriptor -> constraintDescriptor.getName().equals(name);
            Iterator constraints = this.ktx.txState().constraintsChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)constraint));
            constraint = (ConstraintDescriptor)Iterators.singleOrNull((Iterator)constraints);
        }
        return this.lockConstraint(constraint);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        this.ktx.assertOpen();
        Iterator<IndexDescriptor> iterator = this.indexesGetAll((StorageSchemaReader)this.storageReader);
        return this.lockIndexes(iterator);
    }

    Iterator<IndexDescriptor> indexesGetAll(StorageSchemaReader reader) {
        Iterator iterator = reader.indexesGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            iterator = this.ktx.txState().indexChanges().apply(iterator);
        }
        return iterator;
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexGetStateLocked(index);
    }

    public InternalIndexState indexGetStateNonLocking(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.ktx.assertOpen();
        return this.indexGetStateLocked(index);
    }

    InternalIndexState indexGetStateLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        SchemaDescriptor schema = index.schema();
        if (this.ktx.hasTxStateWithChanges() && AllStoreHolder.checkIndexState(index, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(schema))) {
            return InternalIndexState.POPULATING;
        }
        return this.indexingService.getIndexProxy(index).getState();
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexGetPopulationProgressLocked(index);
    }

    PopulationProgress indexGetPopulationProgressLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && AllStoreHolder.checkIndexState(index, (DiffSets<IndexDescriptor>)this.ktx.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.indexingService.getIndexProxy(index).getIndexPopulationProgress();
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.storageReader.indexGetOwningUniquenessConstraintId(this.storageReader.indexGetForName(index.getName()));
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).getPopulationFailure().asString();
    }

    public double indexUniqueValuesSelectivity(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        this.assertIndexExists(index);
        IndexSample indexSample = this.indexStatisticsStore.indexSample(index.getId());
        long unique = indexSample.uniqueValues();
        long size = indexSample.sampleSize();
        return size == 0L ? 1.0 : (double)unique / (double)size;
    }

    public long indexSize(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.ktx.assertOpen();
        return this.indexStatisticsStore.indexSample(index.getId()).indexSize();
    }

    public long nodesGetCount() {
        return this.countsForNode(-1);
    }

    public long relationshipsGetCount() {
        return this.countsForRelationship(-1, -1, -1);
    }

    public IndexSample indexSample(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.ktx.assertOpen();
        AllStoreHolder.assertValidIndex(index);
        return this.indexStatisticsStore.indexSample(index.getId());
    }

    private static boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded((Object)index)) {
            return true;
        }
        if (diffSet.isRemoved((Object)index)) {
            throw new IndexNotFoundKernelException("Index has been dropped in this transaction: ", index);
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor schema) {
        this.acquireSharedSchemaLock(() -> schema);
        return this.getConstraintsForSchema(schema);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchemaNonLocking(SchemaDescriptor schema) {
        return this.getConstraintsForSchema(schema);
    }

    private Iterator<ConstraintDescriptor> getConstraintsForSchema(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        Iterator constraints = this.storageReader.constraintsGetForSchema(schema);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(schema).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        return this.constraintsGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabelNonLocking(int labelId) {
        this.ktx.assertOpen();
        return this.constraintsGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForLabel(StorageSchemaReader reader, int labelId) {
        Iterator constraints = reader.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.constraintsGetAll((StorageSchemaReader)this.storageReader);
        return this.lockConstraints(constraints);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAllNonLocking() {
        this.ktx.assertOpen();
        return this.constraintsGetAll((StorageSchemaReader)this.storageReader);
    }

    Iterator<ConstraintDescriptor> constraintsGetAll(StorageSchemaReader reader) {
        Iterator constraints = reader.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, typeId);
        this.ktx.assertOpen();
        return this.constraintsGetForRelationshipType((StorageSchemaReader)this.storageReader, typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipTypeNonLocking(int typeId) {
        this.ktx.assertOpen();
        return this.constraintsGetForRelationshipType((StorageSchemaReader)this.storageReader, typeId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(StorageSchemaReader reader, int typeId) {
        Iterator constraints = reader.constraintsGetForRelationshipType(typeId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    public SchemaReadCore snapshot() {
        this.ktx.assertOpen();
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        return new SchemaReadCoreSnapshot(snapshot, this.ktx, this);
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.globalProcedures.function(name);
    }

    public Stream<UserFunctionSignature> functionGetAll() {
        this.ktx.assertOpen();
        return this.globalProcedures.getAllNonAggregatingFunctions();
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.ktx.assertOpen();
        return this.globalProcedures.procedure(name);
    }

    public Set<ProcedureSignature> proceduresGetAll() {
        this.ktx.assertOpen();
        return this.globalProcedures.getAllProcedures();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.ktx.assertOpen();
        return this.globalProcedures.aggregationFunction(name);
    }

    public Stream<UserFunctionSignature> aggregationFunctionGetAll() {
        this.ktx.assertOpen();
        return this.globalProcedures.getAllAggregatingFunctions();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller.callProcedure(id, arguments, AccessMode.Static.READ, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller.callProcedure(id, arguments, AccessMode.Static.TOKEN_WRITE, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller.callProcedure(id, arguments, AccessMode.Static.SCHEMA, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller.callProcedure(id, arguments, AccessMode.Static.ACCESS, context);
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        return this.procedureCaller.callFunction(id, arguments);
    }

    public AnyValue builtInFunctionCall(int id, AnyValue[] arguments) throws ProcedureException {
        return this.procedureCaller.callBuiltInFunction(id, arguments);
    }

    public UserAggregator aggregationFunction(int id) throws ProcedureException {
        return this.procedureCaller.createAggregationFunction(id);
    }

    public UserAggregator builtInAggregationFunction(int id) throws ProcedureException {
        return this.procedureCaller.createBuiltInAggregationFunction(id);
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return (V)this.schemaState.getOrCreate(key, creator);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    public boolean transactionStateHasChanges() {
        return this.ktx.hasTxStateWithChanges();
    }

    static void assertValidIndex(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }

    public void release() {
        this.valueIndexReaderCache.close();
        this.tokenIndexReaderCache.close();
    }

    public CursorContext cursorContext() {
        return this.ktx.cursorContext();
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public IndexMonitor monitor() {
        return this.indexingService.getMonitor();
    }
}

