/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class DefaultPropertyCursor
extends TraceableCursor<DefaultPropertyCursor>
implements PropertyCursor,
Supplier<TokenSet>,
RelTypeSupplier {
    private static final int NODE = -2;
    private Read read;
    private final StoragePropertyCursor storeCursor;
    private final FullAccessNodeCursor securityNodeCursor;
    private final FullAccessRelationshipScanCursor securityRelCursor;
    private EntityState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private AssertOpen assertOpen;
    private AccessMode accessMode;
    private long entityReference = -1L;
    private TokenSet labels;
    private int type = -1;
    private boolean addedInTx;
    private PropertySelection selection;

    DefaultPropertyCursor(CursorPool<DefaultPropertyCursor> pool, StoragePropertyCursor storeCursor, FullAccessNodeCursor securityNodeCursor, FullAccessRelationshipScanCursor securityRelCursor) {
        super(pool);
        this.storeCursor = storeCursor;
        this.securityNodeCursor = securityNodeCursor;
        this.securityRelCursor = securityRelCursor;
    }

    void initNode(long nodeReference, Reference reference, PropertySelection selection, Read read, AssertOpen assertOpen) {
        assert (nodeReference != -1L);
        this.init(selection, read, assertOpen);
        this.type = -2;
        this.storeCursor.initNodeProperties(reference, selection);
        this.entityReference = nodeReference;
        this.initializeNodeTransactionState(nodeReference, read);
    }

    void initNode(DefaultNodeCursor nodeCursor, PropertySelection selection, Read read, AssertOpen assertOpen) {
        this.entityReference = nodeCursor.nodeReference();
        assert (this.entityReference != -1L);
        this.init(selection, read, assertOpen);
        this.type = -2;
        this.addedInTx = nodeCursor.currentNodeIsAddedInTx();
        if (!this.addedInTx) {
            this.storeCursor.initNodeProperties(nodeCursor.storeCursor, selection);
        } else {
            this.storeCursor.initNodeProperties(LongReference.NULL_REFERENCE, PropertySelection.ALL_PROPERTIES);
        }
        this.initializeNodeTransactionState(this.entityReference, read);
    }

    private void initializeNodeTransactionState(long nodeReference, Read read) {
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initRelationship(long relationshipReference, Reference reference, PropertySelection selection, Read read, AssertOpen assertOpen) {
        assert (relationshipReference != -1L);
        this.init(selection, read, assertOpen);
        this.storeCursor.initRelationshipProperties(reference, selection);
        this.entityReference = relationshipReference;
        this.initializeRelationshipTransactionState(relationshipReference, read);
    }

    void initRelationship(DefaultRelationshipCursor relationshipCursor, PropertySelection selection, Read read, AssertOpen assertOpen) {
        this.entityReference = relationshipCursor.relationshipReference();
        assert (this.entityReference != -1L);
        this.init(selection, read, assertOpen);
        this.addedInTx = relationshipCursor.currentRelationshipIsAddedInTx();
        if (!this.addedInTx) {
            this.storeCursor.initRelationshipProperties(relationshipCursor.storeCursor, selection);
        } else {
            this.storeCursor.initRelationshipProperties(LongReference.NULL_REFERENCE, selection);
        }
        this.initializeRelationshipTransactionState(this.entityReference, read);
    }

    private void initializeRelationshipTransactionState(long relationshipReference, Read read) {
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initEmptyRelationship(Read read, AssertOpen assertOpen) {
        this.init(PropertySelection.ALL_PROPERTIES, read, assertOpen);
        this.storeCursor.initRelationshipProperties(LongReference.NULL_REFERENCE, PropertySelection.ALL_PROPERTIES);
        this.entityReference = -1L;
        this.propertiesState = null;
        this.txStateChangedProperties = null;
    }

    private void init(PropertySelection selection, Read read, AssertOpen assertOpen) {
        this.selection = selection;
        this.assertOpen = assertOpen;
        this.read = read;
        this.labels = null;
        this.type = -1;
    }

    boolean allowed(int propertyKey) {
        if (this.isNode()) {
            this.ensureAccessMode();
            return this.accessMode.allowsReadNodeProperty((Supplier)this, propertyKey);
        }
        this.ensureAccessMode();
        return this.accessMode.allowsReadRelationshipProperty((RelTypeSupplier)this, propertyKey);
    }

    public boolean next() {
        if (this.txStateChangedProperties != null) {
            while (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                if (!this.selection.test(this.txStateValue.propertyKeyId())) continue;
                if (this.tracer != null) {
                    this.tracer.onProperty(this.txStateValue.propertyKeyId());
                }
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            int propertyKey = this.storeCursor.propertyKey();
            boolean skip = this.propertiesState != null && this.propertiesState.isPropertyChangedOrRemoved(propertyKey);
            if (skip || !this.allowed(propertyKey)) continue;
            if (this.tracer != null) {
                this.tracer.onProperty(propertyKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            this.accessMode = null;
        }
        super.closeInternal();
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.storeCursor.propertyValue();
        this.assertOpen.assertOpen();
        return value;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + this.storeCursor + " ]";
    }

    @Override
    public TokenSet get() {
        assert (this.isNode());
        if (this.labels == null) {
            this.read.singleNode(this.entityReference, this.securityNodeCursor);
            this.securityNodeCursor.next();
            this.labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove();
        }
        return this.labels;
    }

    public int getRelType() {
        assert (this.isRelationship());
        if (this.type < 0) {
            this.read.singleRelationship(this.entityReference, this.securityRelCursor);
            this.securityRelCursor.next();
            this.type = this.securityRelCursor.type();
        }
        return this.type;
    }

    private void ensureAccessMode() {
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
    }

    public void release() {
        if (this.storeCursor != null) {
            this.storeCursor.close();
        }
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
        if (this.securityRelCursor != null) {
            this.securityRelCursor.close();
            this.securityRelCursor.release();
        }
    }

    private boolean isNode() {
        return this.type == -2;
    }

    private boolean isRelationship() {
        return this.type != -2;
    }
}

