/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

class DefaultRelationshipValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultRelationshipValueIndexCursor>
implements RelationshipValueIndexCursor {
    private final DefaultRelationshipScanCursor relationshipScanCursor;
    private final DefaultPropertyCursor propertyCursor;
    private int[] propertyIds;

    DefaultRelationshipValueIndexCursor(CursorPool<DefaultRelationshipValueIndexCursor> pool, DefaultRelationshipScanCursor relationshipScanCursor, DefaultPropertyCursor propertyCursor, MemoryTracker memoryTracker) {
        super(pool, memoryTracker);
        this.relationshipScanCursor = relationshipScanCursor;
        this.propertyCursor = propertyCursor;
    }

    public void source(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.targetNodeReference(), cursor);
    }

    public int type() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.type();
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.targetNodeReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.checkReadFromStore();
        this.relationshipScanCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.propertiesReference();
    }

    public boolean readFromStore() {
        if (this.relationshipScanCursor.relationshipReference() == this.entity) {
            return true;
        }
        this.relationshipScanCursor.single(this.entity, this.read);
        return this.relationshipScanCursor.next();
    }

    private void checkReadFromStore() {
        if (this.relationshipScanCursor.relationshipReference() != this.entity) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }

    @Override
    protected boolean doStoreValuePassesQueryFilter(long reference, PropertySelection propertySelection, PropertyIndexQuery[] query) {
        this.read.singleRelationship(reference, this.relationshipScanCursor);
        if (this.relationshipScanCursor.next()) {
            this.relationshipScanCursor.properties(this.propertyCursor, propertySelection);
            return CursorPredicates.propertiesMatch(this.propertyCursor, query);
        }
        return false;
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor, AccessMode accessMode) {
        this.propertyIds = descriptor.schema().getPropertyIds();
        for (int relType : descriptor.schema().getEntityTokenIds()) {
            if (accessMode.allowsTraverseRelType(relType)) continue;
            return false;
        }
        if (!accessMode.allowsTraverseAllLabels()) {
            return false;
        }
        for (int propId : this.propertyIds) {
            for (int relType : descriptor.schema().getEntityTokenIds()) {
                if (accessMode.allowsReadRelationshipProperty(() -> relType, propId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected ImmutableLongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedRelationships().getRemoved(), (LongIterable)removedFromIndex).toImmutable();
    }

    @Override
    protected boolean allowed(long reference, AccessMode accessMode) {
        this.readEntity(read -> read.singleRelationship(reference, this.relationshipScanCursor));
        if (!this.relationshipScanCursor.next()) {
            return false;
        }
        int relType = this.relationshipScanCursor.type();
        for (int prop : this.propertyIds) {
            if (accessMode.allowsReadRelationshipProperty(() -> relType, prop)) continue;
            return false;
        }
        return true;
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    String implementationName() {
        return "RelationshipValueIndexCursor";
    }

    public void release() {
        this.relationshipScanCursor.close();
        this.relationshipScanCursor.release();
        this.propertyCursor.close();
        this.propertyCursor.release();
    }
}

