/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ReadSupport {
    private final StorageReader storageReader;
    private final DefaultPooledCursors cursors;
    private final Read readDelegate;

    public ReadSupport(StorageReader storageReader, DefaultPooledCursors cursors, Read readDelegate) {
        this.storageReader = storageReader;
        this.cursors = cursors;
        this.readDelegate = readDelegate;
    }

    public boolean nodeExistsWithoutTxState(long reference, AccessMode accessMode, StoreCursors storeCursors, CursorContext cursorContext) {
        boolean existsInNodeStore = this.storageReader.nodeExists(reference, storeCursors);
        if (accessMode.allowsTraverseAllLabels()) {
            return existsInNodeStore;
        }
        if (!existsInNodeStore) {
            return false;
        }
        try (DefaultNodeCursor node = this.cursors.allocateNodeCursor(cursorContext);){
            this.readDelegate.singleNode(reference, (NodeCursor)node);
            boolean bl = node.next();
            return bl;
        }
    }

    public boolean relationshipExistsWithoutTx(long reference, AccessMode accessMode, StoreCursors storeCursors, CursorContext cursorContext) {
        boolean existsInRelStore = this.storageReader.relationshipExists(reference, storeCursors);
        if (accessMode.allowsTraverseAllRelTypes()) {
            return existsInRelStore;
        }
        if (!existsInRelStore) {
            return false;
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            this.readDelegate.singleRelationship(reference, (RelationshipScanCursor)rels);
            boolean bl = rels.next();
            return bl;
        }
    }
}

