/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.IndexFailureRecord;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<IndexFailureRecord> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<IndexFailureRecord> exceptions) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions));
        this.exceptions = Collections.unmodifiableSet(exceptions);
        for (IndexFailureRecord failureRecord : exceptions) {
            this.addSuppressed((Throwable)failureRecord.exception());
        }
    }

    private static String buildMessage(Set<IndexFailureRecord> exceptions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (IndexFailureRecord pair : exceptions) {
            builder.append(String.format(" (%s) %s", pair.descriptor(), pair.exception().getMessage()));
        }
        return builder.toString();
    }
}

