/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogInitializer {
    private final FileSystemAbstraction fs;
    private final MetadataProvider store;
    private final StorageEngineFactory storageEngineFactory;

    public static LogFilesInitializer getLogFilesInitializer() {
        return (databaseLayout, store, fileSystem, checkpointReason) -> {
            try {
                TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, store, StorageEngineFactory.defaultStorageEngine());
                initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Fail to create empty transaction log file.", (Throwable)e);
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, MetadataProvider store, StorageEngineFactory storageEngineFactory) {
        this.fs = fs;
        this.store = store;
        this.storageEngineFactory = storageEngineFactory;
    }

    public long initializeEmptyLogFile(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws IOException {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    public long migrateExistingLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            LogFile logFile = logFiles.getLogFile();
            for (long version = logFile.getLowestLogVersion(); version <= logFile.getHighestLogVersion(); ++version) {
                this.fs.deleteFile(logFile.getLogFileForVersion(version));
            }
            CheckpointFile checkpointFile = logFiles.getCheckpointFile();
            for (long version = checkpointFile.getLowestLogVersion(); version <= checkpointFile.getHighestLogVersion(); ++version) {
                this.fs.deleteFile(checkpointFile.getDetachedCheckpointFileForVersion(version));
            }
            logFile.rotate();
            checkpointFile.rotate();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, Path transactionLogsDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder(layout, this.fs).withLogVersionRepository((LogVersionRepository)this.store).withTransactionIdStore((TransactionIdStore)this.store).withStoreId(this.store.getStoreId()).withLogsDirectory(transactionLogsDirectory).withStorageEngineFactory(this.storageEngineFactory).withDatabaseHealth(new DatabaseHealth(PanicEventGenerator.NO_OP, (InternalLog)NullLog.getInstance())).build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private long appendEmptyTransactionAndCheckPoint(LogFiles logFiles, String reason) throws IOException {
        TransactionId committedTx = this.store.getLastCommittedTransaction();
        long timestamp = committedTx.commitTimestamp();
        long upgradeTransactionId = this.store.nextCommittingTransactionId();
        LogFile logFile = logFiles.getLogFile();
        TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
        PhysicalTransactionRepresentation emptyTx = TransactionLogInitializer.emptyTransaction(timestamp, upgradeTransactionId);
        int checksum = transactionLogWriter.append(emptyTx, upgradeTransactionId, -559063315);
        logFile.forceAfterAppend(LogAppendEvent.NULL);
        LogPosition position = transactionLogWriter.getCurrentPosition();
        TransactionLogInitializer.appendCheckpoint(logFiles, reason, position, new TransactionId(upgradeTransactionId, checksum, timestamp));
        this.store.transactionCommitted(upgradeTransactionId, checksum, timestamp);
        return upgradeTransactionId;
    }

    private static PhysicalTransactionRepresentation emptyTransaction(long timestamp, long txId) {
        return new PhysicalTransactionRepresentation(Collections.emptyList(), ArrayUtils.EMPTY_BYTE_ARRAY, timestamp, txId, timestamp, -1, AuthSubject.ANONYMOUS);
    }

    private static void appendCheckpoint(LogFiles logFiles, String reason, LogPosition position, TransactionId transactionId) throws IOException {
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, position, Instant.now(), reason);
    }
}

