/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Optional;
import java.util.function.IntPredicate;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexedStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelIndexedNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeRelationshipsIndexedStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipIndexedRelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageReader;

public class DynamicIndexStoreView
implements IndexStoreView {
    private final FullScanStoreView fullScanStoreView;
    private final Locks locks;
    protected final LockService lockService;
    private final Config config;
    private final IndexingService.IndexProxyProvider indexProxies;
    protected final ReadableStorageEngine storageEngine;
    private final InternalLog log;

    public DynamicIndexStoreView(FullScanStoreView fullScanStoreView, Locks locks, LockService lockService, Config config, IndexingService.IndexProxyProvider indexProxies, ReadableStorageEngine storageEngine, InternalLogProvider logProvider) {
        this.fullScanStoreView = fullScanStoreView;
        this.locks = locks;
        this.lockService = lockService;
        this.config = config;
        this.indexProxies = indexProxies;
        this.storageEngine = storageEngine;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        Optional<TokenIndexData> tokenIndex = this.findTokenIndex(EntityType.NODE);
        if (tokenIndex.isPresent()) {
            LabelIndexedNodeStoreScan nodeStoreScan = new LabelIndexedNodeStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.lockService, tokenIndex.get().reader, labelScanConsumer, propertyScanConsumer, labelIds, propertyKeyIdFilter, parallelWrite, this.fullScanStoreView.scheduler, contextFactory, memoryTracker);
            return new IndexedStoreScan(this.locks, tokenIndex.get().descriptor, this.config, nodeStoreScan);
        }
        return this.fullScanStoreView.visitNodes(labelIds, propertyKeyIdFilter, propertyScanConsumer, labelScanConsumer, forceStoreScan, parallelWrite, contextFactory, memoryTracker);
    }

    @Override
    public StoreScan visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer relationshipTypeScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        Optional<TokenIndexData> tokenIndex = this.findTokenIndex(EntityType.RELATIONSHIP);
        if (tokenIndex.isPresent()) {
            PropertyAwareEntityStoreScan storeScan = this.fullScanStoreView.storageEngine.indexingBehaviour().useNodeIdsInRelationshipTypeScanIndex() ? new NodeRelationshipsIndexedStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.lockService, tokenIndex.get().reader, relationshipTypeScanConsumer, propertyScanConsumer, relationshipTypeIds, propertyKeyIdFilter, parallelWrite, this.fullScanStoreView.scheduler, contextFactory, memoryTracker) : new RelationshipIndexedRelationshipStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.lockService, tokenIndex.get().reader, relationshipTypeScanConsumer, propertyScanConsumer, relationshipTypeIds, propertyKeyIdFilter, parallelWrite, this.fullScanStoreView.scheduler, contextFactory, memoryTracker);
            return new IndexedStoreScan(this.locks, tokenIndex.get().descriptor, this.config, storeScan);
        }
        return this.fullScanStoreView.visitRelationships(relationshipTypeIds, propertyKeyIdFilter, propertyScanConsumer, relationshipTypeScanConsumer, forceStoreScan, parallelWrite, contextFactory, memoryTracker);
    }

    @Override
    public boolean isEmpty(CursorContext cursorContext) {
        return this.fullScanStoreView.isEmpty(cursorContext);
    }

    private Optional<TokenIndexData> findTokenIndex(EntityType entityType) {
        IndexDescriptor descriptor;
        try (StorageReader reader = this.storageEngine.newReader();){
            descriptor = reader.indexGetForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType), IndexType.LOOKUP);
        }
        if (descriptor == null) {
            return Optional.empty();
        }
        try {
            IndexProxy indexProxy = this.indexProxies.getIndexProxy(descriptor);
            if (indexProxy.getState() == InternalIndexState.ONLINE) {
                return Optional.of(new TokenIndexData(indexProxy.newTokenReader(), indexProxy.getDescriptor()));
            }
        }
        catch (IndexNotFoundKernelException e) {
            this.log.warn("Token index missing for entity: %s, switching to full scan", new Object[]{entityType, e});
        }
        return Optional.empty();
    }

    private record TokenIndexData(TokenIndexReader reader, IndexDescriptor descriptor) {
    }
}

