/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ReentrantLockService;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Preconditions;

final class ParallelRecoveryVisitor
implements RecoveryApplier {
    private final AtomicLong prevLockedTxId = new AtomicLong(-1L);
    private final StorageEngine storageEngine;
    private final LockService lockService = new ReentrantLockService();
    private final TransactionApplicationMode mode;
    private final CursorContextFactory contextFactory;
    private final String tracerTag;
    private final ExecutorService appliers;
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final int stride;

    ParallelRecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        this(storageEngine, mode, contextFactory, tracerTag, Integer.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    ParallelRecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag, int numAppliers) {
        this.storageEngine = storageEngine;
        this.mode = mode;
        this.contextFactory = contextFactory;
        this.tracerTag = tracerTag;
        this.appliers = new ThreadPoolExecutor(numAppliers, numAppliers, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(numAppliers), new ThreadPoolExecutor.CallerRunsPolicy());
        this.stride = mode == TransactionApplicationMode.REVERSE_RECOVERY ? -1 : 1;
    }

    public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
        this.checkFailure();
        this.prevLockedTxId.compareAndSet(-1L, transaction.getCommitEntry().getTxId() - (long)this.stride);
        this.appliers.submit(() -> {
            long txId = transaction.getCommitEntry().getTxId();
            while (this.prevLockedTxId.get() != txId - (long)this.stride) {
                Thread.onSpinWait();
                this.checkFailure();
            }
            try (LockGroup locks = new LockGroup();){
                this.storageEngine.lockRecoveryCommands((CommandStream)transaction.getTransactionRepresentation(), this.lockService, locks, this.mode);
                boolean myTurn = this.prevLockedTxId.compareAndSet(txId - (long)this.stride, txId);
                Preconditions.checkState((boolean)myTurn, (String)"Something wrong with the algorithm, I thought it was my turn, but apparently it wasn't %d", (Object[])new Object[]{txId});
                this.apply(transaction);
            }
            catch (Throwable e) {
                this.failure.compareAndSet(null, e);
            }
            return null;
        });
        return false;
    }

    private void checkFailure() throws Exception {
        Throwable failure = this.failure.get();
        if (failure != null) {
            Exceptions.throwIfUnchecked((Throwable)failure);
            throw new Exception("One or more recovering transactions failed to apply", failure);
        }
    }

    private void apply(CommittedTransactionRepresentation transaction) throws Exception {
        try (CursorContext cursorContext = this.contextFactory.create(this.tracerTag);
             StoreCursors storeCursors = this.storageEngine.createStorageCursors(cursorContext);){
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            TransactionToApply tx = new TransactionToApply(txRepresentation, txId, cursorContext, storeCursors);
            tx.commitment(Commitment.NO_COMMITMENT, txId);
            tx.logPosition(transaction.getStartEntry().getStartPosition());
            this.storageEngine.apply((CommandsToApply)tx, this.mode);
        }
    }

    @Override
    public void close() throws Exception {
        this.appliers.shutdown();
        try {
            if (!this.appliers.awaitTermination(1L, TimeUnit.HOURS)) {
                throw new IllegalStateException("Recovery couldn't gracefully await remaining appliers");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.checkFailure();
    }
}

