/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.MaximumTransactionLimitExceededException;
import org.neo4j.kernel.impl.api.TokenHoldersIdLookup;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionIdSequence;
import org.neo4j.kernel.impl.api.TransactionRegistry;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.enrichment.ApplyEnrichmentStrategy;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;

public class KernelTransactions
extends LifecycleAdapter
implements TransactionRegistry,
Supplier<IdController.TransactionSnapshot>,
IdController.IdFreeCondition {
    public static final long SYSTEM_TRANSACTION_ID = 0L;
    private final LockManager lockManager;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final TransactionCommitProcess transactionCommitProcess;
    private final DatabaseTransactionEventListeners eventListeners;
    private final TransactionMonitor transactionMonitor;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final TransactionExecutionMonitor transactionExecutionMonitor;
    private final AvailabilityGuard databaseAvailabilityGuard;
    private final StorageEngine storageEngine;
    private final GlobalProcedures globalProcedures;
    private final DbmsRuntimeRepository dbmsRuntimeRepository;
    private final TransactionIdStore transactionIdStore;
    private final KernelVersionProvider kernelVersionProvider;
    private final ServerIdentity serverIdentity;
    private final LogicalTransactionStore transactionStore;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final SystemNanoClock clock;
    private final CursorContextFactory contextFactory;
    private final ReentrantReadWriteLock newTransactionsLock = new ReentrantReadWriteLock();
    private final TransactionIdSequence transactionIdSequence;
    private final TokenHolders tokenHolders;
    private final ElementIdMapper elementIdMapper;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final IdController.IdFreeCondition externalIdReuseCondition;
    private final TransactionCommitmentFactory commitmentFactory;
    private final TransactionIdGenerator transactionIdGenerator;
    private final DatabaseHealth databaseHealth;
    private final TransactionValidatorFactory transactionValidatorFactory;
    private final LogProvider internalLogProvider;
    private final NamedDatabaseId namedDatabaseId;
    private final IndexingService indexingService;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Dependencies databaseDependencies;
    private final Config config;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final SchemaState schemaState;
    private final LeaseService leaseService;
    private final Set<KernelTransactionImplementation> allTransactions = ConcurrentHashMap.newKeySet();
    private final MonitoredTransactionPool txPool;
    private final ConstraintSemantics constraintSemantics;
    private final AtomicInteger activeTransactionCounter = new AtomicInteger();
    private final TokenHoldersIdLookup tokenHoldersIdLookup;
    private final ApplyEnrichmentStrategy enrichmentStrategy;
    private final AbstractSecurityLog securityLog;
    private final boolean multiVersioned;
    private ScopedMemoryPool transactionMemoryPool;
    private volatile boolean stopped = true;

    public KernelTransactions(Config config, LockManager lockManager, ConstraintIndexCreator constraintIndexCreator, TransactionCommitProcess transactionCommitProcess, DatabaseTransactionEventListeners eventListeners, TransactionMonitor transactionMonitor, AvailabilityGuard databaseAvailabilityGuard, StorageEngine storageEngine, GlobalProcedures globalProcedures, DbmsRuntimeRepository dbmsRuntimeRepository, TransactionIdStore transactionIdStore, KernelVersionProvider kernelVersionProvider, ServerIdentity serverIdentity, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, AccessCapabilityFactory accessCapabilityFactory, CursorContextFactory contextFactory, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, ElementIdMapper elementIdMapper, NamedDatabaseId namedDatabaseId, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, DatabaseTracers tracers, LeaseService leaseService, GlobalMemoryGroupTracker transactionsMemoryPool, DatabaseReadOnlyChecker readOnlyDatabaseChecker, TransactionExecutionMonitor transactionExecutionMonitor, IdController.IdFreeCondition externalIdReuseCondition, TransactionCommitmentFactory commitmentFactory, TransactionIdSequence transactionIdSequence, TransactionIdGenerator transactionIdGenerator, DatabaseHealth databaseHealth, LogicalTransactionStore transactionStore, TransactionValidatorFactory transactionValidatorFactory, LogProvider internalLogProvider) {
        this.config = config;
        this.lockManager = lockManager;
        this.constraintIndexCreator = constraintIndexCreator;
        this.transactionCommitProcess = transactionCommitProcess;
        this.eventListeners = eventListeners;
        this.transactionMonitor = transactionMonitor;
        this.transactionsMemoryPool = transactionsMemoryPool;
        this.transactionExecutionMonitor = transactionExecutionMonitor;
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.storageEngine = storageEngine;
        this.globalProcedures = globalProcedures;
        this.dbmsRuntimeRepository = dbmsRuntimeRepository;
        this.transactionIdStore = transactionIdStore;
        this.kernelVersionProvider = kernelVersionProvider;
        this.serverIdentity = serverIdentity;
        this.cpuClockRef = cpuClockRef;
        this.accessCapabilityFactory = accessCapabilityFactory;
        this.tokenHolders = tokenHolders;
        this.elementIdMapper = elementIdMapper;
        this.readOnlyDatabaseChecker = readOnlyDatabaseChecker;
        this.externalIdReuseCondition = externalIdReuseCondition;
        this.commitmentFactory = commitmentFactory;
        this.transactionIdGenerator = transactionIdGenerator;
        this.databaseHealth = databaseHealth;
        this.transactionValidatorFactory = transactionValidatorFactory;
        this.internalLogProvider = internalLogProvider;
        this.tokenHoldersIdLookup = new TokenHoldersIdLookup(tokenHolders, globalProcedures);
        this.namedDatabaseId = namedDatabaseId;
        this.indexingService = indexingService;
        this.indexStatisticsStore = indexStatisticsStore;
        this.databaseDependencies = databaseDependencies;
        this.contextFactory = contextFactory;
        this.clock = clock;
        this.collectionsFactorySupplier = collectionsFactorySupplier;
        this.constraintSemantics = constraintSemantics;
        this.schemaState = schemaState;
        this.leaseService = leaseService;
        this.transactionIdSequence = transactionIdSequence;
        this.transactionStore = transactionStore;
        this.multiVersioned = storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED);
        this.txPool = new MonitoredTransactionPool(new GlobalKernelTransactionPool(this.allTransactions, new KernelTransactionImplementationFactory(this.allTransactions, tracers)), this.activeTransactionCounter, config);
        this.enrichmentStrategy = (ApplyEnrichmentStrategy)this.databaseDependencies.resolveDependency(ApplyEnrichmentStrategy.class);
        this.securityLog = (AbstractSecurityLog)this.databaseDependencies.resolveDependency(AbstractSecurityLog.class);
        this.doBlockNewTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelTransaction newInstance(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, TransactionTimeout timeout) {
        this.assertCurrentThreadIsNotBlockingNewTransactions();
        ProcedureView procedureView = this.globalProcedures.getCurrentView();
        SecurityContext securityContext = loginContext.authorize((LoginContext.IdLookup)this.tokenHoldersIdLookup, this.namedDatabaseId.name(), this.securityLog);
        while (!this.newTransactionsLock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
            this.assertRunning();
        }
        try {
            this.assertRunning();
            TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
            KernelTransactionImplementation tx = this.txPool.acquire();
            tx.initialize(lastCommittedTransaction.transactionId(), type, securityContext, timeout, this.transactionIdSequence.next(), clientInfo, procedureView);
            KernelTransactionImplementation kernelTransactionImplementation = tx;
            this.newTransactionsLock.readLock().unlock();
            return kernelTransactionImplementation;
        }
        catch (Throwable throwable) {
            try {
                this.newTransactionsLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new TransactionFailureException("Fail to start new transaction.", (Throwable)ie);
            }
        }
    }

    @Override
    public Set<KernelTransactionHandle> activeTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(KernelTransactionHandle::isOpen).collect(Collectors.toSet());
    }

    public long oldestVisibleTransactionNumber() {
        long oldestVisibleTransactionNumber = Long.MAX_VALUE;
        for (KernelTransactionImplementation transaction : this.allTransactions) {
            if (!transaction.isOpen() || transaction.isTerminated()) continue;
            oldestVisibleTransactionNumber = Math.min(oldestVisibleTransactionNumber, transaction.cursorContext().getVersionContext().lastClosedTransactionId());
        }
        return oldestVisibleTransactionNumber;
    }

    public long oldestObservableHorizon() {
        long oldestHorizon = Long.MAX_VALUE;
        for (KernelTransactionImplementation transaction : this.allTransactions) {
            if (!transaction.isOpen() || transaction.isTerminated()) continue;
            oldestHorizon = Math.min(oldestHorizon, this.transactionHorizon(transaction.cursorContext().getVersionContext()));
        }
        return oldestHorizon;
    }

    private long transactionHorizon(VersionContext versionContext) {
        long oldestVisibleTransactionNumber = versionContext.oldestVisibleTransactionNumber();
        if (oldestVisibleTransactionNumber != 1L) {
            return oldestVisibleTransactionNumber;
        }
        return versionContext.lastClosedTransactionId();
    }

    public long oldestActiveTransactionSequenceNumber() {
        long oldestTransactionSequenceNumber = Long.MAX_VALUE;
        for (KernelTransactionImplementation transaction : this.allTransactions) {
            if (!transaction.isOpen() || transaction.isTerminated()) continue;
            oldestTransactionSequenceNumber = Math.min(oldestTransactionSequenceNumber, transaction.getTransactionSequenceNumber());
        }
        return oldestTransactionSequenceNumber;
    }

    public long startTimeOfOldestActiveTransaction() {
        long startTime = Long.MAX_VALUE;
        for (KernelTransactionImplementation transaction : this.allTransactions) {
            if (!transaction.isOpen() || transaction.isTerminated()) continue;
            startTime = Math.min(startTime, transaction.startTime());
        }
        return startTime;
    }

    @Override
    public Set<KernelTransactionHandle> executingTransactions() {
        return this.allTransactions.stream().map(this::createHandle).filter(h -> h.isOpen() || h.isClosing()).collect(Collectors.toSet());
    }

    public void disposeAll() {
        this.terminateTransactions();
        this.txPool.close();
    }

    @Override
    public void terminateTransactions() {
        this.markAllTransactionsAsTerminated();
    }

    private void markAllTransactionsAsTerminated() {
        this.allTransactions.forEach(tx -> tx.markForTermination((Status)Status.General.DatabaseUnavailable));
    }

    @Override
    public boolean haveClosingTransaction() {
        return this.allTransactions.stream().anyMatch(KernelTransactionImplementation::isClosing);
    }

    public void init() throws Exception {
        this.transactionMemoryPool = this.transactionsMemoryPool.newDatabasePool(this.namedDatabaseId.name(), ((Long)this.config.get(GraphDatabaseSettings.memory_transaction_database_max_size)).longValue(), GraphDatabaseSettings.memory_transaction_database_max_size.name());
        this.config.addListener(GraphDatabaseSettings.memory_transaction_database_max_size, (before, after) -> this.transactionMemoryPool.setSize(after.longValue()));
    }

    public void start() {
        this.stopped = false;
        this.unblockNewTransactions();
    }

    public void stop() {
        this.blockNewTransactions();
        this.stopped = true;
    }

    public void shutdown() {
        this.transactionMemoryPool.close();
        this.disposeAll();
        this.unblockNewTransactions();
    }

    @Override
    public IdController.TransactionSnapshot get() {
        return new IdController.TransactionSnapshot(this.transactionIdSequence.currentValue(), this.clock.millis(), this.transactionIdStore.getLastCommittedTransactionId(), this.transactionIdStore.getClosedTransactionSnapshot());
    }

    public boolean eligibleForFreeing(IdController.TransactionSnapshot snapshot) {
        return this.externalIdReuseCondition.eligibleForFreeing(snapshot) && snapshot.currentSequenceNumber() < this.oldestActiveTransactionSequenceNumber();
    }

    public void blockNewTransactions() {
        this.doBlockNewTransactions();
    }

    private void doBlockNewTransactions() {
        this.newTransactionsLock.writeLock().lock();
    }

    public void unblockNewTransactions() {
        if (!this.newTransactionsLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("This thread did not block transactions previously");
        }
        this.newTransactionsLock.writeLock().unlock();
    }

    public int getNumberOfActiveTransactions() {
        return this.activeTransactionCounter.get();
    }

    KernelTransactionHandle createHandle(KernelTransactionImplementation tx) {
        return new KernelTransactionImplementationHandle(tx, this.clock);
    }

    private void assertRunning() {
        if (this.databaseAvailabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        if (this.stopped) {
            throw new IllegalStateException("Can't start new transaction with stopped " + this.getClass());
        }
    }

    private void assertCurrentThreadIsNotBlockingNewTransactions() {
        if (this.newTransactionsLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Thread that is blocking new transactions from starting can't start new transaction");
        }
    }

    static class MonitoredTransactionPool
    implements Pool<KernelTransactionImplementation> {
        private final AtomicInteger activeTransactionCounter;
        private final GlobalKernelTransactionPool delegate;
        private volatile int maxNumberOfTransaction;

        MonitoredTransactionPool(GlobalKernelTransactionPool delegate, AtomicInteger activeTransactionCounter, Config config) {
            this.delegate = delegate;
            this.activeTransactionCounter = activeTransactionCounter;
            this.maxNumberOfTransaction = (Integer)config.get(GraphDatabaseSettings.max_concurrent_transactions);
            config.addListener(GraphDatabaseSettings.max_concurrent_transactions, (oldValue, newValue) -> {
                this.maxNumberOfTransaction = newValue;
            });
        }

        public KernelTransactionImplementation acquire() {
            this.verifyTransactionsLimit();
            return (KernelTransactionImplementation)this.delegate.acquire();
        }

        public void release(KernelTransactionImplementation txn) {
            this.activeTransactionCounter.decrementAndGet();
            this.delegate.release(txn);
        }

        public void dispose(KernelTransactionImplementation txn) {
            this.activeTransactionCounter.decrementAndGet();
            this.delegate.dispose(txn);
        }

        public void close() {
            this.delegate.close();
        }

        private void verifyTransactionsLimit() {
            int activeTransactions;
            do {
                activeTransactions = this.activeTransactionCounter.get();
                int localTransactionMaximum = this.maxNumberOfTransaction;
                if (localTransactionMaximum == 0 || activeTransactions < localTransactionMaximum) continue;
                throw new MaximumTransactionLimitExceededException();
            } while (!this.activeTransactionCounter.weakCompareAndSetAcquire(activeTransactions, activeTransactions + 1));
        }
    }

    private static class GlobalKernelTransactionPool
    extends LinkedQueuePool<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;

        GlobalKernelTransactionPool(Set<KernelTransactionImplementation> transactions, Factory<KernelTransactionImplementation> factory) {
            super(8, factory);
            this.transactions = transactions;
        }

        public void dispose(KernelTransactionImplementation tx) {
            this.transactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    }

    private class KernelTransactionImplementationFactory
    implements Factory<KernelTransactionImplementation> {
        private final Set<KernelTransactionImplementation> transactions;
        private final DatabaseTracers tracers;

        KernelTransactionImplementationFactory(Set<KernelTransactionImplementation> transactions, DatabaseTracers tracers) {
            this.transactions = transactions;
            this.tracers = tracers;
        }

        public KernelTransactionImplementation newInstance() {
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.config, KernelTransactions.this.eventListeners, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, KernelTransactions.this.txPool, KernelTransactions.this.clock, KernelTransactions.this.cpuClockRef, this.tracers, KernelTransactions.this.storageEngine, KernelTransactions.this.accessCapabilityFactory, KernelTransactions.this.contextFactory, KernelTransactions.this.collectionsFactorySupplier, KernelTransactions.this.constraintSemantics, KernelTransactions.this.schemaState, KernelTransactions.this.tokenHolders, KernelTransactions.this.elementIdMapper, KernelTransactions.this.indexingService, KernelTransactions.this.indexStatisticsStore, KernelTransactions.this.databaseDependencies, KernelTransactions.this.namedDatabaseId, KernelTransactions.this.leaseService, KernelTransactions.this.transactionMemoryPool, KernelTransactions.this.readOnlyDatabaseChecker, KernelTransactions.this.transactionExecutionMonitor, KernelTransactions.this.securityLog, KernelTransactions.this.lockManager, KernelTransactions.this.commitmentFactory, KernelTransactions.this, KernelTransactions.this.transactionIdGenerator, KernelTransactions.this.dbmsRuntimeRepository, KernelTransactions.this.kernelVersionProvider, KernelTransactions.this.transactionStore, KernelTransactions.this.serverIdentity, KernelTransactions.this.enrichmentStrategy, KernelTransactions.this.databaseHealth, KernelTransactions.this.internalLogProvider, KernelTransactions.this.transactionValidatorFactory, KernelTransactions.this.multiVersioned);
            this.transactions.add(tx);
            return tx;
        }
    }
}

