/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.LongObjectMaps;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.values.storable.Values;

public class DatabaseComparator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertDatabasesHaveTheSameLogicalContents(GraphDatabaseService from, GraphDatabaseService to, boolean checkDegrees, int totalNumThreads, ProgressMonitorFactory progressMonitorFactory) throws Exception {
        int numThreads = Math.max(1, totalNumThreads - 1);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(100), DatabaseComparator.dontPrintOnExceptionThreadFactory());
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        int batchSize = 1000;
        ArrayList futures = new ArrayList();
        try (Transaction fromTx = from.beginTx();
             ProgressListener progress = progressMonitorFactory.singlePart("Validation", ((TransactionImpl)fromTx).kernelTransaction().dataRead().nodesGetCount());){
            MutableLongList batch = LongLists.mutable.withInitialCapacity(batchSize);
            for (Node node : fromTx.getAllNodes()) {
                batch.add(node.getId());
                if (batch.size() != batchSize) continue;
                DatabaseComparator.scheduleAndCheckFailure(futures, executor.submit(DatabaseComparator.storeValidator(from, to, batch, checkDegrees)));
                batch = LongLists.mutable.withInitialCapacity(batchSize);
                progress.add((long)batchSize);
            }
            if (!batch.isEmpty()) {
                futures.add(executor.submit(DatabaseComparator.storeValidator(from, to, batch, checkDegrees)));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
            if (!executor.awaitTermination(1L, TimeUnit.HOURS)) {
                throw new IllegalStateException("Comparison jobs didn't finish in time");
            }
        }
    }

    private static ThreadFactory dontPrintOnExceptionThreadFactory() {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setUncaughtExceptionHandler(Exceptions.SILENT_UNCAUGHT_EXCEPTION_HANDLER);
            return thread;
        };
    }

    private static void scheduleAndCheckFailure(List<Future<?>> futures, Future<?> future) throws Exception {
        Future<?> candidate;
        futures.add(future);
        Iterator<Future<?>> iterator = futures.iterator();
        while (iterator.hasNext() && ((candidate = iterator.next()).isDone() || candidate.isCancelled())) {
            iterator.remove();
            candidate.get();
        }
    }

    private static Runnable storeValidator(GraphDatabaseService from, GraphDatabaseService to, MutableLongList batch, boolean checkDegrees) {
        return () -> {
            try (Transaction fromTx = from.beginTx();
                 Transaction toTx = to.beginTx();){
                MutableLongIterator ids = batch.longIterator();
                while (ids.hasNext()) {
                    Node toNode;
                    long fromNodeId;
                    long toNodeId = fromNodeId = ids.next();
                    Node fromNode = fromTx.getNodeById(fromNodeId);
                    ComparisonReport report = DatabaseComparator.compareNodes(fromNode, toNode = toTx.getNodeById(toNodeId), checkDegrees);
                    if (!report.hasErrors()) continue;
                    String errorString = String.format("%s listing contents:%nfrom:%n%s%nto:%n%s", report.report(), DatabaseComparator.contentsOfNode(fromNode), DatabaseComparator.contentsOfNode(toNode));
                    throw new RuntimeException(errorString);
                }
            }
        };
    }

    public static boolean nodesHaveEqualLogicalContents(Node fromNode, Node toNode) {
        return !DatabaseComparator.compareNodes(fromNode, toNode, true).hasErrors();
    }

    private static ComparisonReport compareNodes(Node fromNode, Node toNode, boolean checkRelationships) {
        ComparisonReport report = new ComparisonReport(fromNode, toNode);
        HashSet fromLabels = new HashSet();
        HashSet toLabels = new HashSet();
        fromNode.getLabels().forEach(l -> fromLabels.add(l.name()));
        toNode.getLabels().forEach(l -> toLabels.add(l.name()));
        if (!fromLabels.equals(toLabels)) {
            report.add("Broken labels %s should be %s diff:", toLabels, fromLabels, DatabaseComparator.setDiff(fromLabels, toLabels));
        }
        HashMap fromProps = new HashMap();
        HashMap toProps = new HashMap();
        fromNode.getAllProperties().forEach((s, o) -> fromProps.put(s, Values.of((Object)o)));
        toNode.getAllProperties().forEach((s, o) -> toProps.put(s, Values.of((Object)o)));
        if (!fromProps.equals(toProps)) {
            report.add("Broken properties %s should be %s diff:%s", toProps, fromProps, DatabaseComparator.mapDiff(fromProps, toProps));
        }
        if (checkRelationships) {
            long toDegree;
            long fromDegree = fromNode.getDegree();
            if (fromDegree != (toDegree = (long)toNode.getDegree())) {
                long fromDegreeByManuallyCounting = DatabaseComparator.degreeByManuallyCounting(fromNode);
                if (fromDegreeByManuallyCounting != fromDegree) {
                    fromDegree = fromDegreeByManuallyCounting;
                }
                if (fromDegree != toDegree) {
                    report.add("Broken relationships (degrees) %s should be %d diff:%s", toNode.getDegree(), fromNode.getDegree(), DatabaseComparator.degreesDiff(fromNode, toNode));
                }
            }
            HashSet fromRelationshipTypes = new HashSet();
            HashSet toRelationshipTypes = new HashSet();
            fromNode.getRelationshipTypes().forEach(t -> fromRelationshipTypes.add(t.name()));
            toNode.getRelationshipTypes().forEach(t -> toRelationshipTypes.add(t.name()));
            if (!fromRelationshipTypes.equals(toRelationshipTypes)) {
                report.add("Broken relationship types %s should be %s", fromRelationshipTypes, toRelationshipTypes);
            }
            for (String relationshipType : fromRelationshipTypes) {
                RelationshipType type = RelationshipType.withName((String)relationshipType);
                DatabaseComparator.compareRelationships(fromNode, toNode, Direction.OUTGOING, type, report);
                DatabaseComparator.compareRelationships(fromNode, toNode, Direction.INCOMING, type, report);
                DatabaseComparator.compareRelationships(fromNode, toNode, Direction.BOTH, type, report);
            }
        }
        return report;
    }

    private static long degreeByManuallyCounting(Node node) {
        return Iterables.count((Iterable)node.getRelationships());
    }

    private static void compareRelationships(Node fromNode, Node toNode, Direction direction, RelationshipType type, ComparisonReport report) {
        int toCount;
        MutableLongObjectMap fromOtherNodes = LongObjectMaps.mutable.empty();
        MutableLongObjectMap toOtherNodes = LongObjectMaps.mutable.empty();
        int fromCount = DatabaseComparator.countRelationships(fromNode, direction, type, (MutableLongObjectMap<MutableInt>)fromOtherNodes);
        if (fromCount != (toCount = DatabaseComparator.countRelationships(toNode, direction, type, (MutableLongObjectMap<MutableInt>)toOtherNodes))) {
            report.add("Broken relationship count %s, %s %d should be %d", direction, type.name(), toCount, fromCount);
        }
        fromOtherNodes.forEachKeyValue((LongObjectProcedure & Serializable)(otherFromNodeId, fromOtherNodeCount) -> {
            long otherToNodeId = otherFromNodeId;
            MutableInt toOtherNodeCount = (MutableInt)toOtherNodes.get(otherToNodeId);
            if (toOtherNodeCount == null || fromOtherNodeCount.intValue() != toOtherNodeCount.intValue()) {
                report.add("Broken number of relationships for %s, %s should be %s", DatabaseComparator.relationshipDataToString(fromNode.getId(), toNode.getId(), direction, type.name(), otherFromNodeId, otherToNodeId), toOtherNodeCount, fromOtherNodeCount);
            }
        });
    }

    private static String relationshipDataToString(long fromNodeId, long toNodeId, Direction direction, String type, long otherFromNodeId, long otherToNodeId) {
        return String.format("(%d/%d)%s[%s]%s(%d/%d)", fromNodeId, toNodeId, direction == Direction.INCOMING ? "<-" : "--", type, direction == Direction.INCOMING ? "--" : "->", otherFromNodeId, otherToNodeId);
    }

    private static int countRelationships(Node node, Direction direction, RelationshipType type, MutableLongObjectMap<MutableInt> otherNodes) {
        int count = 0;
        try (ResourceIterable relationships = node.getRelationships(direction, new RelationshipType[]{type});){
            for (Relationship relationship : relationships) {
                ((MutableInt)otherNodes.getIfAbsentPut(relationship.getOtherNodeId(node.getId()), MutableInt::new)).increment();
                ++count;
            }
        }
        return count;
    }

    private static String contentsOfNode(Node node) {
        StringBuilder builder = new StringBuilder();
        builder.append("Labels:");
        node.getLabels().forEach(label -> builder.append(String.format("%n  ", new Object[0])).append(label.name()));
        builder.append(String.format("%nProperties:", new Object[0]));
        node.getAllProperties().forEach((key, value) -> builder.append(String.format("%n  %s=%s", key, value)));
        builder.append(String.format("%nRelationships:", new Object[0]));
        TreeSet<RelationshipType> types = new TreeSet<RelationshipType>(Comparator.comparing(RelationshipType::name));
        node.getRelationshipTypes().forEach(types::add);
        for (RelationshipType type : types) {
            node.getRelationships(Direction.BOTH, new RelationshipType[]{type}).forEach(rel -> builder.append(String.format("%n  %s", rel)));
        }
        return builder.append(String.format("%n", new Object[0])).toString();
    }

    private static String degreesDiff(Node fromNode, Node toNode) {
        HashSet fromTypes = new HashSet();
        HashSet toTypes = new HashSet();
        fromNode.getRelationshipTypes().forEach(type -> fromTypes.add(type.name()));
        toNode.getRelationshipTypes().forEach(type -> toTypes.add(type.name()));
        if (!fromTypes.equals(toTypes)) {
            return "Relationship types differ: " + DatabaseComparator.setDiff(fromTypes, toTypes);
        }
        StringBuilder builder = new StringBuilder();
        for (String typeName : fromTypes) {
            RelationshipType type2 = RelationshipType.withName((String)typeName);
            DatabaseComparator.checkDegreeDiff(fromNode, toNode, builder, type2, Direction.OUTGOING);
            DatabaseComparator.checkDegreeDiff(fromNode, toNode, builder, type2, Direction.INCOMING);
            DatabaseComparator.checkDegreeDiff(fromNode, toNode, builder, type2, Direction.BOTH);
        }
        return builder.toString();
    }

    private static void checkDegreeDiff(Node fromNode, Node toNode, StringBuilder builder, RelationshipType type, Direction direction) {
        int to;
        int from = fromNode.getDegree(type, direction);
        if (from != (to = toNode.getDegree(type, direction))) {
            builder.append(String.format("degree:%s,%s:%d vs %d", type.name(), direction.name(), from, to));
        }
    }

    private static <T> String setDiff(Set<T> from, Set<T> to) {
        StringBuilder builder = new StringBuilder();
        HashSet<Object> combined = new HashSet<Object>(from);
        combined.removeAll(to);
        combined.forEach(label -> builder.append(String.format("%n<%s", label)));
        combined = new HashSet<T>(to);
        combined.removeAll(from);
        combined.forEach(label -> builder.append(String.format("%n>%s", label)));
        return builder.toString();
    }

    private static <T> String mapDiff(Map<String, T> from, Map<String, T> to) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> allKeys = new HashSet<String>(from.keySet());
        allKeys.addAll(to.keySet());
        for (String key : allKeys) {
            T fromValue = from.get(key);
            T toValue = to.get(key);
            if (toValue == null) {
                builder.append(String.format("%n<%s=%s", key, fromValue));
                continue;
            }
            if (fromValue == null) {
                builder.append(String.format("%n>%s=%s", key, toValue));
                continue;
            }
            if (fromValue.equals(toValue)) continue;
            builder.append(String.format("%n!%s=%s vs %s", key, fromValue, toValue));
        }
        return builder.toString();
    }

    private static class ComparisonReport {
        private final Node fromNode;
        private final Node toNode;
        private StringBuilder builder;

        ComparisonReport(Node fromNode, Node toNode) {
            this.fromNode = fromNode;
            this.toNode = toNode;
        }

        void add(String format, Object ... parameters) {
            this.builder().append(String.format("%n  " + format, parameters));
        }

        private StringBuilder builder() {
            if (this.builder == null) {
                this.builder = new StringBuilder(String.format("Validation failed for %s --> %s", this.fromNode, this.toNode));
            }
            return this.builder;
        }

        boolean hasErrors() {
            return this.builder != null;
        }

        String report() {
            return this.builder.toString();
        }
    }
}

