/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class LogTailExtractor {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final Config config;
    private final StorageEngineFactory storageEngineFactory;
    private final DatabaseTracers databaseTracers;

    public LogTailExtractor(FileSystemAbstraction fs, PageCache pageCache, Config config, StorageEngineFactory storageEngineFactory, DatabaseTracers databaseTracers) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.config = config;
        this.storageEngineFactory = storageEngineFactory;
        this.databaseTracers = databaseTracers;
    }

    public LogTailMetadata getTailMetadata(DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        return this.buildLogFiles(databaseLayout, memoryTracker, KernelVersionProvider.THROWING_PROVIDER).getTailMetadata();
    }

    public LogTailMetadata getTailMetadata(DatabaseLayout databaseLayout, MemoryTracker memoryTracker, KernelVersionProvider emptyLogsFallbackKernelVersionProvider) throws IOException {
        return this.buildLogFiles(databaseLayout, memoryTracker, emptyLogsFallbackKernelVersionProvider).getTailMetadata();
    }

    private LogFiles buildLogFiles(DatabaseLayout databaseLayout, MemoryTracker memoryTracker, KernelVersionProvider kernelVersionProvider) throws IOException {
        return LogFilesBuilder.activeFilesBuilder(databaseLayout, this.fs, this.pageCache, kernelVersionProvider).withConfig(this.config).withMemoryTracker(memoryTracker).withDatabaseTracers(this.databaseTracers).withStorageEngineFactory(this.storageEngineFactory).build();
    }
}

