/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.tracer.CountingLogCheckPointEvent;
import org.neo4j.kernel.impl.api.tracer.CountingLogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.tracing.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogFileCreateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogFileFlushEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.RollbackBatchEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;

public class DefaultTracer
implements DatabaseTracer {
    private final LongAdder appendedBytes = new LongAdder();
    private final LongAdder numberOfFlushes = new LongAdder();
    private final LongAdder batchesAppended = new LongAdder();
    private final LongAdder batchesRolledBack = new LongAdder();
    private final LongAdder batchTransactionsRolledBack = new LongAdder();
    private final AtomicLong appliedBatchSize = new AtomicLong();
    private final CountingLogRotateEvent countingLogRotateEvent = new CountingLogRotateEvent();
    private final LogFileCreateEvent logFileCreateEvent = () -> this.appendedBytes.add(LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE);
    private final LogFileFlushEvent logFileFlushEvent = this.numberOfFlushes::increment;
    private final LogAppendEvent logAppendEvent = new DefaultLogAppendEvent();
    private final TransactionWriteEvent transactionWriteEvent = new DefaultTransactionWriteEvent();
    private final TransactionRollbackEvent transactionRollbackEvent = new DefaultTransactionRollbackEvent();
    private final TransactionEvent transactionEvent = new DefaultTransactionEvent();
    private final CountingLogCheckPointEvent logCheckPointEvent;

    public DefaultTracer(PageCacheTracer pageCacheTracer) {
        this.logCheckPointEvent = new CountingLogCheckPointEvent(pageCacheTracer, this::appendLogBytes, this.countingLogRotateEvent);
    }

    @Override
    public TransactionEvent beginTransaction(CursorContext cursorContext) {
        return this.transactionEvent;
    }

    @Override
    public long appendedBytes() {
        return this.appendedBytes.longValue();
    }

    @Override
    public long numberOfLogRotations() {
        return this.countingLogRotateEvent.numberOfLogRotations();
    }

    @Override
    public long logRotationAccumulatedTotalTimeMillis() {
        return this.countingLogRotateEvent.logRotationAccumulatedTotalTimeMillis();
    }

    @Override
    public long lastLogRotationTimeMillis() {
        return this.countingLogRotateEvent.lastLogRotationTimeMillis();
    }

    @Override
    public long numberOfFlushes() {
        return this.numberOfFlushes.longValue();
    }

    @Override
    public long lastTransactionLogAppendBatch() {
        return this.appliedBatchSize.longValue();
    }

    @Override
    public long batchesAppended() {
        return this.batchesAppended.longValue();
    }

    @Override
    public long rolledbackBatches() {
        return this.batchesRolledBack.longValue();
    }

    @Override
    public long rolledbackBatchedTransactions() {
        return this.batchTransactionsRolledBack.longValue();
    }

    @Override
    public long numberOfCheckPoints() {
        return this.logCheckPointEvent.numberOfCheckPoints();
    }

    @Override
    public long checkPointAccumulatedTotalTimeMillis() {
        return this.logCheckPointEvent.checkPointAccumulatedTotalTimeMillis();
    }

    @Override
    public long lastCheckpointTimeMillis() {
        return this.logCheckPointEvent.lastCheckpointTimeMillis();
    }

    @Override
    public long lastCheckpointPagesFlushed() {
        return this.logCheckPointEvent.getPagesFlushed();
    }

    @Override
    public long lastCheckpointIOs() {
        return this.logCheckPointEvent.getIOsPerformed();
    }

    @Override
    public long lastCheckpointIOLimit() {
        return this.logCheckPointEvent.getConfiguredIOLimit();
    }

    @Override
    public long lastCheckpointIOLimitedTimes() {
        return this.logCheckPointEvent.getTimesPaused();
    }

    @Override
    public long lastCheckpointIOLimitedMillis() {
        return this.logCheckPointEvent.getMillisPaused();
    }

    @Override
    public long flushedBytes() {
        return this.logCheckPointEvent.flushedBytes();
    }

    @Override
    public LogCheckPointEvent beginCheckPoint() {
        return this.logCheckPointEvent;
    }

    private void appendLogBytes(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
        if (logPositionAfterAppend.getLogVersion() != logPositionBeforeAppend.getLogVersion()) {
            throw new IllegalStateException("Appending to several log files is not supported.");
        }
        this.appendedBytes.add(logPositionAfterAppend.getByteOffset() - logPositionBeforeAppend.getByteOffset());
    }

    @Override
    public LogFileCreateEvent createLogFile() {
        return this.logFileCreateEvent;
    }

    @Override
    public void openLogFile(Path filePath) {
    }

    @Override
    public void closeLogFile(Path filePath) {
    }

    @Override
    public LogAppendEvent logAppend() {
        return this.logAppendEvent;
    }

    @Override
    public LogFileFlushEvent flushFile() {
        return this.logFileFlushEvent;
    }

    private class DefaultLogAppendEvent
    implements LogAppendEvent {
        private DefaultLogAppendEvent() {
        }

        @Override
        public void appendToLogFile(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
            DefaultTracer.this.appendLogBytes(logPositionBeforeAppend, logPositionAfterAppend);
        }

        @Override
        public void close() {
        }

        @Override
        public void setLogRotated(boolean logRotated) {
        }

        @Override
        public LogRotateEvent beginLogRotate() {
            return DefaultTracer.this.countingLogRotateEvent;
        }

        @Override
        public AppendTransactionEvent beginAppendTransaction(int appendItems) {
            DefaultTracer.this.appliedBatchSize.set(appendItems);
            return AppendTransactionEvent.NULL;
        }

        @Override
        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        @Override
        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    }

    private class DefaultTransactionWriteEvent
    implements TransactionWriteEvent {
        private DefaultTransactionWriteEvent() {
        }

        @Override
        public void close() {
        }

        @Override
        public LogAppendEvent beginLogAppend() {
            return DefaultTracer.this.logAppendEvent;
        }

        @Override
        public StoreApplyEvent beginStoreApply() {
            return StoreApplyEvent.NULL;
        }

        @Override
        public void chunkAppended(int chunkNumber, long transactionSequenceNumber, long transactionId) {
            DefaultTracer.this.batchesAppended.increment();
        }
    }

    private class DefaultTransactionRollbackEvent
    implements TransactionRollbackEvent {
        private DefaultTransactionRollbackEvent() {
        }

        @Override
        public RollbackBatchEvent beginRollbackDataEvent() {
            return new RollbackBatchEvent(){

                @Override
                public void close() {
                    DefaultTracer.this.batchTransactionsRolledBack.increment();
                }

                @Override
                public void batchedRolledBack(int rolledBackBatches, long transactionId) {
                    DefaultTracer.this.batchesRolledBack.add(rolledBackBatches);
                }
            };
        }

        @Override
        public TransactionWriteEvent beginRollbackWriteEvent() {
            return DefaultTracer.this.transactionWriteEvent;
        }

        @Override
        public void close() {
        }
    }

    private class DefaultTransactionEvent
    implements TransactionEvent {
        private DefaultTransactionEvent() {
        }

        @Override
        public void setCommit(boolean commit) {
        }

        @Override
        public void setRollback(boolean rollback) {
        }

        @Override
        public TransactionWriteEvent beginCommitEvent() {
            return DefaultTracer.this.transactionWriteEvent;
        }

        @Override
        public TransactionWriteEvent beginChunkWriteEvent() {
            return DefaultTracer.this.transactionWriteEvent;
        }

        @Override
        public TransactionRollbackEvent beginRollback() {
            return DefaultTracer.this.transactionRollbackEvent;
        }

        @Override
        public void close() {
        }

        @Override
        public void setTransactionWriteState(String transactionWriteState) {
        }

        @Override
        public void setReadOnly(boolean wasReadOnly) {
        }
    }
}

