/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.util.Preconditions;

abstract class PartitionedEntityCursorScan<C extends Cursor, S>
implements PartitionedScan<C> {
    final S storageScan;
    final Read fallbackRead;
    private final int numberOfPartitions;
    private final long batchSize;
    private final AtomicInteger emittedPartitions;

    PartitionedEntityCursorScan(S storageScan, Read read, int desiredNumberOfPartitions, long totalCount) {
        Preconditions.requirePositive((int)desiredNumberOfPartitions);
        this.storageScan = storageScan;
        this.fallbackRead = read;
        this.numberOfPartitions = (long)desiredNumberOfPartitions < totalCount ? desiredNumberOfPartitions : Math.max((int)totalCount, 1);
        this.batchSize = MathUtil.ceil((long)totalCount, (long)this.numberOfPartitions);
        this.emittedPartitions = new AtomicInteger(0);
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    long computeBatchSize() {
        return this.emittedPartitions.getAndIncrement() == this.numberOfPartitions - 1 ? Long.MAX_VALUE : this.batchSize;
    }
}

