/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;

public class RangeIndexProviderFactory
extends AbstractIndexProviderFactory<RangeIndexProvider> {
    @Override
    protected Class<?> loggingClass() {
        return RangeIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return RangeIndexProvider.DESCRIPTOR;
    }

    @Override
    protected RangeIndexProvider internalCreate(PageCache pageCache, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, InternalLog log, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver) {
        return RangeIndexProviderFactory.create(pageCache, databaseLayout.databaseDirectory(), fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, contextFactory, pageCacheTracer, databaseLayout.getDatabaseName(), dependencyResolver);
    }

    @VisibleForTesting
    public static RangeIndexProvider create(PageCache pageCache, Path storeDir, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, String databaseName, DependencyResolver dependencyResolver) {
        IndexDirectoryStructure.Factory directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)storeDir);
        DatabaseIndexContext databaseIndexContext = DatabaseIndexContext.builder(pageCache, fs, contextFactory, pageCacheTracer, databaseName).withMonitors(monitors).withTag(monitorTag).withReadOnlyChecker(readOnlyChecker).withDependencyResolver(dependencyResolver).build();
        return new RangeIndexProvider(databaseIndexContext, directoryStructure, recoveryCleanupWorkCollector, config);
    }
}

