/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final StorageReader storageReader;
    private final Read read;
    private final IndexingService indexingService;

    public IndexTxStateUpdater(StorageReader storageReader, Read read, IndexingService indexingService) {
        this.storageReader = storageReader;
        this.read = read;
        this.indexingService = indexingService;
    }

    void onLabelChange(NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType, Collection<IndexDescriptor> indexes) {
        assert (this.noSchemaChangedInTx());
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            for (IndexDescriptor index : indexes) {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                int[] indexPropertyIds = index.schema().getPropertyIds();
                Value[] values = IndexTxStateUpdater.getValueTuple((EntityCursor)node, propertyCursor, -1, Values.NO_VALUE, indexPropertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                switch (changeType) {
                    case ADDED_LABEL: {
                        this.indexingService.validateBeforeCommit(index, values, node.nodeReference());
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, valueTuple);
                        break;
                    }
                    case REMOVED_LABEL: {
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), valueTuple, null);
                    }
                }
            }
        }
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, int[] labels, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange((EntityCursor)node, EntityType.NODE, propertyCursor, labels, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onPropertyAdd(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyAdd((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyRemove(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        this.onPropertyRemove((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, value);
    }

    void onPropertyChange(RelationshipScanCursor relationship, PropertyCursor propertyCursor, int type, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        this.onPropertyChange((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{type}, propertyKeyId, existingPropertyKeyIds, beforeValue, afterValue);
    }

    void onDeleteUncreated(NodeCursor node, PropertyCursor propertyCursor) {
        this.onDeleteUncreated((EntityCursor)node, EntityType.NODE, propertyCursor, node.labels().all());
    }

    void onDeleteUncreated(RelationshipScanCursor relationship, PropertyCursor propertyCursor) {
        this.onDeleteUncreated((EntityCursor)relationship, EntityType.RELATIONSHIP, propertyCursor, new int[]{relationship.type()});
    }

    private boolean noSchemaChangedInTx() {
        return !this.read.txState().hasChanges() || this.read.txState().hasDataChanges();
    }

    private void onDeleteUncreated(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens) {
        assert (this.noSchemaChangedInTx());
        entity.properties(propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        MutableIntList propertyKeyList = IntLists.mutable.empty();
        while (propertyCursor.next()) {
            propertyKeyList.add(propertyCursor.propertyKey());
        }
        int[] propertyKeyIds = propertyKeyList.toSortedArray();
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyIds, entityType);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), -1, propertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, -1, Values.NO_VALUE, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valueTuple, null);
            });
        }
    }

    private void onPropertyAdd(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, values, entity.reference());
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), null, valueTuple);
            });
        }
    }

    private void onPropertyRemove(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value value) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                Value[] values = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, value, schema.getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                ValueTuple valueTuple = ValueTuple.of((Value[])values);
                memoryTracker.allocateHeap(valueTuple.getShallowSize());
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valueTuple, null);
            });
        }
    }

    private void onPropertyChange(EntityCursor entity, EntityType entityType, PropertyCursor propertyCursor, int[] tokens, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Collection indexes = this.storageReader.valueIndexesGetRelated(tokens, propertyKeyId, entityType);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            SchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                MemoryTracker memoryTracker = this.read.txState().memoryTracker();
                SchemaDescriptor schema = index.schema();
                int[] propertyIds = schema.getPropertyIds();
                Value[] valuesAfter = IndexTxStateUpdater.getValueTuple(entity, propertyCursor, propertyKeyId, afterValue, propertyIds, (MutableIntObjectMap<Value>)materializedProperties, memoryTracker);
                Value[] valuesBefore = Arrays.copyOf(valuesAfter, valuesAfter.length);
                int k = ArrayUtils.indexOf((int[])propertyIds, (int)propertyKeyId);
                valuesBefore[k] = beforeValue;
                this.indexingService.validateBeforeCommit((IndexDescriptor)index, valuesAfter, entity.reference());
                ValueTuple valuesTupleBefore = ValueTuple.of((Value[])valuesBefore);
                ValueTuple valuesTupleAfter = ValueTuple.of((Value[])valuesAfter);
                memoryTracker.allocateHeap(valuesTupleBefore.getShallowSize() * 2L);
                this.read.txState().indexDoUpdateEntry(schema, entity.reference(), valuesTupleBefore, valuesTupleAfter);
            });
        }
    }

    private static Value[] getValueTuple(EntityCursor entity, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds, MutableIntObjectMap<Value> materializedValues, MemoryTracker memoryTracker) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        int missing = 0;
        for (k = 0; k < indexPropertyIds.length; ++k) {
            Value value = values[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : (Value)materializedValues.getIfAbsent(indexPropertyIds[k], (Function0 & Serializable)() -> Values.NO_VALUE);
            if (values[k] != Values.NO_VALUE) continue;
            ++missing;
        }
        if (missing > 0) {
            entity.properties(propertyCursor, PropertySelection.selection((int[])indexPropertyIds));
            while (missing > 0 && propertyCursor.next()) {
                k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)propertyCursor.propertyKey());
                assert (k >= 0);
                if (values[k] != Values.NO_VALUE) continue;
                int propertyKeyId = indexPropertyIds[k];
                boolean thisIsTheChangedProperty = propertyKeyId == changedPropertyKeyId;
                Value value = values[k] = thisIsTheChangedProperty ? changedValue : propertyCursor.propertyValue();
                if (!thisIsTheChangedProperty) {
                    materializedValues.put(propertyKeyId, (Object)values[k]);
                    memoryTracker.allocateHeap(values[k].estimatedHeapUsage());
                }
                --missing;
            }
        }
        return values;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

