/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.IndexHintException;

public class NotificationDetail {
    public static String commaSeparated(Iterable<String> values) {
        return String.join((CharSequence)", ", values);
    }

    public static String deprecatedName(String oldName) {
        return String.format(": `%s`.", oldName);
    }

    public static String deprecatedName(String oldName, String newName) {
        return String.format(". ('%s' has been replaced by '%s')", oldName, newName);
    }

    public static String index(IndexHintException.IndexHintIndexType indexType, String label, List<String> propertyKeys) {
        String prettyProperties = NotificationDetail.commaSeparated(propertyKeys);
        String prettyLabel = NotificationDetail.labelOrRelationshipType(label);
        String prettyIndexHint = switch (indexType) {
            case IndexHintException.IndexHintIndexType.TEXT -> "TEXT INDEX";
            case IndexHintException.IndexHintIndexType.RANGE -> "RANGE INDEX";
            case IndexHintException.IndexHintIndexType.POINT -> "POINT INDEX";
            default -> "INDEX";
        };
        return prettyIndexHint + " " + prettyLabel + "(" + prettyProperties + ")";
    }

    public static String indexHint(EntityType entityType, IndexHintException.IndexHintIndexType indexType, String variableName, String labelName, String ... propertyKeyNames) {
        String indexFormatString = IndexHintException.indexFormatString((String)variableName, (String)labelName, Arrays.asList(propertyKeyNames), (EntityType)entityType, (IndexHintException.IndexHintIndexType)indexType);
        return NotificationDetail.createNotificationDetail("index", indexFormatString, true);
    }

    public static String parameters(List<String> parameters) {
        return parameters.stream().map(parameter -> "$" + parameter).collect(Collectors.joining(", "));
    }

    public static String missingLabel(String labelName) {
        return NotificationDetail.createNotificationDetail("the missing label name", labelName, true);
    }

    public static String missingRelationshipType(String relType) {
        return NotificationDetail.createNotificationDetail("the missing relationship type", relType, true);
    }

    public static String missingParameters(List<String> parameters) {
        return "Missing parameters: " + NotificationDetail.commaSeparated(parameters);
    }

    public static String procedureWarning(String procedure, String warning) {
        return String.format(warning, procedure);
    }

    public static String propertyName(String name) {
        return NotificationDetail.createNotificationDetail("the missing property name", name, true);
    }

    public static String shadowingVariable(String name) {
        return NotificationDetail.createNotificationDetail("the shadowing variable", name, true);
    }

    public static String repeatedVarLengthRel(String name) {
        return NotificationDetail.createNotificationDetail("the repeated variable-length relationship", name, true);
    }

    public static String joinKey(List<String> identifiers) {
        boolean singular = identifiers.size() == 1;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(identifier);
        }
        return NotificationDetail.createNotificationDetail(singular ? "hinted join key identifier" : "hinted join key identifiers", builder.toString(), singular);
    }

    public static String cartesianProductDescription(Set<String> identifiers) {
        return NotificationDetail.createNotificationDetail(identifiers, "identifier", "identifiers");
    }

    public static String nodeIndexSeekOrScan(Set<String> labels) {
        Set<String> prettyLabels = labels.stream().map(NotificationDetail::labelOrRelationshipType).collect(Collectors.toSet());
        return NotificationDetail.createNotificationDetail(prettyLabels, "indexed label", "indexed labels");
    }

    public static String relationshipIndexSeekOrScan(Set<String> labels) {
        Set<String> prettyLabels = labels.stream().map(NotificationDetail::labelOrRelationshipType).collect(Collectors.toSet());
        return NotificationDetail.createNotificationDetail(prettyLabels, "indexed relationship type", "indexed relationship types");
    }

    public static String deprecatedField(String procedure, String field) {
        return String.format("'%s' returned by '%s' is deprecated.", field, procedure);
    }

    private static String createNotificationDetail(Set<String> elements, String singularTerm, String pluralTerm) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        String separator = "";
        for (String element : elements) {
            builder.append(separator);
            builder.append(element);
            separator = ", ";
        }
        builder.append(')');
        boolean singular = elements.size() == 1;
        return NotificationDetail.createNotificationDetail(singular ? singularTerm : pluralTerm, builder.toString(), singular);
    }

    private static String createNotificationDetail(String name, String value, boolean singular) {
        return String.format("%s %s %s", name, singular ? "is:" : "are:", value);
    }

    private static String labelOrRelationshipType(String labelName) {
        return ":" + labelName;
    }

    public static String deprecationNotificationDetail(String replacement) {
        return String.format("Please use '%s' instead", replacement);
    }

    public static String unsatisfiableRelTypeExpression(String expression) {
        return String.format("`%s` can never be satisfied by any relationship. Relationships must have exactly one relationship type.", expression);
    }

    public static String repeatedRelationship(String relationshipName) {
        return String.format("Relationship `%s` was repeated", relationshipName);
    }
}

