/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategy;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractExtensions
implements DependencyResolver,
Lifecycle {
    private final ExtensionContext extensionContext;
    private final List<ExtensionFactory<?>> extensionFactories;
    private final Dependencies dependencies;
    private final LifeSupport life = new LifeSupport();
    private final ExtensionFailureStrategy extensionFailureStrategy;

    AbstractExtensions(ExtensionContext extensionContext, Iterable<ExtensionFactory<?>> extensionFactories, Dependencies dependencies, ExtensionFailureStrategy extensionFailureStrategy, ExtensionType extensionType) {
        this.extensionContext = extensionContext;
        this.extensionFailureStrategy = extensionFailureStrategy;
        this.extensionFactories = Iterables.stream(extensionFactories).filter(e -> e.getExtensionType() == extensionType).toList();
        this.dependencies = dependencies;
    }

    public void init() {
        for (ExtensionFactory<?> extensionFactory : this.extensionFactories) {
            try {
                Object extensionDependencies = this.getExtensionDependencies(extensionFactory);
                Lifecycle dependency = AbstractExtensions.newInstance(this.extensionContext, extensionFactory, extensionDependencies);
                Objects.requireNonNull(dependency, extensionFactory + " returned a null extension.");
                this.life.add((Lifecycle)this.dependencies.satisfyDependency((Object)dependency));
            }
            catch (UnsatisfiedDependencyException exception) {
                this.extensionFailureStrategy.handle(extensionFactory, exception);
            }
            catch (Throwable throwable) {
                this.extensionFailureStrategy.handle(extensionFactory, throwable);
            }
        }
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }

    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        Iterable<T> typeDependencies = this.resolveTypeDependencies(type);
        return (T)selector.select(type, typeDependencies);
    }

    public <T> Iterable<T> resolveTypeDependencies(Class<T> type) {
        return this.life.getLifecycleInstances().stream().filter(type::isInstance).map(type::cast).toList();
    }

    public boolean containsDependency(Class<?> type) {
        return this.life.getLifecycleInstances().stream().anyMatch(type::isInstance);
    }

    private Object getExtensionDependencies(ExtensionFactory<?> factory) {
        Class<?> factoryType = factory.getClass().getSuperclass();
        Type genericSuperclass = factory.getClass().getGenericSuperclass();
        while (factoryType.getGenericSuperclass() instanceof ParameterizedType) {
            genericSuperclass = factoryType.getGenericSuperclass();
            factoryType = factoryType.getSuperclass();
        }
        Class configurationClass = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        return DependenciesProxy.dependencies((DependencyResolver)this.dependencies, configurationClass);
    }

    private static <T> Lifecycle newInstance(ExtensionContext extensionContext, ExtensionFactory<T> factory, Object dependencies) {
        return factory.newInstance(extensionContext, dependencies);
    }
}

