/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;

abstract class DefaultCursors {
    private final Collection<CloseableStacktrace> closeables;
    private final boolean trackCursorClose;
    private final boolean traceCursorClose;

    DefaultCursors(Collection<CloseableStacktrace> closeables, Config config) {
        this.closeables = closeables;
        this.trackCursorClose = (Boolean)config.get(GraphDatabaseInternalSettings.track_cursor_close);
        this.traceCursorClose = (Boolean)config.get(GraphDatabaseInternalSettings.trace_cursors);
    }

    protected <T extends AutoCloseablePlus> T trace(T closeable) {
        if (this.trackCursorClose) {
            StackTraceElement[] stackTrace = null;
            if (this.traceCursorClose) {
                stackTrace = Thread.currentThread().getStackTrace();
                stackTrace = Arrays.copyOfRange(stackTrace, 2, stackTrace.length);
            }
            this.closeables.add(new CloseableStacktrace(closeable, stackTrace));
        }
        return closeable;
    }

    public void assertClosed() {
        if (this.trackCursorClose) {
            for (CloseableStacktrace c : this.closeables) {
                c.assertClosed();
            }
            this.closeables.clear();
        }
    }

    static class CloseableStacktrace {
        private final AutoCloseablePlus c;
        private final StackTraceElement[] stackTrace;

        CloseableStacktrace(AutoCloseablePlus c, StackTraceElement[] stackTrace) {
            this.c = c;
            this.stackTrace = stackTrace;
        }

        void assertClosed() {
            if (!this.c.isClosed()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)out, false, StandardCharsets.UTF_8);
                if (this.stackTrace != null) {
                    printStream.println();
                    for (StackTraceElement traceElement : this.stackTrace) {
                        printStream.println("\tat " + traceElement);
                    }
                } else {
                    String msg = String.format(" To see stack traces please set '%s' setting to true", GraphDatabaseInternalSettings.trace_cursors.name());
                    printStream.print(msg);
                }
                printStream.println();
                throw new IllegalStateException(String.format("Closeable %s was not closed!%s", this.c, out.toString(StandardCharsets.UTF_8)));
            }
        }
    }
}

