/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexProvider;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class StaticIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private final Map<IndexProviderDescriptor, IndexProvider> indexProvidersByDescriptor = new HashMap<IndexProviderDescriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();
    private final Map<IndexType, List<IndexProvider>> indexProvidersByType = new HashMap<IndexType, List<IndexProvider>>();
    private final IndexProvider tokenIndexProvider;
    private final IndexProvider textIndexProvider;
    private final IndexProvider fulltextIndexProvider;
    private final IndexProvider rangeIndexProvider;
    private final IndexProvider pointIndexProvider;
    private final IndexProvider trigramIndexProvider;
    private final IndexProvider vectorIndexProvider;
    private final DependencyResolver dependencies;

    public StaticIndexProviderMap(TokenIndexProvider tokenIndexProvider, TextIndexProvider textIndexProvider, FulltextIndexProvider fulltextIndexProvider, RangeIndexProvider rangeIndexProvider, PointIndexProvider pointIndexProvider, TrigramIndexProvider trigramIndexProvider, VectorIndexProvider vectorIndexProvider, DependencyResolver dependencies) {
        this.tokenIndexProvider = tokenIndexProvider;
        this.textIndexProvider = textIndexProvider;
        this.fulltextIndexProvider = fulltextIndexProvider;
        this.rangeIndexProvider = rangeIndexProvider;
        this.pointIndexProvider = pointIndexProvider;
        this.trigramIndexProvider = trigramIndexProvider;
        this.vectorIndexProvider = vectorIndexProvider;
        this.dependencies = dependencies;
    }

    public void init() throws Exception {
        this.add(this.tokenIndexProvider);
        this.add(this.textIndexProvider);
        this.add(this.fulltextIndexProvider);
        this.add(this.rangeIndexProvider);
        this.add(this.pointIndexProvider);
        this.add(this.trigramIndexProvider);
        if (this.vectorIndexProvider != null) {
            this.add(this.vectorIndexProvider);
        }
        this.dependencies.resolveTypeDependencies(IndexProvider.class).forEach(this::add);
    }

    public IndexProvider getDefaultProvider() {
        return this.rangeIndexProvider;
    }

    public IndexProvider getFulltextProvider() {
        return this.fulltextIndexProvider;
    }

    public IndexProvider getTokenIndexProvider() {
        return this.tokenIndexProvider;
    }

    public IndexProvider getTextIndexProvider() {
        return this.trigramIndexProvider;
    }

    public IndexProvider getPointIndexProvider() {
        return this.pointIndexProvider;
    }

    public IndexProvider getVectorIndexProvider() {
        return this.vectorIndexProvider;
    }

    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        IndexProvider provider = this.indexProvidersByDescriptor.get(providerDescriptor);
        this.assertProviderFound(provider, providerDescriptor.name());
        return provider;
    }

    public IndexProvider lookup(String providerDescriptorName) {
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        this.assertProviderFound(provider, providerDescriptorName);
        return provider;
    }

    public List<IndexProvider> lookup(IndexType indexType) {
        List<IndexProvider> indexProviders = this.indexProvidersByType.get(indexType);
        this.assertProviderFoundByType(indexProviders, indexType);
        return indexProviders;
    }

    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProvidersByDescriptor.values().forEach(visitor);
    }

    private void assertProviderFound(IndexProvider provider, String providerDescriptorName) {
        if (provider == null) {
            throw new IndexProviderNotFoundException("Tried to get index provider with name " + providerDescriptorName + " whereas available providers in this session being " + this.indexProvidersByName.keySet() + ", and default being " + this.rangeIndexProvider.getProviderDescriptor().name());
        }
    }

    private void assertProviderFoundByType(List<IndexProvider> indexProviders, IndexType indexType) {
        if (indexProviders == null) {
            List<String> providerNamesByType = this.indexProvidersByType.entrySet().stream().map(entry -> {
                IndexType type = (IndexType)entry.getKey();
                List providers = (List)entry.getValue();
                return type + "=" + providers.stream().map(provider -> provider.getProviderDescriptor().name()).toList();
            }).toList();
            throw new IndexProviderNotFoundException("Tried to get index providers for index type " + indexType + " but could not find any. Available index providers per type are " + providerNamesByType);
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index, indexingBehaviour);
    }

    private void add(IndexProvider provider) {
        IndexProviderDescriptor providerDescriptor = Objects.requireNonNull(provider.getProviderDescriptor());
        IndexProvider existing = this.indexProvidersByDescriptor.putIfAbsent(providerDescriptor, provider);
        if (existing != null) {
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
        this.indexProvidersByName.putIfAbsent(providerDescriptor.name(), provider);
        this.indexProvidersByType.computeIfAbsent(provider.getIndexType(), it -> new ArrayList()).add(provider);
    }
}

