/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.enrichment;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongIntHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.database.enrichment.ChangeType;
import org.neo4j.kernel.api.database.enrichment.DeltaType;
import org.neo4j.kernel.api.database.enrichment.ValuesWriter;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.CaptureMode;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommandFactory;
import org.neo4j.storageengine.api.enrichment.EnrichmentTxStateVisitor;
import org.neo4j.storageengine.api.enrichment.TxMetadata;
import org.neo4j.storageengine.api.enrichment.WriteEnrichmentChannel;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public class TxEnrichmentVisitor
extends TxStateVisitor.Delegator
implements EnrichmentTxStateVisitor {
    public static final int NO_MORE_PROPERTIES = Integer.MIN_VALUE;
    public static final byte ADDED_MARKER = 1;
    public static final byte MODIFIED_MARKER = 2;
    public static final byte DELETED_MARKER = 4;
    public static final int UNKNOWN_POSITION = -1;
    private static final int TYPE_OFFSET = 8;
    private static final int DELTA_OFFSET = 9;
    private static final int CONSTRAINTS_OFFSET = 10;
    private static final int PROPERTIES_STATE_OFFSET = 14;
    private static final int PROPERTIES_CHANGE_OFFSET = 18;
    private static final int LABELS_STATE_OFFSET = 22;
    private static final int LABELS_CHANGE_OFFSET = 26;
    public static final long NODE_SIZE = 30L;
    private final CaptureMode captureMode;
    private final String serverId;
    private final KernelVersion kernelVersion;
    private final EnrichmentCommandFactory enrichmentCommandFactory;
    private final ReadableTransactionState txState;
    private final long lastTransactionIdWhenStarted;
    private final StorageReader store;
    private final MemoryTracker memoryTracker;
    private final WriteEnrichmentChannel participantsChannel;
    private final WriteEnrichmentChannel detailsChannel;
    private final WriteEnrichmentChannel changesChannel;
    private final ValuesChannel valuesChannel;
    private final ValuesChannel metadataChannel;
    private final HeapTrackingArrayList<Participant> participants;
    private final HeapTrackingLongIntHashMap nodePositions;
    private final HeapTrackingLongIntHashMap relationshipPositions;
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipScanCursor relCursor;
    private final StoragePropertyCursor propertiesCursor;

    public TxEnrichmentVisitor(TxStateVisitor parent, CaptureMode captureMode, String serverId, KernelVersionProvider kernelVersionProvider, EnrichmentCommandFactory enrichmentCommandFactory, ReadableTransactionState txState, Map<String, Object> userMetadata, long lastTransactionIdWhenStarted, StorageReader store, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(parent);
        this.captureMode = captureMode;
        this.serverId = serverId;
        this.kernelVersion = kernelVersionProvider.kernelVersion();
        this.enrichmentCommandFactory = enrichmentCommandFactory;
        this.txState = txState;
        this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
        this.store = store;
        this.memoryTracker = memoryTracker;
        this.participantsChannel = new WriteEnrichmentChannel(memoryTracker);
        this.detailsChannel = new WriteEnrichmentChannel(memoryTracker);
        this.changesChannel = new WriteEnrichmentChannel(memoryTracker);
        this.valuesChannel = new ValuesChannel(memoryTracker);
        this.participants = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
        this.nodePositions = HeapTrackingCollections.newLongIntMap((MemoryTracker)memoryTracker);
        this.relationshipPositions = HeapTrackingCollections.newLongIntMap((MemoryTracker)memoryTracker);
        this.nodeCursor = store.allocateNodeCursor(cursorContext, storeCursors);
        this.relCursor = store.allocateRelationshipScanCursor(cursorContext, storeCursors);
        this.propertiesCursor = store.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker);
        if (this.kernelVersion.isAtLeast(KernelVersion.VERSION_CDC_USER_METADATA_INTRODUCED)) {
            this.metadataChannel = new ValuesChannel(memoryTracker);
            if (!userMetadata.isEmpty()) {
                this.metadataChannel.writer.writeInteger(userMetadata.size());
                userMetadata.forEach((key, value) -> {
                    this.metadataChannel.writer.writeString((String)key);
                    this.metadataChannel.writer.write(ValueUtils.of(value));
                });
            }
        } else {
            this.metadataChannel = null;
        }
    }

    public void visitCreatedNode(long id) {
        super.visitCreatedNode(id);
        this.setNodeChangeType(id, DeltaType.ADDED);
    }

    public void visitDeletedNode(long id) {
        super.visitDeletedNode(id);
        this.captureNodeState(id, DeltaType.DELETED, true);
    }

    public void visitRelationshipModifications(RelationshipModifications modifications) throws ConstraintValidationException {
        super.visitRelationshipModifications(modifications);
        modifications.creations().forEach((relationshipId, typeId, startNodeId, endNodeId, addedProperties) -> {
            int startPos = this.captureNodeState(startNodeId, DeltaType.STATE, false);
            int endPos = this.captureNodeState(endNodeId, DeltaType.STATE, false);
            this.setRelationshipChangeType(relationshipId, DeltaType.ADDED, typeId, startPos, endPos);
            this.captureRelTypeConstraints(relationshipId, typeId);
            this.setRelationshipChangeDelta(relationshipId, ChangeType.PROPERTIES_STATE, this.captureRelationshipState(addedProperties));
        });
        modifications.deletions().forEach((relationshipId, typeId, startNodeId, endNodeId, addedProperties) -> {
            int startPos = this.captureNodeState(startNodeId, DeltaType.STATE, false);
            int endPos = this.captureNodeState(endNodeId, DeltaType.STATE, false);
            this.setRelationshipChangeType(relationshipId, DeltaType.DELETED, typeId, startPos, endPos);
            this.captureRelTypeConstraints(relationshipId, typeId);
            this.captureRelationshipState(relationshipId, typeId, startNodeId, endNodeId, PropertySelection.ALL_PROPERTIES);
        });
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
        super.visitNodeLabelChanges(id, added, removed);
        this.captureNodeState(id, DeltaType.MODIFIED, true);
        int position = this.changesChannel.size();
        boolean addedInThisBatch = this.txState.nodeIsAddedInThisBatch(id);
        if (addedInThisBatch) {
            int[] labels = TxEnrichmentVisitor.toIntArray(added);
            this.addLabels(labels);
            this.captureLabelConstraints(id, labels);
        } else {
            this.addLabels(TxEnrichmentVisitor.toIntArray(added));
            this.addLabels(TxEnrichmentVisitor.toIntArray(removed));
        }
        this.setNodeChangeDelta(id, addedInThisBatch ? ChangeType.LABELS_STATE : ChangeType.LABELS_CHANGE, position);
    }

    public void visitNodePropertyChanges(long id, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
        super.visitNodePropertyChanges(id, added, changed, removed);
        this.captureNodeState(id, DeltaType.MODIFIED, true);
        if (this.txState.nodeIsAddedInThisBatch(id)) {
            this.setNodeChangeDelta(id, ChangeType.PROPERTIES_STATE, this.addNewNodeProperties(added));
        } else {
            int position = this.changesChannel.size();
            this.nodeCursor.single(id);
            byte changesFlag = this.entityProperties((StorageEntityCursor)this.nodeCursor, added, changed, removed);
            if (changesFlag == 0) {
                this.setNodeChangeDelta(id, ChangeType.PROPERTIES_CHANGE, -1);
            } else {
                this.changesChannel.put(position, changesFlag);
                this.setNodeChangeDelta(id, ChangeType.PROPERTIES_CHANGE, position);
            }
        }
    }

    public void visitRelPropertyChanges(long id, int type, long startNode, long endNode, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
        super.visitRelPropertyChanges(id, type, startNode, endNode, added, changed, removed);
        Preconditions.checkState((!this.relationshipPositions.containsKey(id) ? 1 : 0) != 0, (String)("Already tracking the relationship: " + id));
        int startPos = this.captureNodeState(startNode, DeltaType.STATE, false);
        int endPos = this.captureNodeState(endNode, DeltaType.STATE, false);
        this.setRelationshipChangeType(id, DeltaType.MODIFIED, type, startPos, endPos);
        IntSet constraintProps = this.captureRelTypeConstraints(id, type);
        PropertySelection selection = this.captureMode == CaptureMode.FULL ? PropertySelection.ALL_PROPERTIES : this.selection(constraintProps);
        this.captureRelationshipState(id, type, startNode, endNode, selection);
        int position = this.changesChannel.size();
        this.relCursor.single(id, startNode, type, endNode);
        byte changesFlag = this.entityProperties((StorageEntityCursor)this.relCursor, added, changed, removed);
        if (changesFlag == 0) {
            this.setRelationshipChangeDelta(id, ChangeType.PROPERTIES_CHANGE, -1);
        } else {
            this.changesChannel.put(position, changesFlag);
            this.setRelationshipChangeDelta(id, ChangeType.PROPERTIES_CHANGE, position);
        }
    }

    private byte entityProperties(StorageEntityCursor entityCursor, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) {
        byte changesFlag = 0;
        if (entityCursor.next()) {
            changesFlag = (byte)(changesFlag | (this.entityPropertyAdditions(added) ? (byte)1 : 0));
            changesFlag = (byte)(changesFlag | (this.entityPropertyChanges(entityCursor, changed, changesFlag > 0) ? 2 : 0));
            changesFlag = (byte)(changesFlag | (this.entityPropertyDeletes(entityCursor, removed, changesFlag > 0) ? 4 : 0));
        }
        return changesFlag;
    }

    public EnrichmentCommand command(SecurityContext securityContext) {
        if (this.ensureParticipantsWritten()) {
            TxMetadata metadata = TxMetadata.create((CaptureMode)this.captureMode, (String)this.serverId, (SecurityContext)securityContext, (long)this.lastTransactionIdWhenStarted);
            Enrichment.Write enrichment = this.metadataChannel == null ? Enrichment.Write.createV5_8((TxMetadata)metadata, (WriteEnrichmentChannel)this.participantsChannel, (WriteEnrichmentChannel)this.detailsChannel, (WriteEnrichmentChannel)this.changesChannel, (WriteEnrichmentChannel)this.valuesChannel.channel) : Enrichment.Write.createV5_12((TxMetadata)metadata, (WriteEnrichmentChannel)this.participantsChannel, (WriteEnrichmentChannel)this.detailsChannel, (WriteEnrichmentChannel)this.changesChannel, (WriteEnrichmentChannel)this.valuesChannel.channel, (WriteEnrichmentChannel)this.metadataChannel.channel);
            return this.enrichmentCommandFactory.create(this.kernelVersion, (Enrichment)enrichment);
        }
        return null;
    }

    public void close() throws KernelException {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this::ensureParticipantsWritten, () -> TxEnrichmentVisitor.super.close(), this.nodeCursor, this.relCursor, this.propertiesCursor, this.participants, this.nodePositions, this.relationshipPositions});
    }

    private boolean ensureParticipantsWritten() {
        if (!this.participants.isEmpty() && this.participantsChannel.isEmpty()) {
            Collections.sort(this.participants);
            for (Participant participant : this.participants) {
                this.participantsChannel.putInt(participant.position);
            }
            this.participants.clear();
            this.participantsChannel.flip();
            this.detailsChannel.flip();
            this.changesChannel.flip();
            this.valuesChannel.flip();
            if (this.metadataChannel != null) {
                this.metadataChannel.flip();
            }
            return true;
        }
        return !this.participantsChannel.isEmpty();
    }

    private boolean setNodeChangeType(long id, DeltaType deltaType) {
        int beforePos = this.detailsChannel.size();
        int position = this.nodePositions.getIfAbsentPut(id, beforePos);
        if (position == beforePos) {
            if (deltaType != DeltaType.STATE) {
                this.participants.add((Object)this.createParticipant(EntityType.NODE, deltaType, id, position));
            }
            this.detailsChannel.putLong(id).put(EntityType.NODE.id()).put(deltaType.id()).putInt(-1).putInt(-1).putInt(-1).putInt(-1).putInt(-1);
            return true;
        }
        DeltaType currentType = TxEnrichmentVisitor.deltaType(this.detailsChannel.peek(position + 9));
        if (deltaType.id() < currentType.id()) {
            this.participants.add((Object)this.createParticipant(EntityType.NODE, deltaType, id, position));
            this.detailsChannel.put(position + 9, deltaType.id());
        }
        return false;
    }

    private void setNodeChangeDelta(long id, ChangeType changeType, int changePosition) {
        int position = this.nodePositions.getIfAbsent(id, -1);
        Preconditions.checkState((position != -1 ? 1 : 0) != 0, (String)("Not yet tracking the node: " + id));
        int offset = switch (changeType) {
            default -> throw new IncompatibleClassChangeError();
            case ChangeType.CONSTRAINTS -> 10;
            case ChangeType.PROPERTIES_STATE -> 14;
            case ChangeType.PROPERTIES_CHANGE -> 18;
            case ChangeType.LABELS_STATE -> 22;
            case ChangeType.LABELS_CHANGE -> 26;
        };
        this.detailsChannel.putInt(position + offset, changePosition);
    }

    private void setRelationshipChangeType(long id, DeltaType deltaType, int type, int sourcePos, int targetPos) {
        this.participants.add((Object)this.createParticipant(EntityType.RELATIONSHIP, deltaType, id, this.detailsChannel.size()));
        this.relationshipPositions.put(id, this.detailsChannel.size());
        this.detailsChannel.putLong(id).put(EntityType.RELATIONSHIP.id()).put(deltaType.id()).putInt(-1).putInt(-1).putInt(-1).putInt(type).putInt(sourcePos).putInt(targetPos);
    }

    private void setRelationshipChangeDelta(long id, ChangeType changeType, int changePosition) {
        int position = this.relationshipPositions.getIfAbsent(id, -1);
        Preconditions.checkState((position != -1 ? 1 : 0) != 0, (String)("Not yet tracking the entity: " + id));
        int offset = switch (changeType) {
            case ChangeType.CONSTRAINTS -> 10;
            case ChangeType.PROPERTIES_STATE -> 14;
            case ChangeType.PROPERTIES_CHANGE -> 18;
            default -> throw new IllegalStateException("Relationships do not have labels");
        };
        this.detailsChannel.putInt(position + offset, changePosition);
    }

    private PropertySelection selection(IntSet constraintProps) {
        return constraintProps.isEmpty() ? null : PropertySelection.selection((int[])constraintProps.toArray());
    }

    private int captureNodeState(long id, DeltaType deltaType, boolean asPartOfNodeChange) {
        if (this.setNodeChangeType(id, deltaType) && !this.txState.nodeIsAddedInThisBatch(id)) {
            this.nodeCursor.single(id);
            if (this.nodeCursor.next()) {
                int[] labels = TxEnrichmentVisitor.toSortedIntArray(this.nodeCursor.labels());
                IntSet constraintProps = this.captureLabelConstraints(id, labels);
                this.setNodeChangeDelta(id, ChangeType.LABELS_STATE, this.addLabels(labels));
                PropertySelection selection = this.txState.nodeIsDeletedInThisBatch(id) || asPartOfNodeChange && this.captureMode == CaptureMode.FULL ? PropertySelection.ALL_PROPERTIES : this.selection(constraintProps);
                this.setNodeChangeDelta(id, ChangeType.PROPERTIES_STATE, this.addPropertiesFromCursor(EntityType.NODE, selection));
            }
        }
        return this.nodePositions.get(id);
    }

    private IntSet captureLabelConstraints(long id, int ... labels) {
        if (labels.length == 0) {
            return IntSets.immutable.empty();
        }
        int constraintGroupsAdded = 0;
        MutableIntSet constraintProps = IntSets.mutable.empty();
        int constraintsPosition = this.changesChannel.size();
        for (int label : labels) {
            IntSet[] logicalPropsArray = this.store.constraintsGetPropertyTokensForLogicalKey(label, EntityType.NODE);
            if (logicalPropsArray.length <= 0) continue;
            if (constraintGroupsAdded == 0) {
                this.changesChannel.putInt(0);
            }
            this.changesChannel.putInt(label).putInt(logicalPropsArray.length);
            for (IntSet logicalProps : logicalPropsArray) {
                this.writeConstraints(constraintProps, logicalProps);
            }
            ++constraintGroupsAdded;
        }
        if (constraintGroupsAdded > 0) {
            this.changesChannel.putInt(constraintsPosition, constraintGroupsAdded);
            this.setNodeChangeDelta(id, ChangeType.CONSTRAINTS, constraintsPosition);
        }
        return constraintProps;
    }

    private void captureRelationshipState(long id, int type, long startNode, long endNode, PropertySelection selection) {
        this.relCursor.single(id, startNode, type, endNode);
        if (this.relCursor.next()) {
            this.setRelationshipChangeDelta(id, ChangeType.PROPERTIES_STATE, this.addPropertiesFromCursor(EntityType.RELATIONSHIP, selection));
        }
    }

    private IntSet captureRelTypeConstraints(long id, int relType) {
        MutableIntSet constraintProps = IntSets.mutable.empty();
        IntSet[] logicalPropsArrays = this.store.constraintsGetPropertyTokensForLogicalKey(relType, EntityType.RELATIONSHIP);
        if (logicalPropsArrays.length > 0) {
            int constraintsPosition = this.changesChannel.size();
            this.changesChannel.putInt(relType).putInt(logicalPropsArrays.length);
            for (IntSet logicalProps : logicalPropsArrays) {
                this.writeConstraints(constraintProps, logicalProps);
            }
            this.setRelationshipChangeDelta(id, ChangeType.CONSTRAINTS, constraintsPosition);
        }
        return constraintProps;
    }

    private int captureRelationshipState(Iterable<StorageProperty> properties) {
        Iterator<StorageProperty> iterator = properties.iterator();
        if (!iterator.hasNext()) {
            return -1;
        }
        int position = this.changesChannel.size();
        while (iterator.hasNext()) {
            StorageProperty property = iterator.next();
            int propertyKeyId = property.propertyKeyId();
            this.captureProperty(propertyKeyId, property.value());
        }
        this.changesChannel.putInt(Integer.MIN_VALUE);
        return position;
    }

    private void writeConstraints(MutableIntSet allConstraintProps, IntSet logicalProps) {
        allConstraintProps.addAll((IntIterable)logicalProps);
        this.changesChannel.putInt(logicalProps.size());
        logicalProps.forEach(arg_0 -> ((WriteEnrichmentChannel)this.changesChannel).putInt(arg_0));
    }

    private int addNewNodeProperties(Iterable<StorageProperty> properties) {
        Iterator<StorageProperty> iterator = properties.iterator();
        if (!iterator.hasNext()) {
            return -1;
        }
        int position = this.changesChannel.size();
        while (iterator.hasNext()) {
            StorageProperty property = iterator.next();
            this.captureProperty(property.propertyKeyId(), property.value());
        }
        this.changesChannel.putInt(Integer.MIN_VALUE);
        return position;
    }

    private int addPropertiesFromCursor(EntityType entityType, PropertySelection selection) {
        if (selection == null) {
            return -1;
        }
        if (entityType == EntityType.NODE) {
            this.propertiesCursor.initNodeProperties(this.nodeCursor, selection);
        } else {
            this.propertiesCursor.initRelationshipProperties((StorageRelationshipCursor)this.relCursor, selection);
        }
        int position = this.changesChannel.size();
        int captured = 0;
        while (this.propertiesCursor.next()) {
            int property = this.propertiesCursor.propertyKey();
            this.captureProperty(property, this.propertiesCursor.propertyValue());
            ++captured;
        }
        if (captured == 0) {
            return -1;
        }
        this.changesChannel.putInt(Integer.MIN_VALUE);
        return position;
    }

    private void captureProperty(int property, Value value) {
        this.changesChannel.putInt(property);
        this.changesChannel.putInt(this.valuesChannel.write(value));
    }

    private int addLabels(int ... labels) {
        int position = this.changesChannel.size();
        this.changesChannel.putInt(labels.length);
        for (int label : labels) {
            this.changesChannel.putInt(label);
        }
        return position;
    }

    private boolean entityPropertyAdditions(Iterable<StorageProperty> properties) {
        int captured = 0;
        for (StorageProperty property : properties) {
            if (captured == 0) {
                this.changesChannel.put((byte)0);
            }
            this.changesChannel.putInt(property.propertyKeyId());
            this.changesChannel.putInt(this.valuesChannel.write(property.value()));
            ++captured;
        }
        if (captured > 0) {
            this.changesChannel.putInt(Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    private boolean entityPropertyChanges(StorageEntityCursor cursor, Iterable<StorageProperty> properties, boolean addedChangesMarker) {
        int captured = 0;
        MutableIntObjectMap propertyValues = IntObjectMaps.mutable.empty();
        for (StorageProperty property : properties) {
            propertyValues.put(property.propertyKeyId(), (Object)property.value());
        }
        if (propertyValues.isEmpty()) {
            return false;
        }
        cursor.properties(this.propertiesCursor, PropertySelection.selection((int[])propertyValues.keySet().toArray()));
        while (this.propertiesCursor.next()) {
            if (captured == 0 && !addedChangesMarker) {
                this.changesChannel.put((byte)0);
            }
            int propertyId = this.propertiesCursor.propertyKey();
            this.changesChannel.putInt(propertyId);
            this.changesChannel.putInt(this.valuesChannel.write(this.propertiesCursor.propertyValue()));
            this.changesChannel.putInt(this.valuesChannel.write((Value)propertyValues.get(propertyId)));
            ++captured;
        }
        if (captured > 0) {
            this.changesChannel.putInt(Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    private boolean entityPropertyDeletes(StorageEntityCursor cursor, IntIterable properties, boolean addedChangesMarker) {
        int[] propertyIds = properties.toArray();
        if (propertyIds.length == 0) {
            return false;
        }
        int captured = 0;
        cursor.properties(this.propertiesCursor, PropertySelection.selection((int[])propertyIds));
        while (this.propertiesCursor.next()) {
            if (captured == 0 && !addedChangesMarker) {
                this.changesChannel.put((byte)0);
            }
            this.changesChannel.putInt(this.propertiesCursor.propertyKey());
            this.changesChannel.putInt(this.valuesChannel.write(this.propertiesCursor.propertyValue()));
            ++captured;
        }
        if (captured > 0) {
            this.changesChannel.putInt(Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    private Participant createParticipant(EntityType entityType, DeltaType deltaType, long id, int position) {
        short orderCode = (short)(deltaType.id() << 8);
        orderCode = deltaType == DeltaType.DELETED ? (short)(orderCode | (short)(entityType == EntityType.NODE ? 1 : 0)) : (short)(orderCode | (short)(entityType != EntityType.NODE ? 1 : 0));
        this.memoryTracker.allocateHeap(Participant.SIZE);
        return new Participant(orderCode, id, position);
    }

    private static DeltaType deltaType(byte flag) {
        return (DeltaType)((Object)DeltaType.BY_ID.get(flag));
    }

    private static int[] toIntArray(LongSet ids) {
        return TxEnrichmentVisitor.toIntArray(ids.toSortedArray());
    }

    private static int[] toSortedIntArray(int[] data) {
        Arrays.sort(data);
        return data;
    }

    private static int[] toIntArray(long[] sorted) {
        int[] tokens = new int[sorted.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = (int)sorted[i];
        }
        return tokens;
    }

    private static class ValuesChannel {
        private final WriteEnrichmentChannel channel;
        private final ValuesWriter writer;

        private ValuesChannel(MemoryTracker memoryTracker) {
            this.channel = new WriteEnrichmentChannel(memoryTracker);
            this.writer = new ValuesWriter(this.channel);
        }

        private void flip() {
            this.channel.flip();
        }

        private int write(Value value) {
            return this.writer.write((AnyValue)value);
        }
    }

    private static class Participant
    implements Comparable<Participant> {
        private static final long SIZE = HeapEstimator.shallowSizeOfInstance(Participant.class);
        private final short orderCode;
        private final long id;
        private final int position;

        private Participant(short orderCode, long id, int position) {
            this.orderCode = orderCode;
            this.id = id;
            this.position = position;
        }

        @Override
        public int compareTo(Participant other) {
            int c = Short.compare(this.orderCode, other.orderCode);
            return c == 0 ? Long.compare(this.id, other.id) : c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Participant that = (Participant)o;
            return this.orderCode == that.orderCode && this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.orderCode, this.id);
        }
    }
}

