/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class DeferredConflictCheckingIndexUpdater
implements IndexUpdater {
    private final IndexUpdater actual;
    private final Supplier<ValueIndexReader> readerSupplier;
    private final IndexDescriptor indexDescriptor;
    private final CursorContext cursorContext;
    private final Set<ValueTuple> touchedTuples = new HashSet<ValueTuple>();

    public DeferredConflictCheckingIndexUpdater(IndexUpdater actual, Supplier<ValueIndexReader> readerSupplier, IndexDescriptor indexDescriptor, CursorContext cursorContext) {
        this.actual = actual;
        this.readerSupplier = readerSupplier;
        this.indexDescriptor = indexDescriptor;
        this.cursorContext = cursorContext;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        this.actual.process((IndexEntryUpdate)valueUpdate);
        if (valueUpdate.updateMode() != UpdateMode.REMOVED) {
            this.touchedTuples.add(ValueTuple.of((Value[])valueUpdate.values()));
        }
    }

    public void close() throws IndexEntryConflictException {
        this.actual.close();
        try (ValueIndexReader reader = this.readerSupplier.get();){
            for (ValueTuple tuple : this.touchedTuples) {
                try (NodeValueIterator client = new NodeValueIterator();){
                    reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), this.queryOf(tuple));
                    if (!client.hasNext()) continue;
                    long firstEntityId = client.next();
                    if (!client.hasNext()) continue;
                    long secondEntityId = client.next();
                    throw new IndexEntryConflictException(this.indexDescriptor.schema().entityType(), firstEntityId, secondEntityId, tuple);
                }
            }
        }
        catch (IndexNotApplicableKernelException e) {
            throw new IllegalArgumentException("Unexpectedly the index reader couldn't handle this query", e);
        }
    }

    private PropertyIndexQuery[] queryOf(ValueTuple tuple) {
        PropertyIndexQuery[] predicates = new PropertyIndexQuery[tuple.size()];
        int[] propertyIds = this.indexDescriptor.schema().getPropertyIds();
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = PropertyIndexQuery.exact((int)propertyIds[i], (Object)tuple.valueAt(i));
        }
        return predicates;
    }
}

