/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataReader;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.coreapi.internal.NodeLabelPropertyIterator;
import org.neo4j.kernel.impl.coreapi.internal.RelationshipTypePropertyIterator;
import org.neo4j.kernel.impl.coreapi.internal.TrackedCursorIterator;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.FilteringNodeCursorWrapper;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public abstract class DataLookup {
    public Node getNodeById(long id) {
        if (id < 0L || !this.dataRead().nodeExists(id)) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, String.valueOf(id)));
        }
        return this.newNodeEntity(id);
    }

    public Node getNodeByElementId(String elementId) {
        long nodeId = this.elementIdMapper().nodeId(elementId);
        if (!this.dataRead().nodeExists(nodeId)) {
            throw new NotFoundException(String.format("Node %s not found.", elementId), (Throwable)new EntityNotFoundException(EntityType.NODE, elementId));
        }
        return this.newNodeEntity(nodeId);
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        DataLookup.checkLabel(myLabel);
        return this.allNodesWithLabel(myLabel);
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, String value, StringSearchMode searchMode) {
        DataLookup.checkLabel(myLabel);
        DataLookup.checkPropertyKey(key);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Template must not be null");
        TokenRead tokenRead = this.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        if (DataLookup.invalidTokens(labelId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery query = DataLookup.getIndexQuery(value, searchMode, propertyId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), IndexType.TEXT, new IndexQuery[]{query});
        if (index == IndexDescriptor.NO_INDEX && (searchMode == StringSearchMode.SUFFIX || searchMode == StringSearchMode.CONTAINS)) {
            PropertyIndexQuery.RangePredicate allStringQuery = PropertyIndexQuery.range((int)propertyId, (String)null, (boolean)false, null, (boolean)false);
            index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), new IndexQuery[]{allStringQuery});
            if (index != IndexDescriptor.NO_INDEX && index.getCapability().supportsReturningValues()) {
                return this.nodesByLabelAndPropertyWithFiltering(labelId, (PropertyIndexQuery)allStringQuery, index, query);
            }
        }
        return this.nodesByLabelAndProperty(labelId, query, index);
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple nodes with label: '%s', property name: '%s' and property value: '%s' while only one was expected.", myLabel, key, value));
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        DataLookup.checkLabel(myLabel);
        DataLookup.checkPropertyKey(key);
        TokenRead tokenRead = this.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        if (DataLookup.invalidTokens(labelId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)propertyId, (Object)Values.of((Object)value, (boolean)false));
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId}), new IndexQuery[]{query});
        return this.nodesByLabelAndProperty(labelId, (PropertyIndexQuery)query, index);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        DataLookup.checkLabel(label);
        DataLookup.checkPropertyKey(key1);
        DataLookup.checkPropertyKey(key2);
        TokenRead tokenRead = this.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(labelId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)));
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        DataLookup.checkLabel(label);
        Preconditions.checkArgument((propertyValues != null ? 1 : 0) != 0, (String)"Property values can not be null");
        TokenRead tokenRead = this.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        PropertyIndexQuery.ExactPredicate[] queries = DataLookup.convertToQueries(propertyValues, tokenRead);
        return this.nodesByLabelAndProperties(labelId, queries);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        DataLookup.checkLabel(label);
        DataLookup.checkPropertyKey(key1);
        DataLookup.checkPropertyKey(key2);
        DataLookup.checkPropertyKey(key3);
        TokenRead tokenRead = this.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(labelId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3, (boolean)false)));
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship with %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, String.valueOf(id)));
        }
        if (!this.dataRead().relationshipExists(id)) {
            throw new NotFoundException(String.format("Relationship with %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, String.valueOf(id)));
        }
        return this.newRelationshipEntity(id);
    }

    public Relationship getRelationshipByElementId(String elementId) {
        long relationshipId = this.elementIdMapper().relationshipId(elementId);
        if (!this.dataRead().relationshipExists(relationshipId)) {
            throw new NotFoundException(String.format("Relationship %s not found.", elementId), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, elementId));
        }
        return this.newRelationshipEntity(relationshipId);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, String template, StringSearchMode searchMode) {
        DataLookup.checkRelationshipType(relationshipType);
        DataLookup.checkPropertyKey(key);
        Preconditions.checkArgument((template != null ? 1 : 0) != 0, (String)"Template must not be null");
        TokenRead tokenRead = this.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        int propertyId = tokenRead.propertyKey(key);
        if (DataLookup.invalidTokens(typeId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery query = DataLookup.getIndexQuery(template, searchMode, propertyId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), IndexType.TEXT, new IndexQuery[]{query});
        if (index == IndexDescriptor.NO_INDEX && (searchMode == StringSearchMode.SUFFIX || searchMode == StringSearchMode.CONTAINS)) {
            PropertyIndexQuery.RangePredicate allStringQuery = PropertyIndexQuery.range((int)propertyId, (String)null, (boolean)false, null, (boolean)false);
            index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), new IndexQuery[]{allStringQuery});
            if (index != IndexDescriptor.NO_INDEX && index.getCapability().supportsReturningValues()) {
                return this.relationshipsByTypeAndPropertyWithFiltering(typeId, (PropertyIndexQuery)allStringQuery, index, query);
            }
        }
        return this.relationshipsByTypeAndProperty(typeId, query, index);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, Map<String, Object> propertyValues) {
        DataLookup.checkRelationshipType(relationshipType);
        Preconditions.checkArgument((propertyValues != null ? 1 : 0) != 0, (String)"Property values can not be null");
        TokenRead tokenRead = this.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        PropertyIndexQuery.ExactPredicate[] queries = DataLookup.convertToQueries(propertyValues, tokenRead);
        return this.relationshipsByTypeAndProperties(typeId, queries);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        DataLookup.checkRelationshipType(relationshipType);
        DataLookup.checkPropertyKey(key1);
        DataLookup.checkPropertyKey(key2);
        DataLookup.checkPropertyKey(key3);
        TokenRead tokenRead = this.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        return this.relationshipsByTypeAndProperties(typeId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3, (boolean)false)));
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key1, Object value1, String key2, Object value2) {
        DataLookup.checkRelationshipType(relationshipType);
        DataLookup.checkPropertyKey(key1);
        DataLookup.checkPropertyKey(key2);
        TokenRead tokenRead = this.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        return this.relationshipsByTypeAndProperties(typeId, PropertyIndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1, (boolean)false)), PropertyIndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2, (boolean)false)));
    }

    public Relationship findRelationship(RelationshipType relationshipType, String key, Object value) {
        try (ResourceIterator<Relationship> iterator = this.findRelationships(relationshipType, key, value);){
            if (!iterator.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple relationships with type: '%s', property name: '%s' and property value: '%s' while only one was expected.", relationshipType, key, value));
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType, String key, Object value) {
        DataLookup.checkRelationshipType(relationshipType);
        DataLookup.checkPropertyKey(key);
        TokenRead tokenRead = this.tokenRead();
        int typeId = tokenRead.relationshipType(relationshipType.name());
        int propertyId = tokenRead.propertyKey(key);
        if (DataLookup.invalidTokens(typeId, propertyId)) {
            return Iterators.emptyResourceIterator();
        }
        PropertyIndexQuery.ExactPredicate query = PropertyIndexQuery.exact((int)propertyId, (Object)Values.of((Object)value, (boolean)false));
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])new int[]{propertyId}), new IndexQuery[]{query});
        return this.relationshipsByTypeAndProperty(typeId, (PropertyIndexQuery)query, index);
    }

    public ResourceIterator<Relationship> findRelationships(RelationshipType relationshipType) {
        DataLookup.checkRelationshipType(relationshipType);
        return this.allRelationshipsWithType(relationshipType);
    }

    public Iterable<Label> getAllLabelsInUse() {
        this.performCheckBeforeOperation();
        return this.allInUse(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        this.performCheckBeforeOperation();
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<Label> getAllLabels() {
        this.performCheckBeforeOperation();
        return this.all(TokenAccess.LABELS);
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        this.performCheckBeforeOperation();
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public Iterable<String> getAllPropertyKeys() {
        this.performCheckBeforeOperation();
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    private ResourceIterator<Relationship> allRelationshipsWithType(RelationshipType type) {
        int typeId = this.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return Iterators.emptyResourceIterator();
        }
        TokenPredicate query = new TokenPredicate(typeId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR, new IndexQuery[]{query});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = this.dataRead().tokenReadSession(index);
                RelationshipTypeIndexCursor cursor = this.cursors().allocateRelationshipTypeIndexCursor(this.cursorContext(), this.memoryTracker());
                this.dataRead().relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), query, this.cursorContext());
                return new TrackedCursorIterator<RelationshipTypeIndexCursor, Relationship>(cursor, RelationshipDataReader::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.allRelationshipsByTypeWithoutIndex(typeId);
    }

    private ResourceIterator<Relationship> allRelationshipsByTypeWithoutIndex(int typeId) {
        RelationshipScanCursor cursor = this.cursors().allocateRelationshipScanCursor(this.cursorContext(), this.memoryTracker());
        this.dataRead().allRelationshipsScan(cursor);
        FilteringRelationshipScanCursorWrapper filteredCursor = new FilteringRelationshipScanCursorWrapper(cursor, CursorPredicates.hasType(typeId));
        return new TrackedCursorIterator<FilteringRelationshipScanCursorWrapper, Relationship>(filteredCursor, RelationshipDataReader::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference(), c.sourceNodeReference(), c.type(), c.targetNodeReference()), this.resourceMonitor());
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        int labelId = this.tokenRead().nodeLabel(myLabel.name());
        if (labelId == -1) {
            return Iterators.emptyResourceIterator();
        }
        TokenPredicate query = new TokenPredicate(labelId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR, new IndexQuery[]{query});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = this.dataRead().tokenReadSession(index);
                NodeLabelIndexCursor cursor = this.cursors().allocateNodeLabelIndexCursor(this.cursorContext(), this.memoryTracker());
                this.dataRead().nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), query, this.cursorContext());
                return new TrackedCursorIterator<NodeLabelIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.allNodesByLabelWithoutIndex(labelId);
    }

    private ResourceIterator<Node> allNodesByLabelWithoutIndex(int labelId) {
        NodeCursor cursor = this.cursors().allocateNodeCursor(this.cursorContext(), this.memoryTracker());
        this.dataRead().allNodesScan(cursor);
        FilteringNodeCursorWrapper filteredCursor = new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(labelId));
        return new TrackedCursorIterator<FilteringNodeCursorWrapper, Node>(filteredCursor, NodeCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor());
    }

    private IndexDescriptor findUsableMatchingIndex(SchemaDescriptor schemaDescriptor, IndexType preference, IndexQuery ... query) {
        List indexes = Iterators.asList(this.getMatchingOnlineIndexes(schemaDescriptor, query));
        Optional<IndexDescriptor> preferred = indexes.stream().filter(index -> index.getIndexType() == preference).findAny();
        return preferred.orElse((IndexDescriptor)Iterators.firstOrDefault(indexes.iterator(), (Object)IndexDescriptor.NO_INDEX));
    }

    private IndexDescriptor findUsableMatchingIndex(SchemaDescriptor schemaDescriptor, IndexQuery ... query) {
        return (IndexDescriptor)Iterators.firstOrDefault(this.getMatchingOnlineIndexes(schemaDescriptor, query), (Object)IndexDescriptor.NO_INDEX);
    }

    private Iterator<IndexDescriptor> getMatchingOnlineIndexes(SchemaDescriptor schemaDescriptor, IndexQuery ... query) {
        SchemaRead schemaRead = this.schemaRead();
        Iterator iterator = schemaRead.index(schemaDescriptor);
        return Iterators.filter(index -> DataLookup.indexIsOnline(schemaRead, index) && DataLookup.indexSupportQuery(index, query), (Iterator)iterator);
    }

    private ResourceIterator<Node> nodesByLabelAndPropertyWithFiltering(int labelId, PropertyIndexQuery query, IndexDescriptor index, PropertyIndexQuery originalQuery) {
        Read read = this.dataRead();
        try {
            NodeValueIndexCursor cursor = this.cursors().allocateNodeValueIndexCursor(this.cursorContext(), this.memoryTracker());
            IndexReadSession indexSession = read.indexReadSession(index);
            read.nodeIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{query});
            return new TrackedCursorIterator<FilteringCursor, Node>(new FilteringCursor<NodeValueIndexCursor>(cursor, originalQuery), c -> cursor.nodeReference(), c -> this.newNodeEntity(cursor.nodeReference()), this.resourceMonitor());
        }
        catch (KernelException kernelException) {
            return this.getNodesByLabelAndPropertyWithoutPropertyIndex(labelId, query);
        }
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutPropertyIndex(int labelId, PropertyIndexQuery ... queries) {
        TokenPredicate tokenQuery = new TokenPredicate(labelId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR, new IndexQuery[]{tokenQuery});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = this.dataRead().tokenReadSession(index);
                NodeLabelIndexCursor cursor = this.cursors().allocateNodeLabelIndexCursor(this.cursorContext(), this.memoryTracker());
                this.dataRead().nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), tokenQuery, this.cursorContext());
                NodeCursor nodeCursor = this.cursors().allocateNodeCursor(this.cursorContext(), this.memoryTracker());
                PropertyCursor propertyCursor = this.cursors().allocatePropertyCursor(this.cursorContext(), this.memoryTracker());
                return new NodeLabelPropertyIterator(this.dataRead(), cursor, nodeCursor, propertyCursor, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor(), queries);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyViaAllNodesScan(labelId, queries);
    }

    private TrackedCursorIterator<FilteringNodeCursorWrapper, Node> getNodesByLabelAndPropertyViaAllNodesScan(int labelId, PropertyIndexQuery[] queries) {
        NodeCursor nodeCursor = this.cursors().allocateNodeCursor(this.cursorContext(), this.memoryTracker());
        FilteringNodeCursorWrapper labelFilteredCursor = new FilteringNodeCursorWrapper(nodeCursor, CursorPredicates.hasLabel(labelId));
        PropertyCursor propertyCursor = this.cursors().allocatePropertyCursor(this.cursorContext(), this.memoryTracker());
        FilteringNodeCursorWrapper propertyFilteredCursor = new FilteringNodeCursorWrapper(labelFilteredCursor, CursorPredicates.nodeMatchProperties(queries, propertyCursor), List.of(propertyCursor));
        this.dataRead().allNodesScan(nodeCursor);
        return new TrackedCursorIterator<FilteringNodeCursorWrapper, Node>(propertyFilteredCursor, NodeCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor());
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(int labelId, PropertyIndexQuery query, IndexDescriptor index) {
        Read read = this.dataRead();
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = this.cursors().allocateNodeValueIndexCursor(this.cursorContext(), this.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
                return new TrackedCursorIterator<NodeValueIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutPropertyIndex(labelId, query);
    }

    private ResourceIterator<Node> nodesByLabelAndProperties(int labelId, PropertyIndexQuery.ExactPredicate ... queries) {
        Read read = this.dataRead();
        if (DataLookup.isInvalidQuery(labelId, (PropertyIndexQuery[])queries)) {
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = DataLookup.getPropertyIds((PropertyIndexQuery[])queries);
        IndexDescriptor index = this.findUsableMatchingCompositeIndex((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds), propertyIds, () -> this.schemaRead().indexesGetForLabel(labelId), (IndexQuery[])queries);
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = this.cursors().allocateNodeValueIndexCursor(this.cursorContext(), this.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.nodeIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), DataLookup.getReorderedIndexQueries(index.schema().getPropertyIds(), (PropertyIndexQuery[])queries));
                return new TrackedCursorIterator<NodeValueIndexCursor, Node>(cursor, NodeIndexCursor::nodeReference, c -> this.newNodeEntity(c.nodeReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutPropertyIndex(labelId, (PropertyIndexQuery[])queries);
    }

    private IndexDescriptor findUsableMatchingCompositeIndex(SchemaDescriptor schemaDescriptor, int[] propertyIds, Supplier<Iterator<IndexDescriptor>> indexesSupplier, IndexQuery ... query) {
        IndexDescriptor directMatch = this.findUsableMatchingIndex(schemaDescriptor, query);
        if (directMatch != IndexDescriptor.NO_INDEX) {
            return directMatch;
        }
        Arrays.sort(propertyIds);
        DataLookup.assertNoDuplicates(propertyIds, this.tokenRead());
        int[] workingCopy = new int[propertyIds.length];
        Iterator<IndexDescriptor> indexes = indexesSupplier.get();
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            int[] original = index.schema().getPropertyIds();
            if (!DataLookup.hasSamePropertyIds(original, workingCopy, propertyIds) || !DataLookup.indexIsOnline(this.schemaRead(), index) || !DataLookup.indexSupportQuery(index, query)) continue;
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndPropertyWithFiltering(int typeId, PropertyIndexQuery query, IndexDescriptor index, PropertyIndexQuery originalQuery) {
        Read read = this.dataRead();
        try {
            RelationshipValueIndexCursor cursor = this.cursors().allocateRelationshipValueIndexCursor(this.cursorContext(), this.memoryTracker());
            IndexReadSession indexSession = read.indexReadSession(index);
            read.relationshipIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{query});
            return new TrackedCursorIterator<FilteringCursor, Relationship>(new FilteringCursor<RelationshipValueIndexCursor>(cursor, originalQuery), value -> cursor.relationshipReference(), c -> this.newRelationshipEntity(cursor.relationshipReference()), this.resourceMonitor());
        }
        catch (KernelException kernelException) {
            return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(typeId, query);
        }
    }

    private ResourceIterator<Relationship> getRelationshipsByTypeAndPropertyWithoutPropertyIndex(int typeId, PropertyIndexQuery ... queries) {
        TokenPredicate tokenQuery = new TokenPredicate(typeId);
        IndexDescriptor index = this.findUsableMatchingIndex((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR, new IndexQuery[]{tokenQuery});
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                TokenReadSession session = this.dataRead().tokenReadSession(index);
                RelationshipTypeIndexCursor cursor = this.cursors().allocateRelationshipTypeIndexCursor(this.cursorContext(), this.memoryTracker());
                this.dataRead().relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), tokenQuery, this.cursorContext());
                RelationshipScanCursor relationshipScanCursor = this.cursors().allocateRelationshipScanCursor(this.cursorContext(), this.memoryTracker());
                PropertyCursor propertyCursor = this.cursors().allocatePropertyCursor(this.cursorContext(), this.memoryTracker());
                return new RelationshipTypePropertyIterator(this.dataRead(), cursor, relationshipScanCursor, propertyCursor, c -> this.newRelationshipEntity(c.relationshipReference()), this.resourceMonitor(), queries);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyViaAllRelsScan(typeId, queries);
    }

    private ResourceIterator<Relationship> getRelationshipsByTypeAndPropertyViaAllRelsScan(int typeId, PropertyIndexQuery[] queries) {
        RelationshipScanCursor relationshipScanCursor = this.cursors().allocateRelationshipScanCursor(this.cursorContext(), this.memoryTracker());
        FilteringRelationshipScanCursorWrapper typeFiltered = new FilteringRelationshipScanCursorWrapper(relationshipScanCursor, CursorPredicates.hasType(typeId));
        PropertyCursor propertyCursor = this.cursors().allocatePropertyCursor(this.cursorContext(), this.memoryTracker());
        FilteringRelationshipScanCursorWrapper propertyFilteredCursor = new FilteringRelationshipScanCursorWrapper(typeFiltered, CursorPredicates.relationshipMatchProperties(queries, propertyCursor), List.of(propertyCursor));
        this.dataRead().allRelationshipsScan(relationshipScanCursor);
        return new TrackedCursorIterator<FilteringRelationshipScanCursorWrapper, Relationship>(propertyFilteredCursor, RelationshipDataReader::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference(), c.sourceNodeReference(), c.type(), c.targetNodeReference()), this.resourceMonitor());
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndProperty(int typeId, PropertyIndexQuery query, IndexDescriptor index) {
        Read read = this.dataRead();
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                RelationshipValueIndexCursor cursor = this.cursors().allocateRelationshipValueIndexCursor(this.cursorContext(), this.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.relationshipIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
                return new TrackedCursorIterator<RelationshipValueIndexCursor, Relationship>(cursor, RelationshipDataReader::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(typeId, query);
    }

    private ResourceIterator<Relationship> relationshipsByTypeAndProperties(int typeId, PropertyIndexQuery.ExactPredicate ... queries) {
        Read read = this.dataRead();
        if (DataLookup.isInvalidQuery(typeId, (PropertyIndexQuery[])queries)) {
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = DataLookup.getPropertyIds((PropertyIndexQuery[])queries);
        IndexDescriptor index = this.findUsableMatchingCompositeIndex((SchemaDescriptor)SchemaDescriptors.forRelType((int)typeId, (int[])propertyIds), propertyIds, () -> this.schemaRead().indexesGetForRelationshipType(typeId), (IndexQuery[])queries);
        if (index != IndexDescriptor.NO_INDEX) {
            try {
                RelationshipValueIndexCursor cursor = this.cursors().allocateRelationshipValueIndexCursor(this.cursorContext(), this.memoryTracker());
                IndexReadSession indexSession = read.indexReadSession(index);
                read.relationshipIndexSeek(this.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), DataLookup.getReorderedIndexQueries(index.schema().getPropertyIds(), (PropertyIndexQuery[])queries));
                return new TrackedCursorIterator<RelationshipValueIndexCursor, Relationship>(cursor, RelationshipDataReader::relationshipReference, c -> this.newRelationshipEntity(c.relationshipReference()), this.resourceMonitor());
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getRelationshipsByTypeAndPropertyWithoutPropertyIndex(typeId, (PropertyIndexQuery[])queries);
    }

    private <T> Iterable<T> allInUse(TokenAccess<T> tokens) {
        return () -> tokens.inUse(this.dataRead(), this.schemaRead(), this.tokenRead());
    }

    private <T> Iterable<T> all(TokenAccess<T> tokens) {
        return () -> tokens.all(this.tokenRead());
    }

    private static boolean indexIsOnline(SchemaRead schemaRead, IndexDescriptor index) {
        InternalIndexState state = InternalIndexState.FAILED;
        try {
            state = schemaRead.indexGetState(index);
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
        return state == InternalIndexState.ONLINE;
    }

    private static boolean indexSupportQuery(IndexDescriptor index, IndexQuery[] query) {
        return Arrays.stream(query).allMatch(q -> index.getCapability().isQuerySupported(q.type(), q.valueCategory()));
    }

    private static void checkPropertyKey(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Property key can not be null");
    }

    private static void checkLabel(Label label) {
        Preconditions.checkArgument((label != null ? 1 : 0) != 0, (String)"Label can not be null");
    }

    private static boolean invalidTokens(int ... tokens) {
        return Arrays.stream(tokens).anyMatch(token -> token == -1);
    }

    private static PropertyIndexQuery getIndexQuery(String value, StringSearchMode searchMode, int propertyId) {
        return switch (searchMode) {
            default -> throw new IncompatibleClassChangeError();
            case StringSearchMode.EXACT -> PropertyIndexQuery.exact((int)propertyId, (Object)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.PREFIX -> PropertyIndexQuery.stringPrefix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.SUFFIX -> PropertyIndexQuery.stringSuffix((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
            case StringSearchMode.CONTAINS -> PropertyIndexQuery.stringContains((int)propertyId, (TextValue)Values.utf8Value((byte[])value.getBytes(StandardCharsets.UTF_8)));
        };
    }

    private static boolean isInvalidQuery(int tokenId, PropertyIndexQuery[] queries) {
        if (tokenId == -1) {
            return true;
        }
        return Arrays.stream(queries).mapToInt(PropertyIndexQuery::propertyKeyId).anyMatch(propertyKeyId -> propertyKeyId == -1);
    }

    private static PropertyIndexQuery.ExactPredicate[] convertToQueries(Map<String, Object> propertyValues, TokenRead tokenRead) {
        PropertyIndexQuery.ExactPredicate[] queries = new PropertyIndexQuery.ExactPredicate[propertyValues.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            queries[i++] = PropertyIndexQuery.exact((int)tokenRead.propertyKey(entry.getKey()), (Object)Values.of((Object)entry.getValue(), (boolean)false));
        }
        return queries;
    }

    private static int[] getPropertyIds(PropertyIndexQuery[] queries) {
        int[] propertyIds = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            propertyIds[i] = queries[i].propertyKeyId();
        }
        return propertyIds;
    }

    private static void assertNoDuplicates(int[] propertyIds, TokenRead tokenRead) {
        int prev = propertyIds[0];
        for (int i = 1; i < propertyIds.length; ++i) {
            int curr = propertyIds[i];
            if (curr == prev) {
                throw new IllegalArgumentException(String.format("Provided two queries for property %s. Only one query per property key can be performed", tokenRead.propertyKeyGetName(curr)));
            }
            prev = curr;
        }
    }

    private static boolean hasSamePropertyIds(int[] original, int[] workingCopy, int[] propertyIds) {
        if (original.length == propertyIds.length) {
            System.arraycopy(original, 0, workingCopy, 0, original.length);
            Arrays.sort(workingCopy);
            return Arrays.equals(propertyIds, workingCopy);
        }
        return false;
    }

    private static PropertyIndexQuery[] getReorderedIndexQueries(int[] indexPropertyIds, PropertyIndexQuery[] queries) {
        PropertyIndexQuery[] orderedQueries = new PropertyIndexQuery[queries.length];
        block0: for (int i = 0; i < indexPropertyIds.length; ++i) {
            int propertyKeyId = indexPropertyIds[i];
            for (PropertyIndexQuery query : queries) {
                if (query.propertyKeyId() != propertyKeyId) continue;
                orderedQueries[i] = query;
                continue block0;
            }
        }
        return orderedQueries;
    }

    private static void checkRelationshipType(RelationshipType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Relationship type can not be null");
    }

    protected abstract TokenRead tokenRead();

    protected abstract SchemaRead schemaRead();

    protected abstract Read dataRead();

    protected abstract ResourceMonitor resourceMonitor();

    protected abstract Node newNodeEntity(long var1);

    protected abstract Relationship newRelationshipEntity(long var1);

    protected abstract Relationship newRelationshipEntity(long var1, long var3, int var5, long var6);

    protected abstract CursorFactory cursors();

    protected abstract CursorContext cursorContext();

    protected abstract MemoryTracker memoryTracker();

    protected abstract QueryContext queryContext();

    protected abstract ElementIdMapper elementIdMapper();

    protected abstract void performCheckBeforeOperation();

    private static class FilteringCursor<CURSOR extends Cursor & ValueIndexCursor>
    implements Cursor {
        private final CURSOR originalCursor;
        private final PropertyIndexQuery filteringQuery;

        public FilteringCursor(CURSOR originalCursor, PropertyIndexQuery filteringQuery) {
            this.originalCursor = originalCursor;
            this.filteringQuery = filteringQuery;
        }

        public void close() {
            this.originalCursor.close();
        }

        public void closeInternal() {
            this.originalCursor.closeInternal();
        }

        public boolean isClosed() {
            return this.originalCursor.isClosed();
        }

        public void setCloseListener(CloseListener closeListener) {
            this.originalCursor.setCloseListener(closeListener);
        }

        public void setToken(int token) {
            this.originalCursor.setToken(token);
        }

        public int getToken() {
            return this.originalCursor.getToken();
        }

        public boolean next() {
            boolean acceptsValue;
            boolean next;
            do {
                boolean bl = acceptsValue = (next = this.originalCursor.next()) && this.filteringQuery.acceptsValue(((ValueIndexCursor)this.originalCursor).propertyValue(0));
            } while (next && !acceptsValue);
            return next;
        }

        public void setTracer(KernelReadTracer tracer) {
            this.originalCursor.setTracer(tracer);
        }

        public void removeTracer() {
            this.originalCursor.removeTracer();
        }
    }
}

