/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.Checksum;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.InvalidLogEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEnvelopeHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class EnvelopeReadChannel
implements ReadableLogChannel {
    private static final byte CHECKSUM_SIZE = 4;
    private static final byte PAYLOAD_CHECKSUM_OFFSET_FROM_START = 18;
    private final Checksum checksum = (Checksum)ChecksumWriter.CHECKSUM_FACTORY.get();
    private final LogVersionBridge bridge;
    private final ScopedBuffer scopedBuffer;
    private final boolean raw;
    private final ByteBuffer buffer;
    private final int segmentBlockSize;
    private final ByteBuffer checksumView;
    private final int segmentShift;
    private final int segmentMask;
    private LogVersionedStoreChannel channel;
    private LogHeader logHeader;
    private boolean enforceChecksumChain;
    private int previousChecksum;
    private long currentSegment;
    private LogEnvelopeHeader.EnvelopeType payloadType;
    private long entryIndex;
    private byte payloadVersion;
    private int payloadStartOffset;
    private int payloadEndOffset;
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw) throws IOException {
        this.channel = Objects.requireNonNull(startingChannel);
        Preconditions.requirePowerOfTwo((long)segmentBlockSize);
        this.segmentBlockSize = segmentBlockSize;
        this.segmentShift = 31 - Integer.numberOfLeadingZeros(segmentBlockSize);
        this.segmentMask = segmentBlockSize - 1;
        this.bridge = Objects.requireNonNull(bridge);
        this.raw = raw;
        boolean successfulInitialization = false;
        this.scopedBuffer = new NativeScopedBuffer(segmentBlockSize, ByteOrder.LITTLE_ENDIAN, memoryTracker);
        try {
            this.buffer = this.scopedBuffer.getBuffer();
            this.checksumView = this.buffer.duplicate().order(this.buffer.order());
            long startPosition = this.channel.position();
            this.readAndValidateFileHeader(true);
            if (startPosition < (long)segmentBlockSize) {
                startPosition = segmentBlockSize;
            }
            LogPositionMarker positionMarker = new LogPositionMarker();
            positionMarker.mark(this.channel.getLogVersion(), startPosition);
            this.setLogPosition(positionMarker);
            successfulInitialization = true;
        }
        finally {
            if (!successfulInitialization) {
                this.scopedBuffer.close();
            }
        }
    }

    @VisibleForTesting
    long entryIndex() {
        return this.entryIndex;
    }

    public long getLogVersion() {
        return this.channel.getLogVersion();
    }

    public LogFormat getLogFormatVersion() {
        return this.channel.getLogFormatVersion();
    }

    public long position() {
        return this.currentSegment * (long)this.segmentBlockSize + (long)this.buffer.position();
    }

    public void position(long byteOffset) throws IOException {
        Preconditions.requireNonNegative((long)byteOffset);
        LogPositionMarker positionMarker = new LogPositionMarker();
        positionMarker.mark(this.channel.getLogVersion(), byteOffset);
        this.setLogPosition(positionMarker);
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.channel.getLogVersion(), this.position());
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(this.channel.getLogVersion(), this.position());
    }

    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        if (positionMarker.getLogVersion() != this.channel.getLogVersion()) {
            throw new IllegalArgumentException("Trying to set position with version %d while channel have version %d".formatted(positionMarker.getLogVersion(), this.channel.getLogVersion()));
        }
        long byteOffset = positionMarker.getByteOffset();
        long newSegment = byteOffset >> this.segmentShift;
        int newBufferOffset = (int)(byteOffset & (long)this.segmentMask);
        if (newSegment == 0L) {
            throw new IOException("Invalid position " + positionMarker);
        }
        if (newSegment == this.currentSegment) {
            if (newBufferOffset < this.payloadStartOffset || newBufferOffset > this.payloadEndOffset) {
                this.readAllEnvelopesUpToIncluding(newBufferOffset);
            }
        } else {
            this.loadSegmentIntoBuffer(newSegment);
            if (newBufferOffset != 0 || newSegment == 1L) {
                this.readAllEnvelopesUpToIncluding(newBufferOffset);
            }
        }
        Preconditions.checkState((newBufferOffset == 0 || newBufferOffset <= this.payloadEndOffset ? 1 : 0) != 0, (String)"Invalid end of payload.");
        this.buffer.position(Math.max(newBufferOffset, this.payloadStartOffset));
    }

    public void beginChecksum() {
    }

    public int endChecksumAndValidate() {
        return this.previousChecksum;
    }

    public int getChecksum() {
        return this.previousChecksum;
    }

    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        this.getCurrentLogPosition(marker);
        if (this.checkForEndOfEnvelope()) {
            this.readEnvelopeHeader();
        }
        Preconditions.checkState((this.payloadVersion != -1 ? 1 : 0) != 0, (String)"Could not find a valid envelope header.");
        marker.mark(this.channel.getLogVersion(), this.position());
        return this.payloadVersion;
    }

    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.buffer.get();
    }

    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.buffer.getShort();
    }

    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.buffer.getInt();
    }

    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.buffer.getLong();
    }

    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.buffer.getFloat();
    }

    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.buffer.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        assert (length <= bytes.length);
        try {
            int chunkSize;
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                if (this.checkForEndOfEnvelope()) {
                    this.readEnvelopeHeader();
                }
                chunkSize = Math.min(this.payloadEndOffset - this.buffer.position(), length - bytesRead);
                this.buffer.get(bytes, bytesRead, chunkSize);
            }
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
    }

    public byte getVersion() throws IOException {
        return this.payloadVersion;
    }

    public long goToNextEntry() throws IOException {
        do {
            this.skipToNextEnvelope();
            this.readEnvelopeHeader();
        } while (this.payloadType != LogEnvelopeHeader.EnvelopeType.FULL && this.payloadType != LogEnvelopeHeader.EnvelopeType.BEGIN);
        return this.position() - 22L;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.channel.close();
            this.scopedBuffer.close();
            this.channel = null;
            this.closed = true;
        }
    }

    private void readAllEnvelopesUpToIncluding(int bufferOffset) throws IOException {
        assert (this.currentSegment != 0L);
        this.payloadType = null;
        this.enforceChecksumChain = false;
        this.payloadVersion = (byte)-1;
        this.buffer.position(0);
        this.payloadStartOffset = 0;
        this.payloadEndOffset = 0;
        if (bufferOffset == this.buffer.limit()) {
            this.buffer.position(bufferOffset);
            this.payloadStartOffset = bufferOffset;
            this.payloadEndOffset = bufferOffset;
            return;
        }
        if (this.currentSegment == 1L) {
            this.consumeStartOffsetEnvelopeIfPresent();
            if (this.logHeader != null) {
                this.previousChecksum = this.logHeader.getPreviousLogFileChecksum();
                this.enforceChecksumChain = true;
            }
            if (bufferOffset <= this.buffer.position()) {
                return;
            }
        }
        do {
            this.readEnvelopeHeader();
            this.skipToNextEnvelope();
        } while (this.payloadEndOffset <= bufferOffset);
    }

    private void consumeStartOffsetEnvelopeIfPresent() throws IOException {
        assert (this.buffer.position() == 0) : "buffer was not positioned at 0 when started checking for START_OFFSET";
        this.buffer.getInt();
        LogEnvelopeHeader.EnvelopeType type = LogEnvelopeHeader.EnvelopeType.of((byte)this.buffer.get());
        if (type == LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
            int offsetLength = this.buffer.getInt();
            assert (offsetLength > 0) : "START_OFFSET payload length should be bigger than 0";
            this.buffer.position(22);
            this.enforceZeros(offsetLength);
            assert (this.buffer.position() == 22 + offsetLength) : "buffer should have been positioned after START_OFFSET envelope";
            this.payloadStartOffset = this.buffer.position();
            this.payloadEndOffset = this.buffer.position();
        } else {
            this.buffer.position(0);
        }
    }

    private void skipToNextEnvelope() {
        this.buffer.position(this.payloadEndOffset);
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        try {
            if (this.checkForEndOfEnvelope()) {
                this.readEnvelopeHeader();
            }
            this.bufferCheck(requestedNumberOfBytes);
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
    }

    private void handleClosedChannelException(ClosedChannelException e) throws ClosedChannelException {
        if (this.channel == null || !this.channel.isOpen()) {
            throw new IllegalStateException("This log channel has been closed", e);
        }
        throw e;
    }

    private void bufferCheck(int requestedNumberOfBytes) throws IOException {
        if (this.buffer.remaining() < requestedNumberOfBytes) {
            throw new InvalidLogEnvelopeReadException("Entry underflow. %d bytes was requested but only %d are available.".formatted(requestedNumberOfBytes, this.buffer.remaining()));
        }
    }

    private boolean checkForEndOfEnvelope() {
        assert (this.buffer.position() <= this.payloadEndOffset) : "Should not read past envelope";
        return this.buffer.position() == this.payloadEndOffset;
    }

    private void enforceTerminalZeros() throws IOException {
        this.enforceZeros(this.buffer.remaining());
    }

    private void enforceZeros(int length) throws IOException {
        Preconditions.checkState((length <= this.buffer.remaining() ? 1 : 0) != 0, (String)"Tried to enforce more zeros (%d) than the buffer's remaining size (%d).", (Object[])new Object[]{length, this.buffer.remaining()});
        while (length >= 8) {
            long value = this.buffer.getLong();
            if (value != 0L) {
                this.buffer.position(this.buffer.position() - 8);
                break;
            }
            length -= 8;
        }
        while (length > 0) {
            byte value = this.buffer.get();
            if (value != 0) {
                this.buffer.position(this.buffer.position() - 1);
                this.printExcessData();
            }
            --length;
        }
    }

    private void printExcessData() throws InvalidLogEnvelopeReadException {
        long position = this.position();
        int remaining = Math.min(this.buffer.remaining(), 1024);
        byte[] excess = new byte[remaining];
        this.buffer.get(excess);
        throw new InvalidLogEnvelopeReadException("Unexpected data found at end of buffer at position " + position + ". Expecting only zeros at this point. Found: " + Arrays.toString(excess));
    }

    private void readEnvelopeHeader() throws IOException {
        LogEnvelopeHeader.EnvelopeType nextEnvelopeType;
        int nextEnvelopeChecksum;
        block8: {
            int remaining;
            do {
                if (this.buffer.remaining() <= 22) {
                    this.enforceTerminalZeros();
                    this.nextSegment();
                }
                nextEnvelopeChecksum = this.buffer.getInt();
                nextEnvelopeType = LogEnvelopeHeader.EnvelopeType.of((byte)this.buffer.get());
                if (nextEnvelopeType == LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
                    throw new InvalidLogEnvelopeReadException(LogEnvelopeHeader.EnvelopeType.START_OFFSET, this.currentSegment, this.buffer.position() - 5);
                }
                if (nextEnvelopeType != LogEnvelopeHeader.EnvelopeType.ZERO) break block8;
                Preconditions.checkState((nextEnvelopeChecksum == 0 ? 1 : 0) != 0, (String)("Unexpected trailing data, expected zero, was: " + nextEnvelopeChecksum));
                remaining = this.buffer.remaining();
                this.enforceTerminalZeros();
            } while (remaining < 30);
            throw ReadPastEndException.INSTANCE;
        }
        int nextPayloadLength = this.buffer.getInt();
        long nextPayloadIndex = this.buffer.getLong();
        byte nextPayloadVersion = this.buffer.get();
        int previousEnvelopeChecksumFromHeader = this.buffer.getInt();
        this.payloadType = nextEnvelopeType;
        this.entryIndex = nextPayloadIndex;
        this.payloadVersion = nextPayloadVersion;
        this.payloadStartOffset = this.buffer.position();
        this.payloadEndOffset = this.payloadStartOffset + nextPayloadLength;
        if (this.payloadEndOffset > this.segmentBlockSize) {
            throw new InvalidLogEnvelopeReadException("Envelope span segment boundary: start=%d, length=%d, segmentBlockSize=%d".formatted(this.payloadStartOffset, nextPayloadLength, this.segmentBlockSize));
        }
        if (this.enforceChecksumChain) {
            if (this.previousChecksum != previousEnvelopeChecksumFromHeader) {
                throw new ChecksumMismatchException("Envelope checksum chain is broken. Previous checksum '%d', expected: '%d'.", (long)this.previousChecksum, (long)previousEnvelopeChecksumFromHeader);
            }
        } else {
            this.enforceChecksumChain = true;
        }
        this.previousChecksum = nextEnvelopeChecksum;
        this.checksumView.limit(this.payloadEndOffset).position(this.payloadStartOffset - 18);
        this.checksum.reset();
        this.checksum.update(this.checksumView);
        int readChecksum = (int)this.checksum.getValue();
        if (readChecksum != nextEnvelopeChecksum) {
            throw new ChecksumMismatchException((long)nextEnvelopeChecksum, (long)readChecksum);
        }
    }

    private void nextSegment() throws IOException {
        int read = this.loadSegmentIntoBuffer(this.currentSegment + 1L);
        if (read == -1) {
            this.goToNextFileOrThrow();
            read = this.loadSegmentIntoBuffer(1L);
        }
        if (read < 22) {
            if (read < 1) {
                throw ReadPastEndException.INSTANCE;
            }
            byte[] excess = new byte[read];
            this.buffer.get(excess);
            throw new InvalidLogEnvelopeReadException("Unexpected data found at start of buffer - expecting a valid header. Found: " + Arrays.toString(excess));
        }
    }

    private void goToNextFileOrThrow() throws IOException {
        LogVersionedStoreChannel nextChannel = this.bridge.next(this.channel, this.raw);
        assert (nextChannel != null);
        if (nextChannel == this.channel) {
            if (this.payloadType == LogEnvelopeHeader.EnvelopeType.BEGIN || this.payloadType == LogEnvelopeHeader.EnvelopeType.MIDDLE) {
                throw new IOException("Log file with version %d ended with an incomplete record type(%s) and no following log file could be found.".formatted(this.channel.getLogVersion(), this.payloadType.name()));
            }
            throw ReadPastEndException.INSTANCE;
        }
        this.channel = nextChannel;
        this.readAndValidateFileHeader(false);
    }

    private void readAndValidateFileHeader(boolean overwriteChecksum) throws IOException {
        int read = this.loadSegmentIntoBuffer(0L);
        if (read != this.segmentBlockSize) {
            return;
        }
        this.logHeader = LogFormat.parseHeader((ByteBuffer)this.buffer, (boolean)true, null);
        if (this.logHeader == null) {
            return;
        }
        this.enforceChecksumChain = true;
        if (overwriteChecksum) {
            Preconditions.checkState((this.payloadType == null ? 1 : 0) != 0, (String)"Can not override checksum in the middle of a payload");
            this.previousChecksum = this.logHeader.getPreviousLogFileChecksum();
        }
        Preconditions.checkState((this.segmentBlockSize == this.logHeader.getSegmentBlockSize() ? 1 : 0) != 0, (String)"Changing segmentBlockSize not supported");
        Preconditions.checkState((LogFormat.V9.getVersionByte() >= this.logHeader.getLogFormatVersion().getVersionByte() ? 1 : 0) != 0, (String)"Envelopes are not supported in old versions");
        Preconditions.checkState((this.previousChecksum == this.logHeader.getPreviousLogFileChecksum() ? 1 : 0) != 0, (String)"Checksum chain broken");
        this.enforceTerminalZeros();
    }

    private int loadSegmentIntoBuffer(long newSegment) throws IOException {
        this.buffer.clear();
        this.channel.position(newSegment * (long)this.segmentBlockSize);
        int totalRead = 0;
        while (this.buffer.hasRemaining()) {
            int read = this.channel.read(this.buffer);
            if (read == -1) {
                if (totalRead != 0) break;
                totalRead = -1;
                break;
            }
            totalRead += read;
        }
        this.buffer.flip();
        this.currentSegment = newSegment;
        this.payloadStartOffset = 0;
        this.payloadEndOffset = 0;
        return totalRead;
    }

    public int read(ByteBuffer dst) throws IOException {
        int length = dst.remaining();
        try {
            int chunkSize;
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                if (this.checkForEndOfEnvelope()) {
                    this.readEnvelopeHeader();
                }
                chunkSize = Math.min(this.payloadEndOffset - this.buffer.position(), length - bytesRead);
                dst.put(dst.position(), this.buffer, this.buffer.position(), chunkSize);
                dst.position(dst.position() + chunkSize);
                this.buffer.position(this.buffer.position() + chunkSize);
            }
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        return length;
    }
}

