/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.serial;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.transaction.serial.DatabaseSerialGuard;

public class MultiVersionDatabaseSerialGuard
implements DatabaseSerialGuard {
    private final AtomicLong serialExecutionStamp = new AtomicLong();
    private final Set<KernelTransactionImplementation> allTransactions;

    public MultiVersionDatabaseSerialGuard(Set<KernelTransactionImplementation> allTransactions) {
        this.allTransactions = allTransactions;
    }

    @Override
    public long serialExecution() {
        return this.serialExecutionStamp.getAcquire();
    }

    @Override
    public void acquireSerialLock(KernelTransaction ktx) {
        if (KernelTransaction.Type.SERIAL != ktx.transactionType()) {
            return;
        }
        long sequenceNumber = ktx.getTransactionSequenceNumber();
        while (!this.serialExecutionStamp.weakCompareAndSetRelease(0L, sequenceNumber)) {
            LockSupport.parkNanos(100L);
        }
        while (!this.oldTransactionCompleted(sequenceNumber)) {
            LockSupport.parkNanos(100L);
        }
        ktx.cursorContext().getVersionContext().initRead();
    }

    @Override
    public void releaseSerialLock() {
        this.serialExecutionStamp.setRelease(0L);
    }

    private boolean oldTransactionCompleted(long currentValue) {
        for (KernelTransactionImplementation transaction : this.allTransactions) {
            long sequenceNumber;
            if (!transaction.isDataTransaction() && !transaction.isSchemaTransaction() || (sequenceNumber = transaction.getTransactionSequenceNumber()) == 0L || sequenceNumber >= currentValue) continue;
            return false;
        }
        return true;
    }
}

