/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.Subject;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexAccessor<KEY extends NativeIndexKey<KEY>>
extends NativeIndex<KEY>
implements IndexAccessor {
    private final NativeIndexUpdater<KEY> singleUpdater;
    private final NativeIndexHeaderWriter headerWriter;

    NativeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY> layout, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, boolean readOnly) {
        super(databaseIndexContext, layout, indexFiles, descriptor, openOptions, readOnly);
        this.singleUpdater = new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)layout.newKey()), this.indexUpdateIgnoreStrategy(), new ThrowingConflictDetector(true, descriptor.schema().entityType()));
        this.headerWriter = new NativeIndexHeaderWriter(1);
    }

    public void drop() {
        this.tree.setDeleteOnClose(true);
        this.closeTree();
        this.indexFiles.clear();
    }

    public NativeIndexUpdater<KEY> newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        this.assertOpen();
        this.assertWritable();
        try {
            if (parallel) {
                return new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)this.layout.newKey()), this.indexUpdateIgnoreStrategy(), new ThrowingConflictDetector(true, this.descriptor.schema().entityType())).initialize((Writer<NativeIndexKey, NullValue>)this.tree.writer(cursorContext));
            }
            return this.singleUpdater.initialize(this.tree.writer(1, cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, final IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) throws IndexEntryConflictException {
        NativeIndexAccessor o = (NativeIndexAccessor)other;
        IndexEntriesReader[] readers = o.newAllEntriesValueReader(threads, CursorContext.NULL_CONTEXT);
        try {
            ArrayList handles = new ArrayList();
            int updaterFlags = readers.length == 1 ? 1 : 0;
            for (IndexEntriesReader reader : readers) {
                handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, this.databaseName, "insertFrom"), () -> {
                    ConflictDetectingValueMerger merger = new ConflictDetectingValueMerger<KEY, Value[]>(!valueUniqueness){

                        @Override
                        void doReportConflict(long existingNodeId, long addedNodeId, Value[] toReport) throws IndexEntryConflictException {
                            switch (conflictHandler.indexEntryConflict(existingNodeId, addedNodeId, toReport)) {
                                case THROW: {
                                    throw new IndexEntryConflictException(NativeIndexAccessor.this.descriptor.schema().entityType(), existingNodeId, addedNodeId, toReport);
                                }
                            }
                        }
                    };
                    try (NativeIndexUpdater<NativeIndexKey> updater = new NativeIndexUpdater<NativeIndexKey>((NativeIndexKey)((Object)((Object)this.layout.newKey())), this.indexUpdateIgnoreStrategy(), merger).initialize((Writer<NativeIndexKey, NullValue>)this.tree.writer(updaterFlags, CursorContext.NULL_CONTEXT));
                         ProgressListener localProgress = progress.threadLocalReporter();){
                        while (reader.hasNext()) {
                            long entityId = reader.next();
                            if (entityFilter == null || entityFilter.test(entityId)) {
                                if (entityIdConverter != null) {
                                    entityId = entityIdConverter.applyAsLong(entityId);
                                }
                                updater.process((IndexEntryUpdate<?>)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)this.descriptor, (Value[])reader.values()));
                            }
                            localProgress.add(1L);
                        }
                    }
                    return null;
                }));
            }
            Throwable e = this.awaitCompletionOfAll(handles);
            if (e instanceof IndexEntryConflictException) {
                IndexEntryConflictException exception = (IndexEntryConflictException)e;
                throw exception;
            }
            if (e instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)e;
                throw exception;
            }
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        finally {
            IOUtils.closeAllUnchecked((AutoCloseable[])readers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler) {
        NativeIndexAccessor o = (NativeIndexAccessor)other;
        IndexEntriesReader[] readers = o.newAllEntriesValueReader(threads, CursorContext.NULL_CONTEXT);
        try {
            ArrayList handles = new ArrayList();
            for (IndexEntriesReader fromReader : readers) {
                handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, this.databaseName, "insertFrom"), () -> {
                    try (ValueIndexReader reader = this.newValueReader(IndexUsageTracker.NO_USAGE_TRACKER);){
                        int[] propertyKeyIds = this.descriptor.schema().getPropertyIds();
                        while (fromReader.hasNext()) {
                            long entityId = fromReader.next();
                            Value[] values = fromReader.values();
                            PropertyIndexQuery[] queries = new PropertyIndexQuery[values.length];
                            for (int i = 0; i < queries.length; ++i) {
                                queries[i] = PropertyIndexQuery.exact((int)propertyKeyIds[i], (Object)values[i]);
                            }
                            try (NodeValueIterator client = new NodeValueIterator();){
                                reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), queries);
                                if (!client.hasNext()) continue;
                                long existingEntityId = client.next();
                                conflictHandler.indexEntryConflict(existingEntityId, entityId, values);
                            }
                        }
                    }
                    return null;
                }));
            }
            Throwable e = this.awaitCompletionOfAll(handles);
            if (e instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)e;
                throw exception;
            }
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        finally {
            IOUtils.closeAllUnchecked((AutoCloseable[])readers);
        }
    }

    private Throwable awaitCompletionOfAll(List<JobHandle<?>> handles) {
        Throwable e = null;
        for (JobHandle<?> handle : handles) {
            try {
                handle.get();
            }
            catch (ExecutionException ex) {
                e = Exceptions.chain(e, (Throwable)ex.getCause());
            }
            catch (InterruptedException ex) {
                e = Exceptions.chain(e, (Throwable)ex);
            }
        }
        return e;
    }

    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return IndexUpdateIgnoreStrategy.NO_IGNORE;
    }

    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)this.headerWriter, flushEvent, cursorContext);
    }

    public void refresh() {
    }

    public void close() {
        this.closeTree();
    }

    public abstract ValueIndexReader newValueReader(IndexUsageTracker var1);

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        return new NativeAllEntriesReader(this.tree, this.layout, fromIdInclusive, toIdExclusive, cursorContext);
    }

    public long estimateNumberOfEntries(CursorContext cursorContext) {
        try {
            return this.tree.estimateNumberOfEntriesInTree(cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TreeInconsistencyException e) {
            return -1L;
        }
    }

    public long sizeInBytes() {
        return this.tree.sizeInBytes();
    }

    public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        try {
            List partitionEdges = this.tree.partitionedSeek((Object)lowest, (Object)highest, partitions, cursorContext);
            ArrayList<2> readers = new ArrayList<2>();
            for (int i = 0; i < partitionEdges.size() - 1; ++i) {
                final Seeker seeker = this.tree.seek((Object)((NativeIndexKey)((Object)partitionEdges.get(i))), (Object)((NativeIndexKey)((Object)partitionEdges.get(i + 1))), cursorContext);
                readers.add(new IndexEntriesReader(){

                    public long next() {
                        return ((NativeIndexKey)((Object)seeker.key())).getEntityId();
                    }

                    public boolean hasNext() {
                        try {
                            return seeker.next();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    public Value[] values() {
                        return ((NativeIndexKey)((Object)seeker.key())).asValues();
                    }

                    public void close() {
                        try {
                            seeker.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
            }
            return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

