/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ReadOnlyTransactionStore
implements Lifecycle,
LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(FileSystemAbstraction fs, DatabaseLayout fromDatabaseLayout, Config config, Monitors monitors, CommandReaderFactory commandReaderFactory) throws IOException {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(fromDatabaseLayout, fs, KernelVersionProvider.THROWING_PROVIDER).withCommandReaderFactory(commandReaderFactory).withConfig(config).build();
        this.physicalStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, commandReaderFactory, monitors, true, config);
    }

    @Override
    public CommandBatchCursor getCommandBatches(long transactionIdToStartFrom) throws IOException {
        return this.physicalStore.getCommandBatches(transactionIdToStartFrom);
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return this.physicalStore.getCommandBatches(position);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition backToPosition) throws IOException {
        return this.physicalStore.getCommandBatchesInReverseOrder(backToPosition);
    }

    public void init() {
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }
}

