/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class ConflictingConstraintException
extends SchemaKernelException {
    private static final String CONFLICTING_CONSTRAINT_PREFIX = "Conflicting constraint already exists: ";

    private ConflictingConstraintException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintAlreadyExists, ConflictingConstraintException.constructUserMessage(tokenNameLookup, constraint));
    }

    public static ConflictingConstraintException conflictingConstraint(ConstraintDescriptor constraintWithSameSchema, TokenNameLookup token) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N66).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.constrDescrOrName, constraintWithSameSchema.userDescription(token)).build();
        return new ConflictingConstraintException(gql, constraintWithSameSchema, token);
    }

    private static String constructUserMessage(TokenNameLookup tokenNameLookup, ConstraintDescriptor constraint) {
        return CONFLICTING_CONSTRAINT_PREFIX + constraint.userDescription(tokenNameLookup);
    }
}

