/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SpdKernelTransactionDecorator;
import org.neo4j.kernel.api.database.transaction.TransactionLogServiceImpl;
import org.neo4j.kernel.api.impl.fulltext.DefaultFulltextAdapter;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.AbstractCatalogManager;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseDirectoriesCreator;
import org.neo4j.kernel.database.DatabaseKernelModule;
import org.neo4j.kernel.database.DatabaseMemoryTrackers;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.DatabaseTransactionLogModule;
import org.neo4j.kernel.database.DatabaseUpgradeTransactionHandler;
import org.neo4j.kernel.database.DbmsRuntimeFallbackKernelVersionProvider;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.database.StorageEngineFactorySupplier;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionIdSequence;
import org.neo4j.kernel.impl.api.TransactionRegistry;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.TransactionalProcessFactory;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.impl.api.txid.IdStoreTransactionIdGenerator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.multiversion.MultiVersionLockManager;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.pagecache.VersionStorageFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.store.StoreFileListing;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.UnableToMigrateException;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppenderFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointerLifecycle;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.LockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.kernel.recovery.LoggingLogTailScannerMonitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ReentrantLockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.DatabaseLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.PrefixedLog;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.Panic;
import org.neo4j.resources.CpuClock;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.enrichment.ApplyEnrichmentStrategy;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.DefaultElementIdMapperV1;
import org.neo4j.values.ElementIdMapper;

public class Database
extends AbstractDatabase {
    private static final String STORE_ID_VALIDATOR_TAG = "storeIdValidator";
    private final ServerIdentity serverIdentity;
    private final PageCache globalPageCache;
    private final TokenHolders tokenHolders;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final IdGeneratorFactory idGeneratorFactory;
    private final LockService lockService;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final DatabaseIndexStats indexStats;
    private final TransactionalProcessFactory commitProcessFactory;
    private final ConstraintSemantics constraintSemantics;
    private final GlobalProcedures globalProcedures;
    private final IOControllerService ioControllerService;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final DatabaseTracers tracers;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final LeaseService leaseService;
    private final ExternalIdReuseConditionProvider externalIdReuseConditionProvider;
    private final StorageEngineFactorySupplier storageEngineFactorySupplier;
    private TransactionIdSequence transactionIdSequence;
    private IndexProviderMap indexProviderMap;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final IdController idController;
    private final DbmsInfo dbmsInfo;
    private final TopologyGraphDbmsModel.HostedOnMode mode;
    private MetadataCache metadataCache;
    private StorageEngineFactory storageEngineFactory;
    private LockManager databaseLockManager;
    private DatabaseLayout databaseLayout;
    private StorageEngine storageEngine;
    private QueryExecutionEngine executionEngine;
    private DatabaseKernelModule kernelModule;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final QueryEngineProvider engineProvider;
    private DatabasePageCache databasePageCache;
    private CheckpointerLifecycle checkpointerLifecycle;
    private ScopedMemoryPool otherDatabasePool;
    private final GraphDatabaseFacade databaseFacade;
    private final FileLockerService fileLockerService;
    private final KernelTransactionFactory kernelTransactionFactory;
    private final DatabaseStartupController startupController;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;
    private final CursorContextFactory cursorContextFactory;
    private final VersionStorageFactory versionStorageFactory;
    private final CommandCommitListeners commandCommitListeners;
    private final SpdKernelTransactionDecorator spdKernelTransactionDecorator;
    private MemoryTracker otherDatabaseMemoryTracker;
    private RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private DatabaseAvailability databaseAvailability;
    private DatabaseTransactionEventListeners databaseTransactionEventListeners;
    private IOController ioController;
    private ElementIdMapper elementIdMapper;
    private boolean storageExists;
    private TransactionCommitmentFactory commitmentFactory;
    private VersionStorage versionStorage;

    public Database(DatabaseCreationContext context) {
        super(context.getGlobalDependencies(), context.getNamedDatabaseId(), context.getDatabaseConfig(), context.getDatabaseEventListeners(), context.getMonitors(), context.getDatabaseLogService(), context.getScheduler(), context.getDatabaseAvailabilityGuardFactory(), context.getDatabaseHealthFactory());
        this.serverIdentity = context.getServerIdentity();
        this.databaseLayout = context.getDatabaseLayout();
        this.idGeneratorFactory = context.getIdGeneratorFactory();
        this.transactionsMemoryPool = context.getTransactionsMemoryPool();
        this.otherMemoryPool = context.getOtherMemoryPool();
        this.storeCopyCheckPointMutex = context.getStoreCopyCheckPointMutex();
        this.tokenHolders = context.getTokenHolders();
        this.transactionEventListeners = context.getTransactionEventListeners();
        this.fs = context.getFs();
        this.transactionStats = context.getTransactionStats();
        this.indexStats = context.getIndexStats();
        this.constraintSemantics = context.getConstraintSemantics();
        this.globalProcedures = context.getGlobalProcedures();
        this.ioControllerService = context.getIoControllerService();
        this.clock = context.getClock();
        this.accessCapabilityFactory = context.getAccessCapabilityFactory();
        this.idController = context.getIdController();
        this.dbmsInfo = context.getDbmsInfo();
        this.mode = context.getMode();
        this.cursorContextFactory = context.getContextFactory();
        this.versionStorageFactory = context.getVersionStorageFactory();
        this.extensionFactories = context.getExtensionFactories();
        this.watcherServiceFactory = context.getWatcherServiceFactory();
        this.engineProvider = context.getEngineProvider();
        this.lockService = Database.createLockService(this.databaseConfig);
        this.commitProcessFactory = context.getCommitProcessFactory();
        this.globalPageCache = context.getPageCache();
        this.collectionsFactorySupplier = context.getCollectionsFactorySupplier();
        this.storageEngineFactorySupplier = context.getStorageEngineFactorySupplier();
        this.spdKernelTransactionDecorator = context.getSpdKernelTransactionDecorator();
        TransactionalContext.DatabaseMode databaseMode = this.spdKernelTransactionDecorator != null ? TransactionalContext.DatabaseMode.SHARDED : TransactionalContext.DatabaseMode.SINGLE;
        this.databaseFacade = new GraphDatabaseFacade(this, (Config)this.databaseConfig, this.dbmsInfo, this.mode, databaseMode, this.databaseAvailabilityGuard);
        this.kernelTransactionFactory = new FacadeKernelTransactionFactory((Config)this.databaseConfig, this.databaseFacade);
        this.tracers = context.getTracers();
        this.fileLockerService = context.getFileLockerService();
        this.leaseService = context.getLeaseService();
        this.startupController = context.getStartupController();
        this.readOnlyDatabaseChecker = context.getDbmsReadOnlyChecker().forDatabase(this.namedDatabaseId);
        this.externalIdReuseConditionProvider = context.externalIdReuseConditionProvider();
        this.commandCommitListeners = context.getCommandCommitListeners();
    }

    @Override
    protected void specificInit() throws IOException {
        this.storageEngineFactory = this.storageEngineFactorySupplier.create();
        LockManager storageLockManager = this.storageEngineFactory.createLockManager((Config)this.databaseConfig, this.clock);
        this.databaseLockManager = Database.isNotMultiVersioned(this.databaseConfig) ? storageLockManager : new MultiVersionLockManager(storageLockManager);
        this.databaseLayout = this.storageEngineFactory.formatSpecificDatabaseLayout(this.databaseLayout);
        new DatabaseDirectoriesCreator(this.fs, this.databaseLayout).createDirectories();
        this.ioController = this.ioControllerService.createIOController((Config)this.databaseConfig, this.clock);
        this.transactionIdSequence = new TransactionIdSequence();
        this.versionStorage = this.versionStorageFactory.createVersionStorage(this.globalPageCache, this.ioController, this.scheduler, (LogProvider)this.internalLogProvider, this.databaseDependencies, this.tracers, this.databaseLayout, this.databaseConfig);
        this.databasePageCache = new DatabasePageCache(this.globalPageCache, this.ioController, this.versionStorage, (Config)this.databaseConfig);
        this.life.add((Lifecycle)this.versionStorage);
        this.life.add(Database.onShutdown(() -> this.databaseLockManager.close()));
        this.life.add((Lifecycle)new LockerLifecycleAdapter(this.fileLockerService.createDatabaseLocker(this.fs, this.databaseLayout)));
        this.life.add((Lifecycle)this.databaseConfig);
        this.databaseAvailability = new DatabaseAvailability(this.databaseAvailabilityGuard, this.transactionStats, (Clock)this.clock, this.getAwaitActiveTransactionDeadlineMillis());
        this.databaseDependencies.satisfyDependency((Object)this.ioController);
        this.databaseDependencies.satisfyDependency((Object)this.transactionIdSequence);
        this.databaseDependencies.satisfyDependency((Object)this.readOnlyDatabaseChecker);
        this.databaseDependencies.satisfyDependency((Object)this.databaseLayout);
        this.databaseDependencies.satisfyDependency((Object)this.startupController);
        this.databaseDependencies.satisfyDependency((Object)this.databasePageCache);
        this.databaseDependencies.satisfyDependency((Object)this.versionStorage);
        this.databaseDependencies.satisfyDependency((Object)this.tokenHolders);
        this.databaseDependencies.satisfyDependency((Object)this.databaseFacade);
        this.databaseDependencies.satisfyDependency((Object)this.kernelTransactionFactory);
        this.databaseDependencies.satisfyDependency((Object)this.storeCopyCheckPointMutex);
        this.databaseDependencies.satisfyDependency((Object)this.transactionStats);
        this.databaseDependencies.satisfyDependency((Object)this.indexStats);
        this.databaseDependencies.satisfyDependency((Object)this.databaseLockManager);
        this.databaseDependencies.satisfyDependency((Object)this.databaseAvailability);
        this.databaseDependencies.satisfyDependency((Object)this.idGeneratorFactory);
        this.databaseDependencies.satisfyDependency((Object)this.idController);
        this.databaseDependencies.satisfyDependency((Object)this.lockService);
        this.databaseDependencies.satisfyDependency((Object)this.cursorContextFactory);
        this.databaseDependencies.satisfyDependency((Object)this.tracers);
        this.databaseDependencies.satisfyDependency((Object)this.tracers.getDatabaseTracer());
        this.databaseDependencies.satisfyDependency((Object)this.tracers.getPageCacheTracer());
        this.databaseDependencies.satisfyDependency((Object)this.storageEngineFactory);
        this.databaseDependencies.satisfyDependencies(new Object[]{this.mode});
        this.databaseDependencies.satisfyDependencies(new Object[]{this.commandCommitListeners});
        this.recoveryCleanupWorkCollector = (RecoveryCleanupWorkCollector)this.life.add((Lifecycle)new GroupingRecoveryCleanupWorkCollector(this.scheduler, Group.INDEX_CLEANUP, Group.INDEX_CLEANUP_WORK, this.databaseLayout.getDatabaseName()));
        this.databaseDependencies.satisfyDependency((Object)this.recoveryCleanupWorkCollector);
        this.otherDatabasePool = this.otherMemoryPool.newDatabasePool(this.namedDatabaseId.name(), 0L, null);
        this.life.add(Database.onShutdown(() -> this.otherDatabasePool.close()));
        this.otherDatabaseMemoryTracker = this.otherDatabasePool.getPoolMemoryTracker();
        this.databaseDependencies.satisfyDependency((Object)new DatabaseMemoryTrackers(this.otherDatabaseMemoryTracker));
        this.life.add(Database.onShutdown(() -> ((VersionStorage)this.versionStorage).close()));
        this.life.add((Lifecycle)new PageCacheLifecycle(this.databasePageCache));
        this.life.add((Lifecycle)this.initializeExtensions(this.databaseDependencies));
        this.life.add(this.initializeIndexProviderMap(this.databaseDependencies));
        DatabaseLayoutWatcher watcherService = this.watcherServiceFactory.apply(this.databaseLayout);
        this.life.add((Lifecycle)watcherService);
        this.databaseDependencies.satisfyDependency((Object)watcherService);
        if (this.isSystem() && this.databaseDependencies.containsDependency(AbstractCatalogManager.class)) {
            AbstractCatalogManager catalogManager = (AbstractCatalogManager)((Object)this.databaseDependencies.resolveDependency(AbstractCatalogManager.class));
            this.life.add((Lifecycle)catalogManager);
        }
    }

    @Override
    protected void specificStart() throws IOException {
        this.databaseMonitors.addMonitorListener((Object)new LoggingLogFileMonitor(this.internalLog), new String[0]);
        this.databaseMonitors.addMonitorListener((Object)new LoggingLogTailScannerMonitor(this.internalLogProvider.getLog(DetachedLogTailScanner.class)), new String[0]);
        this.databaseMonitors.addMonitorListener((Object)new ReverseTransactionCursorLoggingMonitor(this.internalLogProvider.getLog(ReversedSingleFileCommandBatchCursor.class)), new String[0]);
        this.databaseMonitors.addMonitorListener((Object)this.indexStats, new String[0]);
        this.upgradeStore(this.databaseConfig, this.databasePageCache, this.otherDatabaseMemoryTracker);
        LogTailMetadata tailMetadata = this.getLogTail();
        long lastClosedTxId = tailMetadata.getLastCommittedTransaction().id();
        this.initialiseContextFactory(() -> new TransactionIdSnapshot(lastClosedTxId), () -> lastClosedTxId);
        this.storageExists = this.storageEngineFactory.storageExists(this.fs, this.databaseLayout);
        this.validateStoreAndTxLogs(tailMetadata, this.cursorContextFactory, this.storageExists);
        if (Recovery.performRecovery(Recovery.context(this.fs, this.globalPageCache, this.tracers, (Config)this.databaseConfig, this.databaseLayout, this.otherDatabaseMemoryTracker, this.ioController, (InternalLogProvider)this.internalLogProvider, tailMetadata).recoveryPredicate(RecoveryPredicate.ALL).monitors(this.databaseMonitors).extensionFactories(this.extensionFactories).startupChecker(new RecoveryStartupChecker(this.startupController, this.namedDatabaseId)).clock((Clock)this.clock))) {
            tailMetadata = this.getLogTail();
            long recoveredTxId = tailMetadata.getLastCommittedTransaction().id();
            this.initialiseContextFactory(() -> new TransactionIdSnapshot(recoveredTxId), () -> recoveredTxId);
        }
        this.metadataCache = (MetadataCache)this.databaseDependencies.satisfyDependency((Object)new MetadataCache(tailMetadata));
        DatabaseSchemaState databaseSchemaState = new DatabaseSchemaState((InternalLogProvider)this.internalLogProvider);
        this.idController.initialize(this.fs, this.databaseLayout.file("id-buffer.tmp"), (Config)this.databaseConfig, () -> this.kernelModule.kernelTransactions().get(), () -> this.kernelModule.transactionMonitor().oldestObservableHorizon(), s -> this.kernelModule.kernelTransactions().eligibleForFreeing(s), this.otherDatabaseMemoryTracker, this.readOnlyDatabaseChecker);
        this.storageEngine = this.storageEngineFactory.instantiate(this.fs, (Clock)this.clock, this.databaseLayout, (Config)this.databaseConfig, (PageCache)this.databasePageCache, this.tokenHolders, (SchemaState)databaseSchemaState, (ConstraintRuleAccessor)this.constraintSemantics, (IndexConfigCompleter)this.indexProviderMap, this.lockService, this.idGeneratorFactory, this.databaseHealth, (InternalLogProvider)this.internalLogProvider, (InternalLogProvider)this.userLogProvider, this.recoveryCleanupWorkCollector, tailMetadata, (KernelVersionRepository)this.metadataCache, this.otherDatabaseMemoryTracker, this.cursorContextFactory, this.tracers.getPageCacheTracer(), this.versionStorage);
        MetadataProvider metadataProvider = (MetadataProvider)this.databaseDependencies.satisfyDependency((Object)this.storageEngine.metadataProvider());
        this.initialiseContextFactory(Database.getTransactionIdSnapshotFactory(this.databaseConfig, metadataProvider), Database.getOldestTransactionIdFactory(this.databaseConfig, () -> this.kernelModule));
        this.elementIdMapper = new DefaultElementIdMapperV1(this.namedDatabaseId);
        LogFiles logFiles = this.getLogFiles();
        this.life.add((Lifecycle)this.storageEngine);
        this.life.add(this.storageEngine.schemaAndTokensLifecycle());
        this.life.add((Lifecycle)logFiles);
        FullScanStoreView fullScanStoreView = new FullScanStoreView(this.lockService, (ReadableStorageEngine)this.storageEngine, (Config)this.databaseConfig, this.scheduler);
        LockService indexStoreViewLocks = this.storageEngine.indexingBehaviour().requireCoordinationLocks() ? this.lockService : LockService.NO_LOCK_SERVICE;
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory((Config)this.databaseConfig, (ReadableStorageEngine)this.storageEngine, this.databaseLockManager, fullScanStoreView, indexStoreViewLocks, (InternalLogProvider)this.internalLogProvider);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore((PageCache)this.databasePageCache, this.fs, this.databaseLayout, this.recoveryCleanupWorkCollector, false, this.cursorContextFactory, this.tracers.getPageCacheTracer(), this.storageEngine.getOpenOptions());
        this.life.add((Lifecycle)indexStatisticsStore);
        IndexingService indexingService = this.buildIndexingService(this.storageEngine, databaseSchemaState, indexStoreViewFactory, indexStatisticsStore, this.otherDatabaseMemoryTracker, (KernelVersionProvider)this.metadataCache);
        this.databaseDependencies.satisfyDependency((Object)this.storageEngine.countsAccessor());
        DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, this.storageEngine, this.databasePageCache);
        DatabaseTransactionLogModule transactionLogModule = this.buildTransactionLogs(logFiles, (Config)this.databaseConfig, (InternalLogProvider)this.internalLogProvider, this.scheduler, forceOperation, metadataProvider, this.databaseMonitors, this.databaseDependencies, this.cursorContextFactory, this.storageEngineFactory.commandReaderFactory());
        this.commitmentFactory = new TransactionCommitmentFactory((TransactionIdStore)metadataProvider);
        this.databaseTransactionEventListeners = new DatabaseTransactionEventListeners(this.databaseFacade, this.transactionEventListeners, this.namedDatabaseId);
        this.life.add((Lifecycle)this.databaseTransactionEventListeners);
        DatabaseKernelModule kernelModule = this.buildKernel(logFiles, transactionLogModule, indexingService, databaseSchemaState, this.storageEngine, (TransactionIdStore)metadataProvider, (KernelVersionProvider)this.metadataCache, this.databaseAvailabilityGuard, this.clock, indexStatisticsStore, this.leaseService, this.cursorContextFactory);
        kernelModule.satisfyDependencies(this.databaseDependencies);
        this.kernelModule = kernelModule;
        this.databaseDependencies.satisfyDependency((Object)this.commitmentFactory);
        this.databaseDependencies.satisfyDependency((Object)databaseSchemaState);
        this.databaseDependencies.satisfyDependency((Object)this.storageEngine);
        this.databaseDependencies.satisfyDependency((Object)indexingService);
        this.databaseDependencies.satisfyDependency((Object)indexStoreViewFactory);
        this.databaseDependencies.satisfyDependency((Object)indexStatisticsStore);
        this.databaseDependencies.satisfyDependency((Object)this.indexProviderMap);
        this.databaseDependencies.satisfyDependency((Object)forceOperation);
        this.databaseDependencies.satisfyDependency((Object)this.storageEngine.storeEntityCounters());
        this.databaseDependencies.satisfyDependency((Object)this.elementIdMapper);
        QueryEngineProvider.SPI providerSpi = QueryEngineProvider.spi((InternalLogProvider)this.internalLogProvider, this.databaseMonitors, this.scheduler, this.life, this.getKernel(), (Config)this.databaseConfig);
        this.executionEngine = QueryEngineProvider.initialize(this.databaseDependencies, this.databaseFacade, this.engineProvider, this.isSystem(), providerSpi);
        this.checkpointerLifecycle = new CheckpointerLifecycle(transactionLogModule.checkPointer(), (Panic)this.databaseHealth);
        this.life.add((Lifecycle)this.idController);
        this.life.add(Database.onStart(this::registerUpgradeListener));
        this.life.add((Lifecycle)this.databaseHealth);
        this.life.add((Lifecycle)this.databaseAvailabilityGuard);
        this.life.add((Lifecycle)this.databaseAvailability);
        this.life.setLast((Lifecycle)this.checkpointerLifecycle);
        this.life.add(Database.onStop(() -> this.executionEngine.clearQueryCaches()));
        ((DbmsDiagnosticsManager)this.databaseDependencies.resolveDependency(DbmsDiagnosticsManager.class)).dumpDatabaseDiagnostics(this);
    }

    @Override
    protected void specificStop() {
        this.databaseConfig.removeListener(GraphDatabaseSettings.track_query_cpu_time, this.cpuChangeListener);
    }

    @Override
    protected void specificShutdown() {
    }

    private void initialiseContextFactory(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestTransactionIdFactory) {
        this.cursorContextFactory.init(transactionIdSnapshotFactory, oldestTransactionIdFactory);
    }

    @Override
    protected void postStartupInit() throws Exception {
        if (!this.storageExists) {
            if (((Boolean)this.databaseConfig.get(GraphDatabaseInternalSettings.skip_default_indexes_on_creation)).booleanValue()) {
                return;
            }
            try (KernelTransaction tx = this.kernelModule.kernelAPI().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                this.createLookupIndex(tx, EntityType.NODE);
                this.createLookupIndex(tx, EntityType.RELATIONSHIP);
                tx.commit();
            }
            this.checkpointAfterStartupInit();
        }
    }

    private void checkpointAfterStartupInit() throws IOException {
        CheckPointerImpl checkPointer = (CheckPointerImpl)this.databaseDependencies.resolveDependency(CheckPointerImpl.class);
        checkPointer.forceCheckPoint(new SimpleTriggerInfo("Database init completed."));
    }

    private void createLookupIndex(KernelTransaction tx, EntityType entityType) throws KernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)entityType);
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)descriptor).withIndexType(IndexType.LOOKUP).withIndexProvider(this.indexProviderMap.getTokenIndexProvider().getProviderDescriptor());
        prototype = prototype.withName(SchemaNameUtil.generateName((SchemaDescriptorSupplier)prototype));
        tx.schemaWrite().indexCreate(prototype);
    }

    private LogTailMetadata getLogTail() throws IOException {
        return this.getLogFiles().getTailMetadata();
    }

    private LogFiles getLogFiles() throws IOException {
        return LogFilesBuilder.builder(this.databaseLayout, this.fs, new DbmsRuntimeFallbackKernelVersionProvider(this.databaseDependencies, this.databaseLayout.getDatabaseName(), (Config)this.databaseConfig)).withConfig((Config)this.databaseConfig).withDependencies((DependencyResolver)this.databaseDependencies).withLogProvider((InternalLogProvider)this.internalLogProvider).withDatabaseTracers(this.tracers).withMemoryTracker(this.otherDatabaseMemoryTracker).withMonitors(this.databaseMonitors).withClock((Clock)this.clock).withStorageEngineFactory(this.storageEngineFactory).build();
    }

    private void registerUpgradeListener() {
        DatabaseUpgradeTransactionHandler handler = new DatabaseUpgradeTransactionHandler((DbmsRuntimeVersionProvider)this.globalDependencies.resolveDependency(DbmsRuntimeVersionProvider.class), (KernelVersionProvider)this.metadataCache, this.databaseTransactionEventListeners, UpgradeLocker.DEFAULT, (InternalLogProvider)this.internalLogProvider, (Config)this.databaseConfig, this.kernelModule.kernelAPI());
        handler.registerUpgradeListener((fromKernelVersion, toKernelVersion, tx) -> tx.upgrade().upgradeKernel(new Upgrade.KernelUpgrade(fromKernelVersion, toKernelVersion)));
    }

    private void validateStoreAndTxLogs(LogTailMetadata logTail, CursorContextFactory contextFactory, boolean storageExists) throws IOException {
        if (storageExists) {
            this.checkStoreId(logTail, contextFactory);
        } else {
            this.validateLogsAndStoreAbsence(logTail);
        }
    }

    private void validateLogsAndStoreAbsence(LogTailMetadata logTail) {
        if (!logTail.logsMissing()) {
            throw new RuntimeException(String.format("Fail to start '%s' since transaction logs were found, while database files are missing.", this.namedDatabaseId));
        }
    }

    private void checkStoreId(LogTailMetadata tailMetadata, CursorContextFactory contextFactory) throws IOException {
        try (CursorContext cursorContext = contextFactory.create(STORE_ID_VALIDATOR_TAG);){
            Recovery.validateStoreId(tailMetadata, this.storageEngineFactory.retrieveStoreId(this.fs, this.databaseLayout, (PageCache)this.databasePageCache, cursorContext));
        }
    }

    private LifeSupport initializeExtensions(Dependencies dependencies) {
        LifeSupport extensionsLife = new LifeSupport();
        extensionsLife.add((Lifecycle)new DatabaseExtensions(new DatabaseExtensionContext(this.databaseLayout, this.dbmsInfo, (DependencySatisfier)dependencies), this.extensionFactories, dependencies, ExtensionFailureStrategies.fail()));
        extensionsLife.init();
        return extensionsLife;
    }

    private Lifecycle initializeIndexProviderMap(Dependencies dependencies) {
        LifeSupport indexProvidersLife = new LifeSupport();
        StaticIndexProviderMap indexProviderMap = StaticIndexProviderMapFactory.create(indexProvidersLife, (Config)this.databaseConfig, this.databasePageCache, this.fs, (LogService)this.databaseLogService, this.databaseMonitors, this.readOnlyDatabaseChecker, this.mode, this.recoveryCleanupWorkCollector, this.databaseLayout, this.tokenHolders, this.scheduler, this.cursorContextFactory, this.tracers.getPageCacheTracer(), (DependencyResolver)dependencies);
        this.indexProviderMap = (IndexProviderMap)indexProvidersLife.add((Lifecycle)indexProviderMap);
        dependencies.satisfyDependency((Object)this.indexProviderMap);
        dependencies.satisfyDependency((Object)new DefaultFulltextAdapter((FulltextIndexProvider)this.indexProviderMap.getFulltextProvider()));
        indexProvidersLife.init();
        return indexProvidersLife;
    }

    private void upgradeStore(DatabaseConfig databaseConfig, DatabasePageCache databasePageCache, MemoryTracker memoryTracker) throws IOException {
        IndexProviderMap indexProviderMap = (IndexProviderMap)this.databaseDependencies.resolveDependency(IndexProviderMap.class);
        Suppliers.Lazy logTailSupplier = Suppliers.lazySingleton(() -> {
            try {
                return new LogTailExtractor(this.fs, (Config)databaseConfig, this.storageEngineFactory, this.tracers).getTailMetadata(this.databaseLayout, memoryTracker, new DbmsRuntimeFallbackKernelVersionProvider(this.databaseDependencies, this.databaseLayout.getDatabaseName(), (Config)databaseConfig));
            }
            catch (Exception e) {
                throw new UnableToMigrateException("Fail to load log tail during upgrade.", e);
            }
        });
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, (Config)databaseConfig, (LogService)this.databaseLogService, databasePageCache, this.tracers, this.scheduler, this.databaseLayout, this.storageEngineFactory, this.storageEngineFactory, indexProviderMap, memoryTracker, (Supplier<LogTailMetadata>)logTailSupplier);
        storeMigrator.upgradeIfNeeded();
    }

    private IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, IndexStoreViewFactory indexStoreViewFactory, IndexStatisticsStore indexStatisticsStore, MemoryTracker memoryTracker, KernelVersionProvider kernelVersionProvider) {
        return (IndexingService)this.life.add((Lifecycle)Database.buildIndexingService(storageEngine, databaseSchemaState, indexStoreViewFactory, indexStatisticsStore, this.indexStats, (Config)this.databaseConfig, this.scheduler, this.indexProviderMap, (TokenNameLookup)this.tokenHolders, this.elementIdMapper, (InternalLogProvider)this.internalLogProvider, (IndexMonitor)this.databaseMonitors.newMonitor(IndexMonitor.class, new String[0]), this.cursorContextFactory, memoryTracker, this.namedDatabaseId.name(), this.readOnlyDatabaseChecker, (Clock)this.clock, kernelVersionProvider, this.fs, new KernelTransactionVisibilityProvider()));
    }

    public static IndexingService buildIndexingService(StorageEngine storageEngine, DatabaseSchemaState databaseSchemaState, IndexStoreViewFactory indexStoreViewFactory, IndexStatisticsStore indexStatisticsStore, DatabaseIndexStats indexCounters, Config config, JobScheduler jobScheduler, IndexProviderMap indexProviderMap, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, InternalLogProvider internalLogProvider, IndexMonitor indexMonitor, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, DatabaseReadOnlyChecker readOnlyChecker, Clock clock, KernelVersionProvider kernelVersionProvider, FileSystemAbstraction fs, TransactionVisibilityProvider transactionVisibilityProvider) {
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((ReadableStorageEngine)storageEngine, config, jobScheduler, indexProviderMap, indexStoreViewFactory, tokenNameLookup, elementIdMapper, Database.initialSchemaRulesLoader(storageEngine), internalLogProvider, indexMonitor, databaseSchemaState, indexStatisticsStore, indexCounters, contextFactory, memoryTracker, databaseName, readOnlyChecker, clock, kernelVersionProvider, fs, transactionVisibilityProvider);
        storageEngine.addIndexUpdateListener((IndexUpdateListener)indexingService);
        return indexingService;
    }

    @Override
    public boolean isSystem() {
        return this.namedDatabaseId.isSystemDatabase();
    }

    private DatabaseTransactionLogModule buildTransactionLogs(LogFiles logFiles, Config config, InternalLogProvider logProvider, JobScheduler scheduler, CheckPointerImpl.ForceOperation forceOperation, MetadataProvider metadataProvider, Monitors monitors, Dependencies databaseDependencies, CursorContextFactory cursorContextFactory, CommandReaderFactory commandReaderFactory) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        databaseDependencies.satisfyDependencies(new Object[]{transactionMetadataCache});
        ReentrantLock pruneLock = new ReentrantLock();
        LogPruningImpl logPruning = new LogPruningImpl(this.fs, logFiles, logProvider, new LogPruneStrategyFactory(), (Clock)this.clock, config, pruneLock);
        TransactionAppender transactionAppender = TransactionAppenderFactory.createTransactionAppender(logFiles, (TransactionIdStore)metadataProvider, (AppendIndexProvider)metadataProvider, config, (Panic)this.databaseHealth, scheduler, logProvider, transactionMetadataCache);
        this.life.add((Lifecycle)transactionAppender);
        PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, commandReaderFactory, monitors, true, config);
        CheckPointThreshold threshold = CheckPointThreshold.createThreshold(config, this.clock, logPruning, logProvider);
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        CheckPointerImpl checkPointer = new CheckPointerImpl(metadataProvider, threshold, forceOperation, logPruning, checkpointAppender, (Panic)this.databaseHealth, logProvider, this.tracers, this.storeCopyCheckPointMutex, cursorContextFactory, (Clock)this.clock, this.ioController, (KernelVersionProvider)this.metadataCache);
        long recurringPeriod = threshold.checkFrequencyMillis();
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, scheduler, recurringPeriod, (Panic)this.databaseHealth, this.namedDatabaseId.name());
        this.life.add((Lifecycle)checkPointer);
        this.life.add((Lifecycle)checkPointScheduler);
        TransactionLogServiceImpl transactionLogService = new TransactionLogServiceImpl(metadataProvider, logFiles, logicalTransactionStore, pruneLock, this.databaseAvailabilityGuard, logProvider, checkPointer, commandReaderFactory, (BinarySupportedKernelVersions)databaseDependencies.resolveDependency(BinarySupportedKernelVersions.class));
        databaseDependencies.satisfyDependencies(new Object[]{checkPointer, logFiles, logicalTransactionStore, transactionAppender, transactionLogService});
        return new DatabaseTransactionLogModule(checkPointer, transactionAppender, transactionMetadataCache, logicalTransactionStore);
    }

    private DatabaseKernelModule buildKernel(LogFiles logFiles, DatabaseTransactionLogModule logsModule, IndexingService indexingService, DatabaseSchemaState databaseSchemaState, StorageEngine storageEngine, TransactionIdStore transactionIdStore, KernelVersionProvider kernelVersionProvider, AvailabilityGuard databaseAvailabilityGuard, SystemNanoClock clock, IndexStatisticsStore indexStatisticsStore, LeaseService leaseService, CursorContextFactory cursorContextFactory) {
        AtomicReference<CpuClock> cpuClockRef = this.setupCpuClockAtomicReference();
        TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(logsModule.transactionAppender(), storageEngine, this.readOnlyDatabaseChecker, (Boolean)this.databaseConfig.get(GraphDatabaseInternalSettings.out_of_disk_space_protection), this.commandCommitListeners);
        TransactionRollbackProcess rollbackProcess = this.commitProcessFactory.createRollbackProcess(storageEngine, logsModule.getLogicalTransactionStore());
        this.databaseDependencies.satisfyDependency((Object)rollbackProcess);
        TransactionValidatorFactory transactionValidatorFactory = storageEngine.createTransactionValidatorFactory((Config)this.databaseConfig);
        Supplier<Kernel> kernelProvider = () -> this.kernelModule.kernelAPI();
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService, (InternalLogProvider)this.internalLogProvider);
        TransactionExecutionMonitor transactionExecutionMonitor = (TransactionExecutionMonitor)this.getMonitors().newMonitor(TransactionExecutionMonitor.class, new String[0]);
        IdStoreTransactionIdGenerator transactionIdGenerator = new IdStoreTransactionIdGenerator(transactionIdStore);
        this.databaseDependencies.satisfyDependency((Object)transactionIdGenerator);
        if (!this.databaseDependencies.containsDependency(ApplyEnrichmentStrategy.class)) {
            this.databaseDependencies.satisfyDependency((Object)ApplyEnrichmentStrategy.NO_ENRICHMENT);
        }
        KernelTransactions kernelTransactions = (KernelTransactions)this.life.add((Lifecycle)new KernelTransactions((Config)this.databaseConfig, this.databaseLockManager, constraintIndexCreator, transactionCommitProcess, rollbackProcess, this.databaseTransactionEventListeners, this.transactionStats, databaseAvailabilityGuard, storageEngine, this.globalProcedures, (DbmsRuntimeVersionProvider)this.globalDependencies.resolveDependency(DbmsRuntimeVersionProvider.class), transactionIdStore, kernelVersionProvider, this.serverIdentity, clock, cpuClockRef, this.accessCapabilityFactory, cursorContextFactory, this.collectionsFactorySupplier, this.constraintSemantics, databaseSchemaState, this.tokenHolders, this.elementIdMapper, this.getNamedDatabaseId(), indexingService, indexStatisticsStore, this.databaseDependencies, this.tracers, leaseService, this.transactionsMemoryPool, this.readOnlyDatabaseChecker, transactionExecutionMonitor, this.externalIdReuseConditionProvider.get(transactionIdStore, (Clock)clock), this.commitmentFactory, this.transactionIdSequence, transactionIdGenerator, this.databaseHealth, transactionValidatorFactory, (LogProvider)this.internalLogProvider, this.spdKernelTransactionDecorator, this.mode));
        KernelTransactionMonitor transactionMonitor = this.buildTransactionMonitor(kernelTransactions, transactionIdStore, (Config)this.databaseConfig);
        KernelImpl kernel = new KernelImpl(kernelTransactions, (Panic)this.databaseHealth, this.transactionStats, this.globalProcedures, (Config)this.databaseConfig, storageEngine, transactionExecutionMonitor);
        this.life.add((Lifecycle)kernel);
        StoreFileListing fileListing = new StoreFileListing(this.databaseLayout, logFiles, indexingService, storageEngine);
        this.databaseDependencies.satisfyDependency((Object)fileListing);
        return new DatabaseKernelModule(transactionCommitProcess, kernel, kernelTransactions, fileListing, transactionMonitor, transactionIdGenerator);
    }

    private KernelTransactionMonitor buildTransactionMonitor(KernelTransactions kernelTransactions, TransactionIdStore transactionIdStore, Config config) {
        KernelTransactionMonitor kernelTransactionMonitor = new KernelTransactionMonitor(kernelTransactions, transactionIdStore, config, this.clock, (LogService)this.databaseLogService);
        this.databaseDependencies.satisfyDependency((Object)kernelTransactionMonitor);
        TransactionMonitorScheduler transactionMonitorScheduler = new TransactionMonitorScheduler(kernelTransactionMonitor, this.scheduler, ((Duration)config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis(), this.namedDatabaseId.name());
        this.life.add((Lifecycle)transactionMonitorScheduler);
        return kernelTransactionMonitor;
    }

    @Override
    protected void safeCleanup() throws Exception {
        ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{() -> Database.safeLifeShutdown(this.life), () -> Database.safeStorageEngineClose(this.storageEngine), () -> Database.safePoolRelease(this.otherDatabasePool)});
    }

    @Override
    public void prepareToDrop() {
        this.prepareStop(Predicates.alwaysTrue());
        this.checkpointerLifecycle.setCheckpointOnShutdown(false);
    }

    @Override
    protected void deleteDatabaseFilesOnDrop() {
        this.deleteDatabaseFiles(List.of(this.databaseLayout.databaseDirectory(), this.databaseLayout.getTransactionLogsDirectory(), this.databaseLayout.getScriptDirectory()));
    }

    private void deleteDatabaseFiles(List<Path> files) {
        try {
            for (Path fileToDelete : files) {
                FileSystemUtils.deleteFile((FileSystemAbstraction)this.fs, (Path)fileToDelete);
            }
        }
        catch (IOException e) {
            ((PrefixedLog)this.internalLogProvider.getLog(Database.class)).error(String.format("Failed to delete '%s' files.", this.namedDatabaseId), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected TransactionRegistry transactionRegistry() {
        return this.kernelModule.kernelTransactions();
    }

    @Override
    public Config getConfig() {
        return this.databaseConfig;
    }

    @Override
    public DatabaseLogService getLogService() {
        return this.databaseLogService;
    }

    @Override
    public DatabaseLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    @Override
    public StoreId getStoreId() {
        return this.storageEngine.retrieveStoreId();
    }

    @Override
    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    @Override
    public QueryExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    @Override
    public Kernel getKernel() {
        return this.kernelModule.kernelAPI();
    }

    @Override
    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        StoreFileListing.Builder fileListingBuilder = this.getStoreFileListing().builder();
        fileListingBuilder.excludeIdFiles();
        if (!includeLogs) {
            fileListingBuilder.excludeLogFiles();
        }
        return fileListingBuilder.build();
    }

    @Override
    public StoreFileListing getStoreFileListing() {
        return this.kernelModule.fileListing();
    }

    @Override
    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    @Override
    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    @Override
    public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
        return this.databaseAvailabilityGuard;
    }

    @Override
    public GraphDatabaseAPI getDatabaseAPI() {
        return this.databaseFacade;
    }

    @Override
    public DatabaseTracers getTracers() {
        return this.tracers;
    }

    @Override
    public MemoryTracker getOtherDatabaseMemoryTracker() {
        return this.otherDatabaseMemoryTracker;
    }

    @Override
    public StorageEngineFactory getStorageEngineFactory() {
        return this.storageEngineFactory;
    }

    @Override
    public IOController getIoController() {
        return this.ioController;
    }

    @Override
    public CursorContextFactory getCursorContextFactory() {
        return this.cursorContextFactory;
    }

    @Override
    public ElementIdMapper getElementIdMapper() {
        return this.elementIdMapper;
    }

    public long estimateAvailableReservedSpace() {
        return this.storageEngine.estimateAvailableReservedSpace();
    }

    private void prepareStop(Predicate<PagedFile> deleteFilePredicate) {
        this.databasePageCache.listExistingMappings().stream().filter(deleteFilePredicate).forEach(file -> file.setDeleteOnClose(true));
    }

    private long getAwaitActiveTransactionDeadlineMillis() {
        return ((Duration)this.databaseConfig.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
    }

    public static Iterable<IndexDescriptor> initialSchemaRulesLoader(StorageEngine storageEngine) {
        return () -> {
            try (StorageReader reader = storageEngine.newReader();){
                Iterator iterator = Iterators.asList((Iterator)reader.indexesGetAll()).iterator();
                return iterator;
            }
        };
    }

    private static void safeStorageEngineClose(StorageEngine storageEngine) {
        if (storageEngine != null) {
            storageEngine.shutdown();
        }
    }

    private static void safePoolRelease(ScopedMemoryPool pool) {
        if (pool != null) {
            pool.close();
        }
    }

    private static void safeLifeShutdown(LifeSupport life) {
        if (life != null) {
            life.shutdown();
        }
    }

    private static LockService createLockService(DatabaseConfig databaseConfig) {
        return Database.isNotMultiVersioned(databaseConfig) ? new ReentrantLockService() : LockService.NO_LOCK_SERVICE;
    }

    private static TransactionIdSnapshotFactory getTransactionIdSnapshotFactory(DatabaseConfig databaseConfig, MetadataProvider metadataProvider) {
        return Database.isNotMultiVersioned(databaseConfig) ? () -> new TransactionIdSnapshot(metadataProvider.getLastClosedTransactionId()) : () -> ((MetadataProvider)metadataProvider).getClosedTransactionSnapshot();
    }

    private static OldestTransactionIdFactory getOldestTransactionIdFactory(DatabaseConfig databaseConfig, Supplier<DatabaseKernelModule> kernelModule) {
        return Database.isNotMultiVersioned(databaseConfig) ? OldestTransactionIdFactory.EMPTY_OLDEST_ID_FACTORY : () -> ((DatabaseKernelModule)kernelModule.get()).transactionMonitor().oldestVisibleClosedTransactionId();
    }

    private static boolean isNotMultiVersioned(DatabaseConfig databaseConfig) {
        return !"multiversion".equals(databaseConfig.get(GraphDatabaseSettings.db_format));
    }

    private class KernelTransactionVisibilityProvider
    implements TransactionVisibilityProvider {
        private KernelTransactionVisibilityProvider() {
        }

        @Override
        public long oldestVisibleClosedTransactionId() {
            return Database.this.kernelModule.transactionMonitor().oldestVisibleClosedTransactionId();
        }

        @Override
        public long oldestObservableHorizon() {
            return Database.this.kernelModule.transactionMonitor().oldestObservableHorizon();
        }

        @Override
        public long youngestObservableHorizon() {
            return Database.this.kernelModule.transactionMonitor().youngestObservableHorizon();
        }
    }
}

